/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail.helpers;

import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;

class RDFSailRemover
extends AbstractRDFHandler {
    private final SailConnection con;
    private final ValueFactory vf;
    private final UpdateContext uc;
    private Resource[] contexts = new Resource[0];

    public RDFSailRemover(SailConnection con, ValueFactory vf, UpdateContext uc) {
        this.con = con;
        this.vf = vf;
        this.uc = uc;
    }

    public void enforceContext(Resource ... contexts) {
        Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
        this.contexts = contexts;
    }

    public boolean enforcesContext() {
        return this.contexts.length != 0;
    }

    public Resource[] getContexts() {
        return this.contexts;
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        Resource ctxt = st.getContext();
        try {
            if (this.enforcesContext()) {
                this.con.removeStatement(this.uc, subj, pred, obj, this.contexts);
            } else if (ctxt == null) {
                Set<IRI> removeGraphs = this.uc.getDataset().getDefaultRemoveGraphs();
                if (!removeGraphs.isEmpty()) {
                    Resource[] ctxts = removeGraphs.toArray(new IRI[removeGraphs.size()]);
                    this.con.removeStatement(this.uc, subj, pred, obj, ctxts);
                } else {
                    this.con.removeStatement(this.uc, subj, pred, obj, new Resource[0]);
                }
            } else {
                this.con.removeStatement(this.uc, subj, pred, obj, ctxt);
            }
        }
        catch (SailException e) {
            throw new RDFHandlerException(e);
        }
    }
}

