/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.SubQueryValueOperator;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public class FilterIterator
extends FilterIteration<BindingSet, QueryEvaluationException> {
    private final Filter filter;
    private final EvaluationStrategy strategy;
    private final Set<String> scopeBindingNames;
    private final QueryValueEvaluationStep condition;

    public FilterIterator(Filter filter, CloseableIteration<BindingSet, QueryEvaluationException> iter, QueryValueEvaluationStep ves, EvaluationStrategy strategy) throws QueryEvaluationException {
        super(iter);
        this.filter = filter;
        this.strategy = strategy;
        this.condition = ves;
        this.scopeBindingNames = filter.getBindingNames();
    }

    private boolean isPartOfSubQuery(QueryModelNode node) {
        if (node instanceof SubQueryValueOperator) {
            return true;
        }
        QueryModelNode parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        return this.isPartOfSubQuery(parent);
    }

    protected boolean accept(BindingSet bindings) throws QueryEvaluationException {
        try {
            QueryBindingSet scopeBindings = new QueryBindingSet(bindings);
            if (!this.isPartOfSubQuery((QueryModelNode)this.filter)) {
                scopeBindings.retainAll(this.scopeBindingNames);
            }
            return this.strategy.isTrue(this.condition, (BindingSet)scopeBindings);
        }
        catch (ValueExprEvaluationException e) {
            return false;
        }
    }
}

