/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public abstract class LoggingCloseableIteration
implements CloseableIteration<ValidationTuple, SailException> {
    private final ValidationExecutionLogger validationExecutionLogger;
    private final PlanNode planNode;
    private boolean empty = false;
    private boolean closed;

    public LoggingCloseableIteration(PlanNode planNode, ValidationExecutionLogger validationExecutionLogger) {
        this.planNode = planNode;
        this.validationExecutionLogger = validationExecutionLogger;
    }

    public final ValidationTuple next() throws SailException {
        ValidationTuple tuple = this.loggingNext();
        if (this.validationExecutionLogger.isEnabled()) {
            this.validationExecutionLogger.log(this.planNode.depth(), this.planNode.getClass().getSimpleName() + ".next()", tuple, this.planNode, this.planNode.getId(), null);
        }
        return tuple;
    }

    public final boolean hasNext() throws SailException {
        if (this.empty) {
            return false;
        }
        boolean hasNext = this.localHasNext();
        if (!hasNext) {
            this.empty = true;
            assert (!this.localHasNext()) : "Iterator was initially empty, but still has more elements! " + this.getClass();
            this.close();
        }
        return hasNext;
    }

    public void close() throws SailException {
        if (!this.closed) {
            this.closed = true;
            this.localClose();
        }
    }

    protected abstract ValidationTuple loggingNext() throws SailException;

    protected abstract boolean localHasNext() throws SailException;

    protected abstract void localClose() throws SailException;

    public void remove() throws SailException {
        throw new UnsupportedOperationException();
    }
}

