/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExprRenderer;
import org.eclipse.rdf4j.federated.algebra.FedXStatementPattern;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.exception.IllegalQueryException;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.util.FilterUtils;
import org.eclipse.rdf4j.federated.util.QueryAlgebraUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStringUtil {
    private static final Logger log = LoggerFactory.getLogger(QueryStringUtil.class);
    public static final IRI BNODE_URI = FedXUtil.iri("http://fluidops.com/fedx/bnode");

    public static boolean hasFreeVars(StatementPattern stmt, BindingSet bindings) {
        for (Var var : stmt.getVarList()) {
            if (var.hasValue() || bindings.hasBinding(var.getName())) continue;
            return true;
        }
        return false;
    }

    public static String toString(StatementPattern stmt) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        QueryStringUtil.appendVar(sb, stmt.getSubjectVar(), new HashSet<String>(), EmptyBindingSet.getInstance());
        sb.append("; ");
        QueryStringUtil.appendVar(sb, stmt.getPredicateVar(), new HashSet<String>(), EmptyBindingSet.getInstance());
        sb.append("; ");
        QueryStringUtil.appendVar(sb, stmt.getObjectVar(), new HashSet<String>(), EmptyBindingSet.getInstance());
        sb.append("}");
        return sb.toString();
    }

    public static String toString(ArbitraryLengthPath node, Set<String> varNames, BindingSet bindings) {
        if (!(node.getPathExpression() instanceof StatementPattern)) {
            throw new IllegalArgumentException("Can only handle path expressions of type StatementPattern, was " + node.getPathExpression().getClass());
        }
        StatementPattern stmt = (StatementPattern)node.getPathExpression();
        StringBuilder sb = new StringBuilder();
        sb = QueryStringUtil.appendVar(sb, stmt.getSubjectVar(), varNames, bindings).append(" ");
        sb = QueryStringUtil.appendVar(sb, stmt.getPredicateVar(), varNames, bindings);
        sb.append(node.getMinLength() == 0L ? "*" : "+");
        sb.append(" ");
        sb = QueryStringUtil.appendVar(sb, stmt.getObjectVar(), varNames, bindings).append(" . ");
        return sb.toString();
    }

    public static String toString(Var var) {
        if (!var.hasValue()) {
            return "?" + var.getName();
        }
        return QueryStringUtil.getValueString(var.getValue());
    }

    public static String toString(Resource subj, IRI pred, Value obj) {
        return QueryStringUtil.toString(QueryAlgebraUtil.toStatementPattern(subj, pred, obj));
    }

    public static String selectQueryString(StatementPattern stmt, BindingSet bindings, FilterValueExpr filterExpr, AtomicBoolean evaluated, Dataset dataset) throws IllegalQueryException {
        long upperLimit;
        HashSet<String> varNames = new HashSet<String>();
        String s = QueryStringUtil.constructStatement(stmt, varNames, bindings);
        StringBuilder res = new StringBuilder();
        res.append("SELECT ");
        if (varNames.isEmpty()) {
            throw new IllegalQueryException("SELECT query needs at least one projection!");
        }
        for (String var : varNames) {
            res.append(" ?").append(var);
        }
        res.append(" ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append("WHERE { ").append(s);
        if (filterExpr != null) {
            try {
                String filter = FilterUtils.toSparqlString(filterExpr);
                res.append("FILTER ").append(filter);
                evaluated.set(true);
            }
            catch (Exception e) {
                log.debug("Filter could not be evaluated remotely. " + e.getMessage());
                log.trace("Details: ", (Throwable)e);
            }
        }
        res.append(" }");
        if (stmt instanceof FedXStatementPattern && (upperLimit = ((FedXStatementPattern)stmt).getUpperLimit()) > 0L) {
            res.append(" LIMIT ").append(upperLimit);
        }
        return res.toString();
    }

    public static String selectQueryString(ExclusiveTupleExprRenderer expr, BindingSet bindings, FilterValueExpr filterExpr, AtomicBoolean evaluated, Dataset dataset) throws IllegalQueryException {
        HashSet<String> varNames = new HashSet<String>();
        String s = QueryStringUtil.constructJoinArg(expr, varNames, bindings);
        StringBuilder res = new StringBuilder();
        res.append("SELECT ");
        if (varNames.isEmpty()) {
            throw new IllegalQueryException("SELECT query needs at least one projection!");
        }
        for (String var : varNames) {
            res.append(" ?").append(var);
        }
        res.append(" ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append("WHERE { ").append(s);
        if (filterExpr != null) {
            try {
                String filter = FilterUtils.toSparqlString(filterExpr);
                res.append("FILTER ").append(filter);
                evaluated.set(true);
            }
            catch (Exception e) {
                log.debug("Filter could not be evaluated remotely. " + e.getMessage());
                log.trace("Details: ", (Throwable)e);
            }
        }
        res.append(" }");
        return res.toString();
    }

    public static String selectQueryString(ExclusiveGroup group, BindingSet bindings, FilterValueExpr filterExpr, AtomicBoolean evaluated, Dataset dataset) throws IllegalQueryException {
        StringBuilder sb = new StringBuilder();
        HashSet<String> varNames = new HashSet<String>();
        for (ExclusiveTupleExpr exclusiveTupleExpr : group.getExclusiveExpressions()) {
            sb.append(QueryStringUtil.constructJoinArg(exclusiveTupleExpr, varNames, bindings));
        }
        if (varNames.isEmpty()) {
            throw new IllegalQueryException("SELECT query needs at least one projection!");
        }
        StringBuilder res = new StringBuilder();
        res.append("SELECT  ");
        for (String var : varNames) {
            res.append(" ?").append(var);
        }
        res.append(" ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append("WHERE { ").append((CharSequence)sb);
        if (filterExpr != null) {
            try {
                String string = FilterUtils.toSparqlString(filterExpr);
                res.append("FILTER ").append(string);
                evaluated.set(true);
            }
            catch (Exception exception) {
                log.debug("Filter could not be evaluated remotely. " + exception.getMessage());
                log.trace("Details", (Throwable)exception);
            }
        }
        res.append(" }");
        return res.toString();
    }

    public static String askQueryString(ExclusiveTupleExpr expr, BindingSet bindings, Dataset dataset) {
        HashSet<String> varNames = new HashSet<String>();
        StringBuilder res = new StringBuilder();
        res.append("ASK ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append("{ ").append(QueryStringUtil.constructJoinArg(expr, varNames, bindings)).append(" }");
        return res.toString();
    }

    @Deprecated
    public static String selectQueryStringBoundUnion(StatementPattern stmt, List<BindingSet> unionBindings, FilterValueExpr filterExpr, Boolean evaluated, Dataset dataset) {
        HashSet<String> varNames = new HashSet<String>();
        StringBuilder unions = new StringBuilder();
        for (int i = 0; i < unionBindings.size(); ++i) {
            String s = QueryStringUtil.constructStatementId(stmt, Integer.toString(i), varNames, unionBindings.get(i));
            if (i > 0) {
                unions.append(" UNION");
            }
            unions.append(" { ").append(s).append(" }");
        }
        StringBuilder res = new StringBuilder();
        res.append("SELECT ");
        for (String var : varNames) {
            res.append(" ?").append(var);
        }
        res.append(" ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append("WHERE { ");
        res.append((CharSequence)unions);
        res.append(" }");
        return res.toString();
    }

    public static String selectQueryStringBoundJoinVALUES(StatementPattern stmt, List<BindingSet> unionBindings, FilterValueExpr filterExpr, AtomicBoolean evaluated, Dataset dataset) {
        LinkedHashSet<String> varNames = new LinkedHashSet<String>();
        StringBuilder res = new StringBuilder();
        String stmtPattern = QueryStringUtil.constructStatement(stmt, varNames, new EmptyBindingSet());
        res.append("SELECT ");
        for (String var : varNames) {
            res.append(" ?").append(var);
        }
        res.append(" ?").append("__index");
        res.append(" ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append("WHERE {");
        res.append(" VALUES (");
        for (String var : varNames) {
            res.append("?").append(var).append(" ");
        }
        res.append(" ?__index) { ");
        int index = 0;
        for (BindingSet b : unionBindings) {
            res.append("(");
            for (String var : varNames) {
                if (b.hasBinding(var)) {
                    QueryStringUtil.appendValue(res, b.getValue(var)).append(" ");
                    continue;
                }
                res.append("UNDEF ");
            }
            res.append("\"").append(index).append("\") ");
            ++index;
        }
        res.append(" } ");
        res.append(stmtPattern);
        res.append(" }");
        return res.toString();
    }

    public static String selectQueryStringBoundCheck(StatementPattern stmt, List<BindingSet> unionBindings, Dataset dataset) {
        HashSet<String> varNames = new HashSet<String>();
        StringBuilder unions = new StringBuilder();
        for (int i = 0; i < unionBindings.size(); ++i) {
            String s = QueryStringUtil.constructStatementCheckId(stmt, i, varNames, unionBindings.get(i));
            if (i > 0) {
                unions.append(" UNION");
            }
            unions.append(" { ").append(s).append(" }");
        }
        StringBuilder res = new StringBuilder();
        res.append("SELECT ");
        for (String var : varNames) {
            res.append(" ?").append(var);
        }
        res.append(" ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append("WHERE {");
        res.append((CharSequence)unions).append(" }");
        return res.toString();
    }

    protected static String constructInnerUnion(StatementPattern stmt, int outerID, Set<String> varNames, List<BindingSet> bindings) {
        StringBuilder innerUnion = new StringBuilder();
        for (int idx = 0; idx < bindings.size(); ++idx) {
            if (idx > 0) {
                innerUnion.append("UNION ");
            }
            innerUnion.append("{").append(QueryStringUtil.constructStatementId(stmt, outerID + "_" + idx, varNames, bindings.get(idx))).append("} ");
        }
        return innerUnion.toString();
    }

    protected static String constructJoinArg(ExclusiveTupleExpr exclusiveExpr, Set<String> varNames, BindingSet bindings) {
        if (exclusiveExpr instanceof StatementPattern) {
            return QueryStringUtil.constructStatement((StatementPattern)((Object)exclusiveExpr), varNames, bindings);
        }
        if (exclusiveExpr instanceof ExclusiveGroup) {
            StringBuilder sb = new StringBuilder();
            for (ExclusiveTupleExpr s : ((ExclusiveGroup)exclusiveExpr).getExclusiveExpressions()) {
                sb.append(QueryStringUtil.constructJoinArg(s, varNames, bindings));
            }
            return sb.toString();
        }
        if (!(exclusiveExpr instanceof ExclusiveTupleExprRenderer)) {
            throw new IllegalStateException("Cannot render tupl expr of type " + exclusiveExpr.getClass());
        }
        return ((ExclusiveTupleExprRenderer)exclusiveExpr).toQueryString(varNames, bindings);
    }

    public static String askQueryString(StatementPattern stmt, BindingSet bindings, Dataset dataset) {
        HashSet<String> varNames = new HashSet<String>();
        String s = QueryStringUtil.constructStatement(stmt, varNames, bindings);
        StringBuilder res = new StringBuilder();
        res.append("ASK ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append(" { ");
        res.append(s).append(" }");
        return res.toString();
    }

    public static String selectQueryStringLimit1(StatementPattern stmt, BindingSet bindings, Dataset dataset) {
        HashSet<String> varNames = new HashSet<String>();
        String s = QueryStringUtil.constructStatement(stmt, varNames, bindings);
        StringBuilder res = new StringBuilder();
        res.append("SELECT * ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append("WHERE { ");
        res.append(s).append(" } LIMIT 1");
        return res.toString();
    }

    public static String selectQueryStringLimit1(ExclusiveTupleExpr expr, BindingSet bindings, Dataset dataset) {
        if (expr instanceof ExclusiveGroup) {
            return QueryStringUtil.selectQueryStringLimit1((ExclusiveGroup)expr, bindings, dataset);
        }
        HashSet<String> varNames = new HashSet<String>();
        String s = QueryStringUtil.constructJoinArg(expr, varNames, bindings);
        StringBuilder res = new StringBuilder();
        res.append("SELECT * ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append("WHERE {");
        res.append(s).append(" } LIMIT 1");
        return res.toString();
    }

    public static String selectQueryStringLimit1(ExclusiveGroup group, BindingSet bindings, Dataset dataset) {
        HashSet<String> varNames = new HashSet<String>();
        StringBuilder res = new StringBuilder();
        res.append("SELECT * ");
        QueryStringUtil.appendDatasetClause(res, dataset);
        res.append("WHERE {");
        for (ExclusiveTupleExpr s : group.getExclusiveExpressions()) {
            res.append(QueryStringUtil.constructJoinArg(s, varNames, bindings));
        }
        res.append(" } LIMIT 1");
        return res.toString();
    }

    protected static String constructStatement(StatementPattern stmt, Set<String> varNames, BindingSet bindings) {
        StringBuilder sb = new StringBuilder();
        if (stmt.getScope().equals((Object)StatementPattern.Scope.NAMED_CONTEXTS)) {
            sb.append("GRAPH ");
            QueryStringUtil.appendVar(sb, stmt.getContextVar(), varNames, bindings);
            sb.append(" { ");
        }
        sb = QueryStringUtil.appendVar(sb, stmt.getSubjectVar(), varNames, bindings).append(" ");
        sb = QueryStringUtil.appendVar(sb, stmt.getPredicateVar(), varNames, bindings).append(" ");
        sb = QueryStringUtil.appendVar(sb, stmt.getObjectVar(), varNames, bindings).append(" . ");
        if (stmt.getScope().equals((Object)StatementPattern.Scope.NAMED_CONTEXTS)) {
            sb.append("} ");
        }
        return sb.toString();
    }

    protected static String constructStatementId(StatementPattern stmt, String varID, Set<String> varNames, BindingSet bindings) {
        StringBuilder sb = new StringBuilder();
        sb = QueryStringUtil.appendVarId(sb, stmt.getSubjectVar(), varID, varNames, bindings).append(" ");
        sb = QueryStringUtil.appendVarId(sb, stmt.getPredicateVar(), varID, varNames, bindings).append(" ");
        sb = QueryStringUtil.appendVarId(sb, stmt.getObjectVar(), varID, varNames, bindings).append(" . ");
        return sb.toString();
    }

    protected static String constructStatementCheckId(StatementPattern stmt, int varID, Set<String> varNames, BindingSet bindings) {
        String objValue;
        StringBuilder sb = new StringBuilder();
        String _varID = Integer.toString(varID);
        sb = QueryStringUtil.appendVarId(sb, stmt.getSubjectVar(), _varID, varNames, bindings).append(" ");
        sb = QueryStringUtil.appendVarId(sb, stmt.getPredicateVar(), _varID, varNames, bindings).append(" ");
        sb.append("?o_").append(_varID);
        varNames.add("o_" + _varID);
        if (stmt.getObjectVar().hasValue()) {
            objValue = QueryStringUtil.getValueString(stmt.getObjectVar().getValue());
        } else if (bindings.hasBinding(stmt.getObjectVar().getName())) {
            objValue = QueryStringUtil.getValueString(bindings.getBinding(stmt.getObjectVar().getName()).getValue());
        } else {
            throw new RuntimeException("Unexpected.");
        }
        sb.append(" FILTER (?o_").append(_varID).append(" = ").append(objValue).append(" )");
        return sb.toString();
    }

    protected static StringBuilder appendVar(StringBuilder sb, Var var, Set<String> varNames, BindingSet bindings) {
        if (!var.hasValue()) {
            if (bindings.hasBinding(var.getName())) {
                return QueryStringUtil.appendValue(sb, bindings.getValue(var.getName()));
            }
            varNames.add(var.getName());
            return sb.append("?").append(var.getName());
        }
        return QueryStringUtil.appendValue(sb, var.getValue());
    }

    protected static StringBuilder appendVarId(StringBuilder sb, Var var, String varID, Set<String> varNames, BindingSet bindings) {
        if (!var.hasValue()) {
            if (bindings.hasBinding(var.getName())) {
                return QueryStringUtil.appendValue(sb, bindings.getValue(var.getName()));
            }
            String newName = var.getName() + "_" + varID;
            varNames.add(newName);
            return sb.append("?").append(newName);
        }
        return QueryStringUtil.appendValue(sb, var.getValue());
    }

    protected static String getValueString(Value value) {
        StringBuilder sb = new StringBuilder();
        QueryStringUtil.appendValue(sb, value);
        return sb.toString();
    }

    protected static StringBuilder appendValue(StringBuilder sb, Value value) {
        if (value instanceof IRI) {
            return QueryStringUtil.appendURI(sb, (IRI)value);
        }
        if (value instanceof Literal) {
            return QueryStringUtil.appendLiteral(sb, (Literal)value);
        }
        if (value instanceof BNode) {
            return QueryStringUtil.appendBNode(sb, (BNode)value);
        }
        throw new RuntimeException("Type not supported: " + value.getClass().getCanonicalName());
    }

    protected static StringBuilder appendURI(StringBuilder sb, IRI uri) {
        sb.append("<").append(uri.stringValue()).append(">");
        return sb;
    }

    protected static StringBuilder appendBNode(StringBuilder sb, BNode bNode) {
        log.debug("Cannot express BNodes in SPARQl: Bnode " + bNode.toString() + " is replaced with " + BNODE_URI.stringValue());
        return QueryStringUtil.appendURI(sb, BNODE_URI);
    }

    protected static StringBuilder appendLiteral(StringBuilder sb, Literal lit) {
        sb.append("'''");
        sb.append(lit.getLabel().replace("\"", "\\\""));
        sb.append("'''");
        if (lit.getLanguage().isPresent()) {
            sb.append('@');
            sb.append(lit.getLanguage().get());
        } else if (lit.getDatatype() != null) {
            sb.append("^^<");
            sb.append(lit.getDatatype().stringValue());
            sb.append('>');
        }
        return sb;
    }

    public static List<String> loadQueries(String queryFile) throws FileNotFoundException, IOException {
        ArrayList<String> res = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new FileReader(queryFile));){
            String tmp;
            Object tmpQuery = "";
            while ((tmp = in.readLine()) != null) {
                if (tmp.isEmpty()) {
                    if (!((String)tmpQuery).isEmpty()) {
                        res.add((String)tmpQuery);
                    }
                    tmpQuery = "";
                    continue;
                }
                tmpQuery = (String)tmpQuery + tmp;
            }
            if (!((String)tmpQuery).isEmpty()) {
                res.add((String)tmpQuery);
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
    }

    private static StringBuilder appendDatasetClause(StringBuilder sb, Dataset dataset) {
        if (dataset == null) {
            return sb;
        }
        for (IRI context : dataset.getDefaultGraphs()) {
            sb.append("FROM <").append(context.stringValue()).append("> ");
        }
        for (IRI namedContext : dataset.getNamedGraphs()) {
            sb.append("FROM NAMED <").append(namedContext.stringValue()).append("> ");
        }
        return sb;
    }
}

