/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutorBase;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public abstract class JoinExecutorBase<T>
extends ParallelExecutorBase<T> {
    protected final TupleExpr rightArg;
    protected final BindingSet bindings;
    protected Set<String> joinVars;
    protected CloseableIteration<T, QueryEvaluationException> leftIter;

    public JoinExecutorBase(FederationEvalStrategy strategy, CloseableIteration<T, QueryEvaluationException> leftIter, TupleExpr rightArg, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        super(queryInfo);
        this.leftIter = leftIter;
        this.rightArg = rightArg;
        this.bindings = bindings;
    }

    @Override
    protected final void performExecution() throws Exception {
        this.handleBindings();
    }

    protected abstract void handleBindings() throws Exception;

    @Override
    public void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.leftIter.close();
        }
    }

    @Override
    protected String getExecutorType() {
        return "Join";
    }

    public Set<String> getJoinVars() {
        return this.joinVars;
    }

    public void setJoinVars(Set<String> joinVars) {
        this.joinVars = joinVars;
    }
}

