/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core.query;

import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElement;
import org.eclipse.rdf4j.sparqlbuilder.core.query.GraphManagementQuery;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;

public abstract class DestinationSourceManagementQuery<T extends DestinationSourceManagementQuery<T>>
extends GraphManagementQuery<DestinationSourceManagementQuery<T>> {
    private static String DEFAULT = "DEFAULT";
    private static String TO = "TO";
    private Optional<Iri> from = Optional.empty();
    private Optional<Iri> to = Optional.empty();
    private boolean fromDefault = false;
    private boolean toDefault = false;

    public T from(Iri from) {
        this.from = Optional.ofNullable(from);
        return this.fromDefault(false);
    }

    public T from(IRI from) {
        return this.from(Rdf.iri(from));
    }

    public T to(Iri to) {
        this.to = Optional.ofNullable(to);
        return this.toDefault(false);
    }

    public T to(IRI to) {
        return this.to(Rdf.iri(to));
    }

    public T fromDefault() {
        return this.fromDefault(true);
    }

    public T fromDefault(boolean fromDefault) {
        this.fromDefault = fromDefault;
        return (T)this;
    }

    public T toDefault() {
        return this.toDefault(true);
    }

    public T toDefault(boolean toDefault) {
        this.toDefault = toDefault;
        return (T)this;
    }

    protected abstract String getQueryActionString();

    @Override
    public String getQueryString() {
        StringBuilder query = new StringBuilder();
        query.append(this.getQueryActionString()).append(" ");
        this.appendSilent(query);
        query.append(this.from.filter(f -> !this.fromDefault).map(QueryElement::getQueryString).orElse(DEFAULT));
        query.append(" ").append(TO).append(" ");
        query.append(this.to.filter(t -> !this.toDefault).map(QueryElement::getQueryString).orElse(DEFAULT));
        return query.toString();
    }
}

