/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.SailConflictException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailDatasetImpl;
import org.eclipse.rdf4j.sail.base.SailSink;

abstract class Changeset
implements SailSink,
ModelFactory {
    private Set<SailDatasetImpl> refbacks;
    private Set<Changeset> prepend;
    private Set<SimpleStatementPattern> observed;
    private Model approved;
    private Model deprecated;
    private Set<Resource> approvedContexts;
    private Set<Resource> deprecatedContexts;
    private Map<String, String> addedNamespaces;
    private Set<String> removedPrefixes;
    private boolean namespaceCleared;
    private boolean statementCleared;
    private boolean closed;

    Changeset() {
    }

    @Override
    public void close() throws SailException {
        this.closed = true;
        this.refbacks = null;
        this.prepend = null;
        this.observed = null;
        this.approved = null;
        this.deprecated = null;
        this.approvedContexts = null;
        this.deprecatedContexts = null;
        this.addedNamespaces = null;
        this.removedPrefixes = null;
    }

    @Override
    public void prepare() throws SailException {
        assert (!this.closed);
        if (this.prepend != null && this.observed != null) {
            for (SimpleStatementPattern p : this.observed) {
                Resource subj = p.getSubject();
                IRI pred = p.getPredicate();
                Value obj = p.getObject();
                Resource context = p.getContext();
                Resource[] contexts = p.isAllContexts() ? new Resource[]{} : new Resource[]{context};
                for (Changeset changeset : this.prepend) {
                    if (!changeset.hasApproved(subj, pred, obj, contexts) && !changeset.hasDeprecated(subj, pred, obj, contexts)) continue;
                    throw new SailConflictException("Observed State has Changed");
                }
            }
        }
    }

    synchronized boolean hasApproved(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        assert (!this.closed);
        if (this.approved == null) {
            return false;
        }
        return this.approved.contains(subj, pred, obj, contexts);
    }

    synchronized boolean hasDeprecated(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        assert (!this.closed);
        if (this.deprecated == null) {
            return false;
        }
        return this.deprecated.contains(subj, pred, obj, contexts);
    }

    public synchronized void addRefback(SailDatasetImpl dataset) {
        assert (!this.closed);
        if (this.refbacks == null) {
            this.refbacks = new HashSet<SailDatasetImpl>();
        }
        this.refbacks.add(dataset);
    }

    public synchronized void removeRefback(SailDatasetImpl dataset) {
        assert (!this.closed);
        if (this.refbacks != null) {
            this.refbacks.remove(dataset);
        }
    }

    public synchronized boolean isRefback() {
        assert (!this.closed);
        return this.refbacks != null && !this.refbacks.isEmpty();
    }

    public synchronized void prepend(Changeset changeset) {
        assert (!this.closed);
        if (this.prepend == null) {
            this.prepend = new HashSet<Changeset>();
        }
        this.prepend.add(changeset);
    }

    @Override
    public synchronized void setNamespace(String prefix, String name) {
        assert (!this.closed);
        if (this.removedPrefixes == null) {
            this.removedPrefixes = new HashSet<String>();
        }
        this.removedPrefixes.add(prefix);
        if (this.addedNamespaces == null) {
            this.addedNamespaces = new HashMap<String, String>();
        }
        this.addedNamespaces.put(prefix, name);
    }

    @Override
    public synchronized void removeNamespace(String prefix) {
        assert (!this.closed);
        if (this.addedNamespaces != null) {
            this.addedNamespaces.remove(prefix);
        }
        if (this.removedPrefixes == null) {
            this.removedPrefixes = new HashSet<String>();
        }
        this.removedPrefixes.add(prefix);
    }

    @Override
    public synchronized void clearNamespaces() {
        assert (!this.closed);
        if (this.removedPrefixes != null) {
            this.removedPrefixes.clear();
        }
        if (this.addedNamespaces != null) {
            this.addedNamespaces.clear();
        }
        this.namespaceCleared = true;
    }

    @Override
    public synchronized void observe(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailConflictException {
        assert (!this.closed);
        if (this.observed == null) {
            this.observed = new HashSet<SimpleStatementPattern>();
        }
        if (contexts == null) {
            this.observed.add(new SimpleStatementPattern(subj, pred, obj, null, false));
        } else if (contexts.length == 0) {
            this.observed.add(new SimpleStatementPattern(subj, pred, obj, null, true));
        } else {
            for (Resource ctx : contexts) {
                this.observed.add(new SimpleStatementPattern(subj, pred, obj, ctx, false));
            }
        }
    }

    @Override
    public synchronized void clear(Resource ... contexts) {
        assert (!this.closed);
        if (contexts != null && contexts.length == 0) {
            if (this.approved != null) {
                this.approved.clear();
            }
            if (this.approvedContexts != null) {
                this.approvedContexts.clear();
            }
            this.statementCleared = true;
        } else {
            if (this.approved != null) {
                this.approved.remove(null, null, null, contexts);
            }
            if (this.approvedContexts != null) {
                this.approvedContexts.removeAll(Arrays.asList(contexts));
            }
            if (this.deprecatedContexts == null) {
                this.deprecatedContexts = new HashSet<Resource>();
            }
            this.deprecatedContexts.addAll(Arrays.asList(contexts));
        }
    }

    @Override
    public synchronized void approve(Resource subj, IRI pred, Value obj, Resource ctx) {
        assert (!this.closed);
        if (this.deprecated != null) {
            this.deprecated.remove(subj, pred, obj, ctx);
        }
        if (this.approved == null) {
            this.approved = this.createEmptyModel();
        }
        this.approved.add(subj, pred, obj, ctx);
        if (ctx != null) {
            if (this.approvedContexts == null) {
                this.approvedContexts = new HashSet<Resource>();
            }
            this.approvedContexts.add(ctx);
        }
    }

    @Override
    public synchronized void approve(Statement statement) {
        assert (!this.closed);
        if (this.deprecated != null) {
            this.deprecated.remove(statement);
        }
        if (this.approved == null) {
            this.approved = this.createEmptyModel();
        }
        this.approved.add(statement);
        if (statement.getContext() != null) {
            if (this.approvedContexts == null) {
                this.approvedContexts = new HashSet<Resource>();
            }
            this.approvedContexts.add(statement.getContext());
        }
    }

    @Override
    public synchronized void deprecate(Statement statement) {
        assert (!this.closed);
        if (this.approved != null) {
            this.approved.remove(statement);
        }
        if (this.deprecated == null) {
            this.deprecated = this.createEmptyModel();
        }
        this.deprecated.add(statement);
        Resource ctx = statement.getContext();
        if (this.approvedContexts != null && this.approvedContexts.contains(ctx) && !this.approved.contains(null, null, null, ctx)) {
            this.approvedContexts.remove(ctx);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.observed != null) {
            sb.append(this.observed.size());
            sb.append(" observations, ");
        }
        if (this.namespaceCleared) {
            sb.append("namespaceCleared, ");
        }
        if (this.removedPrefixes != null) {
            sb.append(this.removedPrefixes.size());
            sb.append(" removedPrefixes, ");
        }
        if (this.addedNamespaces != null) {
            sb.append(this.addedNamespaces.size());
            sb.append(" addedNamespaces, ");
        }
        if (this.statementCleared) {
            sb.append("statementCleared, ");
        }
        if (this.deprecatedContexts != null && !this.deprecatedContexts.isEmpty()) {
            sb.append(this.deprecatedContexts.size());
            sb.append(" deprecatedContexts, ");
        }
        if (this.deprecated != null) {
            sb.append(this.deprecated.size());
            sb.append(" deprecated, ");
        }
        if (this.approved != null) {
            sb.append(this.approved.size());
            sb.append(" approved, ");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 2);
        }
        return super.toString();
    }

    protected void setChangeset(Changeset from) {
        assert (!this.closed);
        assert (!from.closed);
        this.observed = from.observed;
        this.approved = from.approved;
        this.deprecated = from.deprecated;
        this.approvedContexts = from.approvedContexts;
        this.deprecatedContexts = from.deprecatedContexts;
        this.addedNamespaces = from.addedNamespaces;
        this.removedPrefixes = from.removedPrefixes;
        this.namespaceCleared = from.namespaceCleared;
        this.statementCleared = from.statementCleared;
    }

    public Changeset shallowClone() {
        assert (!this.closed);
        Changeset changeset = new Changeset(){

            @Override
            public void flush() throws SailException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Model createEmptyModel() {
                return Changeset.this.createEmptyModel();
            }
        };
        changeset.setChangeset(this);
        return changeset;
    }

    public synchronized Set<SimpleStatementPattern> getObserved() {
        assert (!this.closed);
        return this.observed == null ? null : Collections.unmodifiableSet(this.observed);
    }

    @Deprecated
    public synchronized Set<StatementPattern> getObservations() {
        assert (!this.closed);
        if (this.observed == null) {
            return null;
        }
        return this.observed.stream().map(simpleStatementPattern -> new StatementPattern(new Var("s", simpleStatementPattern.getSubject()), new Var("p", simpleStatementPattern.getPredicate()), new Var("o", simpleStatementPattern.getObject()), simpleStatementPattern.isAllContexts() ? null : new Var("c", simpleStatementPattern.getContext()))).collect(Collectors.toCollection(HashSet::new));
    }

    public synchronized Set<Resource> getApprovedContexts() {
        assert (!this.closed);
        return this.cloneSet(this.approvedContexts);
    }

    public synchronized Set<Resource> getDeprecatedContexts() {
        assert (!this.closed);
        return this.cloneSet(this.deprecatedContexts);
    }

    public synchronized boolean isStatementCleared() {
        assert (!this.closed);
        return this.statementCleared;
    }

    public synchronized Map<String, String> getAddedNamespaces() {
        assert (!this.closed);
        return this.addedNamespaces;
    }

    public synchronized Set<String> getRemovedPrefixes() {
        assert (!this.closed);
        return this.cloneSet(this.removedPrefixes);
    }

    public synchronized boolean isNamespaceCleared() {
        assert (!this.closed);
        return this.namespaceCleared;
    }

    public synchronized boolean hasDeprecated() {
        assert (!this.closed);
        return this.deprecated != null && !this.deprecated.isEmpty();
    }

    boolean isChanged() {
        assert (!this.closed);
        return this.approved != null || this.deprecated != null || this.approvedContexts != null || this.deprecatedContexts != null || this.addedNamespaces != null || this.removedPrefixes != null || this.statementCleared || this.namespaceCleared || this.observed != null;
    }

    synchronized List<Statement> getDeprecatedStatements() {
        assert (!this.closed);
        if (this.deprecated == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Statement>(this.deprecated);
    }

    synchronized List<Statement> getApprovedStatements() {
        assert (!this.closed);
        if (this.approved == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Statement>(this.approved);
    }

    synchronized boolean hasDeprecated(Statement statement) {
        assert (!this.closed);
        if (this.deprecated == null) {
            return false;
        }
        return this.deprecated.contains(statement);
    }

    synchronized boolean hasApproved() {
        assert (!this.closed);
        return this.approved != null && !this.approved.isEmpty();
    }

    synchronized Iterable<Statement> getApprovedStatements(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        assert (!this.closed);
        if (this.approved == null) {
            return Collections.emptyList();
        }
        Iterable<Statement> statements = this.approved.getStatements(subj, pred, obj, contexts);
        if (statements instanceof Collection) {
            return new ArrayList<Statement>((Collection)statements);
        }
        return StreamSupport.stream(statements.spliterator(), false).collect(Collectors.toList());
    }

    synchronized Iterable<Triple> getApprovedTriples(Resource subj, IRI pred, Value obj) {
        assert (!this.closed);
        if (this.approved == null) {
            return Collections.emptyList();
        }
        Stream<Triple> approvedSubjectTriples = this.approved.parallelStream().filter(st -> st.getSubject() instanceof Triple).map(st -> (Triple)st.getSubject()).filter(t -> {
            if (subj != null && !subj.equals(t.getSubject())) {
                return false;
            }
            if (pred != null && !pred.equals(t.getPredicate())) {
                return false;
            }
            return obj == null || obj.equals(t.getObject());
        });
        Stream<Triple> approvedObjectTriples = this.approved.parallelStream().filter(st -> st.getObject() instanceof Triple).map(st -> (Triple)st.getObject()).filter(t -> {
            if (subj != null && !subj.equals(t.getSubject())) {
                return false;
            }
            if (pred != null && !pred.equals(t.getPredicate())) {
                return false;
            }
            return obj == null || obj.equals(t.getObject());
        });
        return Stream.concat(approvedSubjectTriples, approvedObjectTriples).collect(Collectors.toList());
    }

    synchronized void removeApproved(Statement next) {
        assert (!this.closed);
        if (this.approved != null) {
            this.approved.remove(next);
        }
    }

    private <T> Set<T> cloneSet(Set<T> set) {
        assert (!this.closed);
        if (set == null) {
            return null;
        }
        return new HashSet<T>(set);
    }

    public static class SimpleStatementPattern {
        private final Resource subject;
        private final IRI predicate;
        private final Value object;
        private final Resource context;
        private final boolean allContexts;

        public SimpleStatementPattern(Resource subject, IRI predicate, Value object, Resource context, boolean allContexts) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
            this.context = context;
            this.allContexts = allContexts;
        }

        public Resource getSubject() {
            return this.subject;
        }

        public IRI getPredicate() {
            return this.predicate;
        }

        public Value getObject() {
            return this.object;
        }

        public Resource getContext() {
            return this.context;
        }

        public boolean isAllContexts() {
            return this.allContexts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleStatementPattern that = (SimpleStatementPattern)o;
            return this.allContexts == that.allContexts && Objects.equals(this.subject, that.subject) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.object, that.object) && Objects.equals(this.context, that.context);
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.predicate, this.object, this.context, this.allContexts);
        }
    }
}

