/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.http.server.repository.transaction.Transaction;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ActiveTransactionRegistry {
    INSTANCE;

    private int timeout = 60;
    private final Logger logger = LoggerFactory.getLogger(ActiveTransactionRegistry.class);
    @Deprecated
    public static final String CACHE_TIMEOUT_PROPERTY = "rdf4j.server.txn.registry.timeout";
    @Deprecated
    public static final int DEFAULT_TIMEOUT = 60;
    private final Cache<UUID, Transaction> primaryCache;
    private final Cache<UUID, Transaction> secondaryCache;
    private final ScheduledExecutorService cleaupSecondaryCacheScheduler;
    private ScheduledFuture<?> cleanupTask = null;

    private Cache<UUID, Transaction> getSecondaryCache() {
        return this.secondaryCache;
    }

    private ActiveTransactionRegistry() {
        String configuredValue = System.getProperty(CACHE_TIMEOUT_PROPERTY);
        if (configuredValue != null) {
            try {
                this.timeout = Integer.parseInt(configuredValue);
            }
            catch (NumberFormatException e) {
                this.logger.warn("Expected integer value for property {}. Timeout will default to {} seconds. ", (Object)CACHE_TIMEOUT_PROPERTY, (Object)60);
            }
        }
        this.primaryCache = CacheBuilder.newBuilder().removalListener(notification -> {
            UUID transactionId = (UUID)notification.getKey();
            Transaction entry = (Transaction)notification.getValue();
            try {
                this.logger.debug("primary cache removal txid {}", (Object)transactionId);
                entry.close();
            }
            catch (InterruptedException | ExecutionException | RepositoryException exception) {
                // empty catch block
            }
        }).build();
        this.secondaryCache = CacheBuilder.newBuilder().removalListener(notification -> {
            this.logger.debug("secondary cache removal");
            if (RemovalCause.EXPIRED.equals((Object)notification.getCause())) {
                UUID transactionId = (UUID)notification.getKey();
                Transaction entry = (Transaction)notification.getValue();
                this.logger.debug("expired transaction to be removed {}", (Object)transactionId);
                Cache<UUID, Transaction> cache = this.primaryCache;
                synchronized (cache) {
                    this.primaryCache.invalidate((Object)transactionId);
                    this.logger.debug("deregistered expired transaction {}", (Object)transactionId);
                    try {
                        this.logger.debug("try close() invoked on transaction !!!{}", (Object)transactionId);
                        entry.close();
                    }
                    catch (Throwable t) {
                        this.logger.debug("error on close when purging {}", (Object)t.getMessage());
                    }
                }
            }
        }).expireAfterAccess((long)this.timeout, TimeUnit.SECONDS).build();
        this.cleaupSecondaryCacheScheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName("rdf4j-cleanup-stn-scheduler");
            thread.setDaemon(true);
            return thread;
        });
        this.cleanupTask = this.cleaupSecondaryCacheScheduler.schedule(() -> this.cleanUpSecondaryCache(), (long)(this.timeout + this.timeout / 10), TimeUnit.SECONDS);
        this.logger.debug("secondary cache expire time {} seconds", (Object)this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpSecondaryCache() {
        Cache<UUID, Transaction> cache = this.primaryCache;
        synchronized (cache) {
            this.logger.debug("performing secondary cache cleanup. {}", (Object)this.getSecondaryCache().size());
            this.getSecondaryCache().cleanUp();
        }
        this.cleanupTask = this.cleaupSecondaryCacheScheduler.schedule(() -> this.cleanUpSecondaryCache(), (long)(this.timeout + this.timeout / 10), TimeUnit.SECONDS);
    }

    public void destroyScheduler() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel(false);
        }
        this.cleanupTask = null;
        this.cleaupSecondaryCacheScheduler.shutdownNow();
        this.logger.debug("ActiveTransactionCache destroy invoked!");
    }

    public long getTimeout(TimeUnit unit) {
        return unit.convert(this.timeout, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Transaction txn) {
        Cache<UUID, Transaction> cache = this.primaryCache;
        synchronized (cache) {
            Transaction existingTxn = (Transaction)this.primaryCache.getIfPresent((Object)txn.getID());
            if (existingTxn != null) {
                this.logger.error("transaction already registered: {}", (Object)txn.getID());
                throw new RepositoryException("transaction with id " + txn.getID().toString() + " already registered.");
            }
            this.primaryCache.put((Object)txn.getID(), (Object)txn);
            this.secondaryCache.put((Object)txn.getID(), (Object)txn);
            this.logger.debug("registered transaction {} ", (Object)txn.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction(UUID id) {
        Cache<UUID, Transaction> cache = this.primaryCache;
        synchronized (cache) {
            Transaction entry = (Transaction)this.primaryCache.getIfPresent((Object)id);
            if (entry == null) {
                throw new RepositoryException("transaction with id " + id.toString() + " not registered.");
            }
            this.updateSecondaryCache(entry);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void active(Transaction txn) {
        Cache<UUID, Transaction> cache = this.primaryCache;
        synchronized (cache) {
            this.updateSecondaryCache(txn);
            Transaction existingTxn = (Transaction)this.primaryCache.getIfPresent((Object)txn.getID());
            if (existingTxn == null) {
                this.primaryCache.put((Object)txn.getID(), (Object)txn);
                this.logger.debug("reinstated transaction {} ", (Object)txn.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(Transaction transaction) {
        Cache<UUID, Transaction> cache = this.primaryCache;
        synchronized (cache) {
            Transaction entry = (Transaction)this.primaryCache.getIfPresent((Object)transaction.getID());
            if (entry == null) {
                throw new RepositoryException("transaction with id " + transaction.getID().toString() + " not registered.");
            }
            this.primaryCache.invalidate((Object)transaction.getID());
            this.secondaryCache.invalidate((Object)transaction.getID());
            this.logger.debug("deregistered transaction {}", (Object)transaction.getID());
        }
    }

    private void updateSecondaryCache(Transaction transaction) {
        try {
            this.secondaryCache.get((Object)transaction.getID(), () -> transaction);
            this.logger.debug("secondary cache update transaction {}", (Object)transaction.getID());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

