/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.graph;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.webapp.util.HttpServerUtil;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.statements.ExportStatementsView;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class GraphController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public GraphController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "HEAD", "POST", "PUT", "DELETE"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result;
        Repository repository = RepositoryInterceptor.getRepository(request);
        String reqMethod = request.getMethod();
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET graph");
            result = this.getExportStatementsResult(repository, request, response);
            this.logger.info("GET graph request finished.");
        } else if ("HEAD".equals(reqMethod)) {
            this.logger.info("HEAD graph");
            result = this.getExportStatementsResult(repository, request, response);
            this.logger.info("HEAD graph request finished.");
        } else if ("POST".equals(reqMethod)) {
            this.logger.info("POST data to graph");
            result = this.getAddDataResult(repository, request, response, false);
            this.logger.info("POST data request finished.");
        } else if ("PUT".equals(reqMethod)) {
            this.logger.info("PUT data in graph");
            result = this.getAddDataResult(repository, request, response, true);
            this.logger.info("PUT data request finished.");
        } else if ("DELETE".equals(reqMethod)) {
            this.logger.info("DELETE data from graph");
            result = this.getDeleteDataResult(repository, request, response);
            this.logger.info("DELETE data request finished.");
        } else {
            throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
        }
        return result;
    }

    private IRI getGraphName(HttpServletRequest request, ValueFactory vf) throws ClientHTTPException {
        String requestURL = request.getRequestURL().toString();
        boolean isServiceRequest = requestURL.endsWith("/service");
        String queryString = request.getQueryString();
        if (isServiceRequest) {
            if (!"default".equalsIgnoreCase(queryString)) {
                IRI graph = ProtocolUtil.parseGraphParam(request, vf);
                if (graph == null) {
                    throw new ClientHTTPException(400, "Named or default graph expected for indirect reference request.");
                }
                return graph;
            }
            return null;
        }
        if (queryString != null) {
            throw new ClientHTTPException(400, "No parameters epxected for direct reference request.");
        }
        return vf.createIRI(requestURL);
    }

    private ModelAndView getExportStatementsResult(Repository repository, HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException {
        ProtocolUtil.logRequestParameters(request);
        ValueFactory vf = repository.getValueFactory();
        IRI graph = this.getGraphName(request, vf);
        RDFWriterFactory rdfWriterFactory = ProtocolUtil.getAcceptableService(request, response, RDFWriterRegistry.getInstance());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("contexts", new Resource[]{graph});
        model.put("factory", rdfWriterFactory);
        model.put("useInferencing", true);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        return new ModelAndView((View)ExportStatementsView.getInstance(), model);
    }

    private ModelAndView getAddDataResult(Repository repository, HttpServletRequest request, HttpServletResponse response, boolean replaceCurrent) throws IOException, ClientHTTPException, ServerHTTPException {
        ModelAndView modelAndView;
        block15: {
            ProtocolUtil.logRequestParameters(request);
            String mimeType = HttpServerUtil.getMIMEType(request.getContentType());
            RDFFormat rdfFormat = Rio.getParserFormatForMIMEType(mimeType).orElseThrow(() -> new ClientHTTPException(415, "Unsupported MIME type: " + mimeType));
            ValueFactory vf = repository.getValueFactory();
            IRI graph = this.getGraphName(request, vf);
            IRI baseURI = ProtocolUtil.parseURIParam(request, "baseURI", vf);
            if (baseURI == null) {
                baseURI = graph != null ? graph : vf.createIRI("foo:bar");
                this.logger.info("no base URI specified, using '{}'", (Object)baseURI);
            }
            ServletInputStream in = request.getInputStream();
            RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            try {
                boolean localTransaction;
                boolean bl = localTransaction = !repositoryCon.isActive();
                if (localTransaction) {
                    repositoryCon.begin();
                }
                if (replaceCurrent) {
                    repositoryCon.clear(graph);
                }
                repositoryCon.add((InputStream)in, baseURI.stringValue(), rdfFormat, graph);
                if (localTransaction) {
                    repositoryCon.commit();
                }
                modelAndView = new ModelAndView((View)EmptySuccessView.getInstance());
                if (repositoryCon == null) break block15;
            }
            catch (Throwable localTransaction) {
                try {
                    if (repositoryCon != null) {
                        try {
                            repositoryCon.close();
                        }
                        catch (Throwable throwable) {
                            localTransaction.addSuppressed(throwable);
                        }
                    }
                    throw localTransaction;
                }
                catch (UnsupportedRDFormatException e) {
                    throw new ClientHTTPException(415, "No RDF parser available for format " + rdfFormat.getName());
                }
                catch (RDFParseException e) {
                    ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_DATA, e.getMessage());
                    throw new ClientHTTPException(400, errInfo.toString());
                }
                catch (IOException e) {
                    throw new ServerHTTPException("Failed to read data: " + e.getMessage(), (Throwable)e);
                }
                catch (RepositoryException e) {
                    throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
                }
            }
            repositoryCon.close();
        }
        return modelAndView;
    }

    private ModelAndView getDeleteDataResult(Repository repository, HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException, ServerHTTPException {
        ModelAndView modelAndView;
        block8: {
            ProtocolUtil.logRequestParameters(request);
            ValueFactory vf = repository.getValueFactory();
            IRI graph = this.getGraphName(request, vf);
            RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            try {
                repositoryCon.clear(graph);
                modelAndView = new ModelAndView((View)EmptySuccessView.getInstance());
                if (repositoryCon == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repositoryCon != null) {
                        try {
                            repositoryCon.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
                }
            }
            repositoryCon.close();
        }
        return modelAndView;
    }
}

