/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.shape;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencerConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class ForwardChainingShapeSource
implements ShapeSource {
    private static final IRI shaclVocabularyGraph = Values.iri("http://rdf4j.org/schema/rdf4j#", "shaclVocabularyGraph");
    private static final SchemaCachingRDFSInferencer shaclVocabulary = ForwardChainingShapeSource.createShaclVocabulary();
    private static final Resource[] defaultContext = new Resource[]{RDF4J.SHACL_SHAPE_GRAPH};
    private final RepositoryConnection connection;
    private final Resource[] context;
    private final Repository repository;

    public ForwardChainingShapeSource(RepositoryConnection connection) {
        this.context = null;
        assert (connection.isActive());
        this.repository = this.forwardChain(connection);
        this.connection = this.repository.getConnection();
        this.connection.begin(IsolationLevels.NONE);
    }

    private ForwardChainingShapeSource(Repository repository, RepositoryConnection connection, Resource[] context) {
        this.connection = connection;
        this.context = context;
        this.repository = repository;
    }

    private SailRepository forwardChain(RepositoryConnection shapesRepoConnection) {
        SailRepository shapesRepoWithReasoning = new SailRepository(SchemaCachingRDFSInferencer.fastInstantiateFrom(shaclVocabulary, new MemoryStore(), false));
        shapesRepoWithReasoning.init();
        try (SailRepositoryConnection shapesRepoWithReasoningConnection = shapesRepoWithReasoning.getConnection();){
            shapesRepoWithReasoningConnection.begin(IsolationLevels.NONE);
            try (RepositoryResult<Statement> statements = shapesRepoConnection.getStatements(null, null, null, false, new Resource[0]);){
                shapesRepoWithReasoningConnection.add(statements, new Resource[0]);
            }
            this.enrichShapes(shapesRepoWithReasoningConnection);
            shapesRepoWithReasoningConnection.commit();
        }
        return shapesRepoWithReasoning;
    }

    private static SchemaCachingRDFSInferencer createShaclVocabulary() {
        SchemaCachingRDFSInferencer schemaCachingRDFSInferencer;
        block15: {
            InputStream in = ForwardChainingShapeSource.getResourceAsStream("shacl-sparql-inference/shaclVocabulary.ttl");
            try {
                SchemaCachingRDFSInferencer schemaCachingRDFSInferencer2 = new SchemaCachingRDFSInferencer(new MemoryStore());
                try (SchemaCachingRDFSInferencerConnection connection = schemaCachingRDFSInferencer2.getConnection();){
                    connection.begin(IsolationLevels.NONE);
                    Model model = Rio.parse(in, "", RDFFormat.TURTLE, new Resource[0]);
                    model.forEach(s -> connection.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), shaclVocabularyGraph));
                    connection.commit();
                }
                schemaCachingRDFSInferencer = schemaCachingRDFSInferencer2;
                if (in == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Resource could not be read: shacl-sparql-inference/shaclVocabulary.ttl", e);
                }
            }
            in.close();
        }
        return schemaCachingRDFSInferencer;
    }

    private static InputStream getResourceAsStream(String filename) {
        InputStream resourceAsStream = ForwardChainingShapeSource.class.getClassLoader().getResourceAsStream(filename);
        if (resourceAsStream == null) {
            throw new IllegalStateException("Resource could not be found: " + filename);
        }
        return new BufferedInputStream(resourceAsStream);
    }

    private void enrichShapes(RepositoryConnection shaclSailConnection) {
        if (shaclSailConnection.isEmpty()) {
            return;
        }
        shaclSailConnection.add(DASH_CONSTANTS, RDF4J.SHACL_SHAPE_GRAPH);
        this.implicitTargetClass(shaclSailConnection);
    }

    private void implicitTargetClass(RepositoryConnection shaclSailConnection) {
        try (Stream stream = shaclSailConnection.getStatements(null, RDF.TYPE, (Value)RDFS.CLASS, false, new Resource[0]).stream();){
            stream.map(Statement::getSubject).filter(s -> shaclSailConnection.hasStatement((Resource)s, RDF.TYPE, (Value)SHACL.NODE_SHAPE, true, new Resource[0]) || shaclSailConnection.hasStatement((Resource)s, RDF.TYPE, (Value)SHACL.PROPERTY_SHAPE, true, new Resource[0])).forEach(s -> shaclSailConnection.add((Resource)s, SHACL.TARGET_CLASS, (Value)s, (Resource)RDF4J.SHACL_SHAPE_GRAPH));
        }
    }

    @Override
    public ForwardChainingShapeSource withContext(Resource[] context) {
        return new ForwardChainingShapeSource(this.repository, this.connection, context);
    }

    @Override
    public Resource[] getActiveContexts() {
        return this.context;
    }

    @Override
    public Stream<ShapeSource.ShapesGraph> getAllShapeContexts() {
        if (this.connection.hasStatement(null, null, null, false, RDF4J.SHACL_SHAPE_GRAPH)) {
            return Stream.of(new ShapeSource.ShapesGraph(RDF4J.SHACL_SHAPE_GRAPH));
        }
        return Stream.empty();
    }

    private Stream<Resource> getContext(ShapeSource.Predicates predicate) {
        assert (this.context == null);
        return this.connection.getStatements(null, predicate.getIRI(), null, true, new Resource[0]).stream().map(Statement::getContext).distinct();
    }

    @Override
    public Stream<Resource> getTargetableShape() {
        assert (this.context != null);
        return Stream.of(this.getSubjects(ShapeSource.Predicates.TARGET_NODE), this.getSubjects(ShapeSource.Predicates.TARGET_CLASS), this.getSubjects(ShapeSource.Predicates.TARGET_SUBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_OBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_PROP), this.getSubjects(ShapeSource.Predicates.RSX_targetShape)).reduce(Stream::concat).get().distinct();
    }

    @Override
    public boolean isType(Resource subject, IRI type) {
        assert (this.context != null);
        return this.connection.hasStatement(subject, RDF.TYPE, (Value)type, true, this.context);
    }

    @Override
    public Stream<Resource> getSubjects(ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(null, predicate.getIRI(), null, true, this.context).stream().map(Statement::getSubject).distinct();
    }

    @Override
    public Stream<Value> getObjects(Resource subject, ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(subject, predicate.getIRI(), null, true, this.context).stream().map(Statement::getObject).distinct();
    }

    @Override
    public Stream<Statement> getAllStatements(Resource id) {
        assert (this.context != null);
        return this.connection.getStatements(id, null, null, true, this.context).stream();
    }

    @Override
    public Value getRdfFirst(Resource subject) {
        assert (this.context != null);
        try (Stream stream = this.connection.getStatements(subject, RDF.FIRST, null, true, this.context).stream();){
            Value value = stream.map(Statement::getObject).findAny().orElse(null);
            return value;
        }
    }

    @Override
    public Resource getRdfRest(Resource subject) {
        assert (this.context != null);
        try (Stream stream = this.connection.getStatements(subject, RDF.REST, null, true, this.context).stream();){
            Resource resource = stream.map(Statement::getObject).findAny().orElse(null);
            return resource;
        }
    }

    @Override
    public void close() {
        this.connection.commit();
        this.connection.close();
        this.repository.shutDown();
    }
}

