/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.util.Arrays;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;

public class MemStatementList {
    private static final MemStatement[] EMPTY_ARRAY = new MemStatement[0];
    private volatile MemStatement[] statements;
    private volatile int size;

    public MemStatementList() {
        this.statements = EMPTY_ARRAY;
        this.size = 0;
    }

    public MemStatementList(int capacity) {
        this.statements = new MemStatement[capacity];
        this.size = 0;
    }

    public MemStatementList(MemStatementList other) {
        this.statements = Arrays.copyOf(other.statements, other.statements.length);
        this.size = other.size;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public MemStatement get(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.size) : "index >= size";
        return this.statements[index];
    }

    public MemStatement getIfExists(int index) {
        if (index < this.size) {
            return this.statements[index];
        }
        return null;
    }

    public void add(MemStatement st) {
        if (this.size == this.statements.length) {
            this.growArray(this.size == 0 ? 4 : 2 * this.size);
        }
        this.statements[this.size] = st;
        ++this.size;
    }

    public void addAll(MemStatementList other) {
        if (this.size + other.size >= this.statements.length) {
            this.growArray(this.size + other.size);
        }
        System.arraycopy(other.statements, 0, this.statements, this.size, other.size);
        this.size += other.size;
    }

    public void remove(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.size) : "index >= size";
        if (index == this.size - 1) {
            this.statements[index] = null;
            --this.size;
        } else {
            --this.size;
            this.statements[index] = this.statements[this.size];
            this.statements[this.size] = null;
        }
    }

    public void remove(MemStatement st) {
        for (int i = 0; i < this.size; ++i) {
            if (this.statements[i] != st) continue;
            this.remove(i);
            return;
        }
    }

    public void clear() {
        this.statements = EMPTY_ARRAY;
        this.size = 0;
    }

    public void cleanSnapshots(int currentSnapshot) {
        int i;
        for (i = this.size - 1; i >= 0; --i) {
            if (this.statements[i].getTillSnapshot() <= currentSnapshot) {
                --this.size;
            } else {
                --i;
                break;
            }
            this.statements[i] = null;
        }
        while (i >= 0) {
            if (this.statements[i].getTillSnapshot() <= currentSnapshot) {
                --this.size;
                this.statements[i] = this.statements[this.size];
                this.statements[this.size] = null;
            }
            --i;
        }
    }

    private void growArray(int newSize) {
        MemStatement[] newArray = new MemStatement[newSize];
        if (this.statements != EMPTY_ARRAY) {
            System.arraycopy(this.statements, 0, newArray, 0, this.size);
        }
        this.statements = newArray;
    }
}

