/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.util.Collections;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.AbstractValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.sail.memory.model.BooleanMemLiteral;
import org.eclipse.rdf4j.sail.memory.model.CalendarMemLiteral;
import org.eclipse.rdf4j.sail.memory.model.DecimalMemLiteral;
import org.eclipse.rdf4j.sail.memory.model.IntegerMemLiteral;
import org.eclipse.rdf4j.sail.memory.model.MemBNode;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemLiteral;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemTriple;
import org.eclipse.rdf4j.sail.memory.model.MemValue;
import org.eclipse.rdf4j.sail.memory.model.NumericMemLiteral;
import org.eclipse.rdf4j.sail.memory.model.WeakObjectRegistry;

public class MemValueFactory
extends AbstractValueFactory {
    private final WeakObjectRegistry<MemIRI> uriRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<MemTriple> tripleRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<MemBNode> bnodeRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<MemLiteral> literalRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<String> namespaceRegistry = new WeakObjectRegistry();

    public void clear() {
        this.uriRegistry.clear();
        this.bnodeRegistry.clear();
        this.literalRegistry.clear();
        this.namespaceRegistry.clear();
    }

    public MemValue getMemValue(Value value) {
        if (value instanceof Resource) {
            return this.getMemResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getMemLiteral((Literal)value);
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("value is not a Resource or Literal: " + value);
    }

    public MemResource getMemResource(Resource resource) {
        if (resource instanceof IRI) {
            return this.getMemURI((IRI)resource);
        }
        if (resource instanceof BNode) {
            return this.getMemBNode((BNode)resource);
        }
        if (resource instanceof Triple) {
            return this.getMemTriple((Triple)resource);
        }
        if (resource == null) {
            return null;
        }
        throw new IllegalArgumentException("resource is not a URI or BNode: " + resource);
    }

    public synchronized MemIRI getMemURI(IRI uri) {
        if (this.isOwnMemValue(uri)) {
            return (MemIRI)uri;
        }
        return this.uriRegistry.get(uri);
    }

    public synchronized MemBNode getMemBNode(BNode bnode) {
        if (this.isOwnMemValue(bnode)) {
            return (MemBNode)bnode;
        }
        return this.bnodeRegistry.get(bnode);
    }

    public synchronized MemLiteral getMemLiteral(Literal literal) {
        if (this.isOwnMemValue(literal)) {
            return (MemLiteral)literal;
        }
        return this.literalRegistry.get(literal);
    }

    private boolean isOwnMemValue(Value value) {
        return value instanceof MemValue && ((MemValue)value).getCreator() == this;
    }

    public Set<MemIRI> getMemURIs() {
        return Collections.unmodifiableSet(this.uriRegistry);
    }

    public Set<MemBNode> getMemBNodes() {
        return Collections.unmodifiableSet(this.bnodeRegistry);
    }

    public Set<MemLiteral> getMemLiterals() {
        return Collections.unmodifiableSet(this.literalRegistry);
    }

    public MemValue getOrCreateMemValue(Value value) {
        if (value instanceof Resource) {
            return this.getOrCreateMemResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getOrCreateMemLiteral((Literal)value);
        }
        throw new IllegalArgumentException("value is not a Resource or Literal: " + value);
    }

    public MemResource getOrCreateMemResource(Resource resource) {
        if (resource instanceof IRI) {
            return this.getOrCreateMemURI((IRI)resource);
        }
        if (resource instanceof BNode) {
            return this.getOrCreateMemBNode((BNode)resource);
        }
        if (resource instanceof Triple) {
            return this.getOrCreateMemTriple((Triple)resource);
        }
        throw new IllegalArgumentException("resource is not a URI or BNode: " + resource);
    }

    public synchronized MemIRI getOrCreateMemURI(IRI uri) {
        MemIRI memURI = this.getMemURI(uri);
        if (memURI == null) {
            String namespace = uri.getNamespace();
            String sharedNamespace = this.namespaceRegistry.get(namespace);
            if (sharedNamespace == null) {
                this.namespaceRegistry.add(namespace);
            } else {
                namespace = sharedNamespace;
            }
            memURI = new MemIRI(this, namespace, uri.getLocalName());
            boolean wasNew = this.uriRegistry.add(memURI);
            assert (wasNew) : "Created a duplicate MemURI for URI " + uri;
        }
        return memURI;
    }

    public synchronized MemBNode getOrCreateMemBNode(BNode bnode) {
        MemBNode memBNode = this.getMemBNode(bnode);
        if (memBNode == null) {
            memBNode = new MemBNode(this, bnode.getID());
            boolean wasNew = this.bnodeRegistry.add(memBNode);
            assert (wasNew) : "Created a duplicate MemBNode for bnode " + bnode;
        }
        return memBNode;
    }

    public synchronized MemLiteral getOrCreateMemLiteral(Literal literal) {
        MemLiteral memLiteral = this.getMemLiteral(literal);
        if (memLiteral == null) {
            String label = literal.getLabel();
            IRI datatype = literal.getDatatype();
            if (Literals.isLanguageLiteral(literal)) {
                memLiteral = new MemLiteral((Object)this, label, literal.getLanguage().get());
            } else {
                try {
                    memLiteral = XMLDatatypeUtil.isIntegerDatatype(datatype) ? new IntegerMemLiteral(this, label, literal.integerValue(), datatype) : (datatype.equals(XSD.DECIMAL) ? new DecimalMemLiteral(this, label, literal.decimalValue(), datatype) : (datatype.equals(XSD.FLOAT) ? new NumericMemLiteral(this, label, Float.valueOf(literal.floatValue()), datatype) : (datatype.equals(XSD.DOUBLE) ? new NumericMemLiteral(this, label, literal.doubleValue(), datatype) : (datatype.equals(XSD.BOOLEAN) ? new BooleanMemLiteral((Object)this, label, literal.booleanValue()) : (datatype.equals(XSD.DATETIME) ? new CalendarMemLiteral(this, label, datatype, literal.calendarValue()) : (datatype.equals(XSD.DATETIMESTAMP) ? new CalendarMemLiteral(this, label, datatype, literal.calendarValue()) : new MemLiteral((Object)this, label, datatype)))))));
                }
                catch (IllegalArgumentException e) {
                    memLiteral = new MemLiteral((Object)this, label, datatype);
                }
            }
            boolean wasNew = this.literalRegistry.add(memLiteral);
            assert (wasNew) : "Created a duplicate MemLiteral for literal " + literal;
        }
        return memLiteral;
    }

    @Override
    public synchronized IRI createIRI(String uri) {
        return this.getOrCreateMemURI(super.createIRI(uri));
    }

    @Override
    public synchronized IRI createIRI(String namespace, String localName) {
        IRI tempURI = null;
        if (URIUtil.isCorrectURISplit(namespace, localName)) {
            if (namespace.indexOf(58) == -1) {
                throw new IllegalArgumentException("Not a valid (absolute) URI: " + namespace + localName);
            }
            tempURI = new MemIRI(null, namespace, localName);
        } else {
            tempURI = super.createIRI(namespace + localName);
        }
        return this.getOrCreateMemURI(tempURI);
    }

    @Override
    public synchronized BNode createBNode(String nodeID) {
        return this.getOrCreateMemBNode(super.createBNode(nodeID));
    }

    @Override
    public synchronized Literal createLiteral(String value) {
        return this.getOrCreateMemLiteral(super.createLiteral(value));
    }

    @Override
    public synchronized Literal createLiteral(String value, String language) {
        return this.getOrCreateMemLiteral(super.createLiteral(value, language));
    }

    @Override
    public synchronized Literal createLiteral(String value, IRI datatype) {
        return this.getOrCreateMemLiteral(super.createLiteral(value, datatype));
    }

    @Override
    public synchronized Literal createLiteral(boolean value) {
        BooleanMemLiteral newLiteral = new BooleanMemLiteral((Object)this, value);
        return this.getSharedLiteral(newLiteral);
    }

    @Override
    public synchronized Literal createLiteral(XMLGregorianCalendar calendar) {
        CalendarMemLiteral newLiteral = new CalendarMemLiteral((Object)this, calendar);
        return this.getSharedLiteral(newLiteral);
    }

    private Literal getSharedLiteral(MemLiteral newLiteral) {
        MemLiteral sharedLiteral = this.literalRegistry.get(newLiteral);
        if (sharedLiteral == null) {
            boolean wasNew = this.literalRegistry.add(newLiteral);
            assert (wasNew) : "Created a duplicate MemLiteral for literal " + newLiteral;
            sharedLiteral = newLiteral;
        }
        return sharedLiteral;
    }

    private synchronized MemTriple getOrCreateMemTriple(Triple triple) {
        MemTriple memTriple = this.getMemTriple(triple);
        if (memTriple == null) {
            memTriple = new MemTriple(this, this.getOrCreateMemResource(triple.getSubject()), this.getOrCreateMemURI(triple.getPredicate()), this.getOrCreateMemValue(triple.getObject()));
            boolean bl = this.tripleRegistry.add(memTriple);
        }
        return memTriple;
    }

    private synchronized MemTriple getMemTriple(Triple triple) {
        if (this.isOwnMemValue(triple)) {
            return (MemTriple)triple;
        }
        return this.tripleRegistry.get(triple);
    }
}

