/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.evaluation;

import java.lang.ref.WeakReference;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.impl.QueueCursor;
import org.eclipse.rdf4j.sail.federation.evaluation.AlternativeCursor;
import org.eclipse.rdf4j.sail.federation.evaluation.FilterCursor;

public class ParallelLeftJoinCursor
extends LookAheadIteration<BindingSet, QueryEvaluationException>
implements Runnable {
    private static final String LF_TAB = "\n\t";
    private final EvaluationStrategy strategy;
    private final LeftJoin join;
    private final Set<String> scopeBindingNames;
    private volatile Thread evaluationThread;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private volatile CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private volatile boolean closed;
    private final QueueCursor<CloseableIteration<BindingSet, QueryEvaluationException>> rightQueue = new QueueCursor(1024, new WeakReference<ParallelLeftJoinCursor>(this));

    public ParallelLeftJoinCursor(EvaluationStrategy strategy, LeftJoin join, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join;
        this.scopeBindingNames = join.getBindingNames();
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.evaluationThread = Thread.currentThread();
        try {
            ValueExpr condition = this.join.getCondition();
            while (true) {
                ParallelLeftJoinCursor parallelLeftJoinCursor = this;
                synchronized (parallelLeftJoinCursor) {
                    if (this.closed) return;
                    if (this.isClosed()) return;
                    if (!this.leftIter.hasNext()) return;
                    BindingSet leftBindings = (BindingSet)this.leftIter.next();
                    this.addToRightQueue(condition, leftBindings);
                }
            }
        }
        catch (RuntimeException e) {
            this.rightQueue.toss(e);
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            this.evaluationThread = null;
            this.rightQueue.done();
        }
    }

    private void addToRightQueue(ValueExpr condition, BindingSet leftBindings) throws QueryEvaluationException, InterruptedException {
        FilterCursor result = this.strategy.evaluate(this.join.getRightArg(), leftBindings);
        if (condition != null) {
            result = new FilterCursor(result, condition, this.scopeBindingNames, this.strategy);
        }
        SingletonIteration alt = new SingletonIteration(leftBindings);
        this.rightQueue.put(new AlternativeCursor<BindingSet>(result, alt));
    }

    @Override
    public BindingSet getNextElement() throws QueryEvaluationException {
        BindingSet result = null;
        CloseableIteration nextRightIter = this.rightIter;
        while (!this.isClosed() && (nextRightIter != null || this.rightQueue.hasNext())) {
            if (nextRightIter == null) {
                nextRightIter = this.rightIter = (CloseableIteration)this.rightQueue.next();
            }
            if (nextRightIter == null) continue;
            if (nextRightIter.hasNext()) {
                result = (BindingSet)nextRightIter.next();
                break;
            }
            nextRightIter.close();
            this.rightIter = null;
            nextRightIter = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleClose() throws QueryEvaluationException {
        this.closed = true;
        try {
            super.handleClose();
        }
        finally {
            try {
                Thread toCloseEvaluationThread = this.evaluationThread;
                if (toCloseEvaluationThread != null) {
                    toCloseEvaluationThread.interrupt();
                }
            }
            finally {
                try {
                    CloseableIteration<BindingSet, QueryEvaluationException> toCloseRightIter = this.rightIter;
                    this.rightIter = null;
                    if (toCloseRightIter != null) {
                        toCloseRightIter.close();
                    }
                }
                finally {
                    this.leftIter.close();
                }
            }
        }
    }

    public String toString() {
        String left = this.leftIter.toString().replace("\n", LF_TAB);
        CloseableIteration<BindingSet, QueryEvaluationException> nextRightIter = this.rightIter;
        String right = null == nextRightIter ? this.join.getRightArg().toString() : nextRightIter.toString();
        ValueExpr condition = this.join.getCondition();
        String filter = null == condition ? "" : condition.toString().trim().replace("\n", LF_TAB);
        return "ParallelLeftJoin " + filter + LF_TAB + left + LF_TAB + right.replace("\n", LF_TAB);
    }
}

