/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;

public class JoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final EvaluationStrategy strategy;
    private final Join join;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private CloseableIteration<BindingSet, QueryEvaluationException> rightIter;

    public JoinIterator(EvaluationStrategy strategy, Join join, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join;
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = new EmptyIteration<BindingSet, QueryEvaluationException>();
        join.setAlgorithm(this);
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            while (this.rightIter.hasNext() || this.leftIter.hasNext()) {
                if (this.rightIter.hasNext()) {
                    return (BindingSet)this.rightIter.next();
                }
                this.rightIter.close();
                if (!this.leftIter.hasNext()) continue;
                TupleExpr rightArg = this.join.getRightArg();
                this.rightIter = this.strategy.evaluate(rightArg, (BindingSet)this.leftIter.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.leftIter.close();
            }
            finally {
                this.rightIter.close();
            }
        }
    }
}

