/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.DynamicModel;
import org.eclipse.rdf4j.model.impl.LinkedHashModelFactory;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.RSX;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.Exportable;
import org.eclipse.rdf4j.sail.shacl.ast.Identifiable;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.Severity;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.TargetChainInterface;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AndConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ClassConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ClosedConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.DashHasValueInConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.DatatypeConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.DisjointConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.EqualsConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.HasValueConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.InConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.LanguageInConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.LessThanConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.LessThanOrEqualsConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxCountConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxExclusiveConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxInclusiveConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxLengthConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MinCountConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MinExclusiveConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MinInclusiveConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MinLengthConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.NodeKindConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.NotConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.OrConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.PatternConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.QualifiedMaxCountConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.QualifiedMinCountConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.UniqueLangConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.XoneConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.targets.DashAllObjects;
import org.eclipse.rdf4j.sail.shacl.ast.targets.DashAllSubjects;
import org.eclipse.rdf4j.sail.shacl.ast.targets.RSXTargetShape;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetClass;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetNode;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetObjectsOf;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetSubjectsOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Shape
implements ConstraintComponent,
Identifiable,
Exportable,
TargetChainInterface {
    private static final Logger logger = LoggerFactory.getLogger(Shape.class);
    Resource id;
    TargetChain targetChain;
    List<Target> target = new ArrayList<Target>();
    boolean deactivated;
    List<Literal> message;
    Severity severity = Severity.Violation;
    List<ConstraintComponent> constraintComponents = new ArrayList<ConstraintComponent>();

    public Shape() {
    }

    public Shape(Shape shape) {
        this.deactivated = shape.deactivated;
        this.message = shape.message;
        this.severity = shape.severity;
        this.id = shape.id;
        this.targetChain = shape.targetChain;
    }

    public void populate(ShaclProperties properties, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        this.deactivated = properties.isDeactivated();
        this.message = properties.getMessage();
        this.id = properties.getId();
        if (!properties.getTargetClass().isEmpty()) {
            this.target.add(new TargetClass(properties.getTargetClass()));
        }
        if (!properties.getTargetNode().isEmpty()) {
            this.target.add(new TargetNode(properties.getTargetNode()));
        }
        if (!properties.getTargetObjectsOf().isEmpty()) {
            this.target.add(new TargetObjectsOf(properties.getTargetObjectsOf()));
        }
        if (!properties.getTargetSubjectsOf().isEmpty()) {
            this.target.add(new TargetSubjectsOf(properties.getTargetSubjectsOf()));
        }
        if (shaclSail.isEclipseRdf4jShaclExtensions() && !properties.getTargetShape().isEmpty()) {
            properties.getTargetShape().stream().map(targetShape -> new RSXTargetShape((Resource)targetShape, connection, shaclSail)).forEach(this.target::add);
        }
        if (!properties.getTarget().isEmpty()) {
            properties.getTarget().forEach(target -> {
                if (shaclSail.isDashDataShapes() && connection.hasStatement(target, RDF.TYPE, (Value)DASH.AllObjectsTarget, true, new Resource[0])) {
                    this.target.add(new DashAllObjects((Resource)target));
                }
                if (shaclSail.isDashDataShapes() && connection.hasStatement(target, RDF.TYPE, (Value)DASH.AllSubjectsTarget, true, new Resource[0])) {
                    this.target.add(new DashAllSubjects((Resource)target));
                }
            });
        }
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    protected abstract Shape shallowClone();

    public Model toModel(Model model) {
        this.toModel(null, null, model, new HashSet<Resource>());
        return model;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.subject(this.getId());
        if (this.deactivated) {
            modelBuilder.add(SHACL.DEACTIVATED, (Object)this.deactivated);
        }
        this.target.forEach(t -> t.toModel(this.getId(), null, model, cycleDetection));
        model.addAll((Collection)modelBuilder.build());
    }

    List<ConstraintComponent> getConstraintComponents(ShaclProperties properties, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        ArrayList<ConstraintComponent> constraintComponent = new ArrayList<ConstraintComponent>();
        properties.getProperty().stream().map(r -> new ShaclProperties((Resource)r, connection)).map(p -> PropertyShape.getInstance(p, connection, cache, shaclSail)).forEach(constraintComponent::add);
        properties.getNode().stream().map(r -> new ShaclProperties((Resource)r, connection)).map(p -> NodeShape.getInstance(p, connection, cache, true, shaclSail)).forEach(constraintComponent::add);
        if (properties.getMinCount() != null) {
            constraintComponent.add(new MinCountConstraintComponent(properties.getMinCount()));
        }
        if (properties.getMaxCount() != null) {
            constraintComponent.add(new MaxCountConstraintComponent(properties.getMaxCount()));
        }
        if (properties.getDatatype() != null) {
            constraintComponent.add(new DatatypeConstraintComponent(properties.getDatatype()));
        }
        if (properties.getMinLength() != null) {
            constraintComponent.add(new MinLengthConstraintComponent(properties.getMinLength()));
        }
        if (properties.getMaxLength() != null) {
            constraintComponent.add(new MaxLengthConstraintComponent(properties.getMaxLength()));
        }
        if (properties.getMinInclusive() != null) {
            constraintComponent.add(new MinInclusiveConstraintComponent(properties.getMinInclusive()));
        }
        if (properties.getMaxInclusive() != null) {
            constraintComponent.add(new MaxInclusiveConstraintComponent(properties.getMaxInclusive()));
        }
        if (properties.getMinExclusive() != null) {
            constraintComponent.add(new MinExclusiveConstraintComponent(properties.getMinExclusive()));
        }
        if (properties.getMaxExclusive() != null) {
            constraintComponent.add(new MaxExclusiveConstraintComponent(properties.getMaxExclusive()));
        }
        if (properties.isUniqueLang()) {
            constraintComponent.add(new UniqueLangConstraintComponent());
        }
        properties.getPattern().stream().map(pattern -> new PatternConstraintComponent((String)pattern, properties.getFlags())).forEach(constraintComponent::add);
        if (properties.getLanguageIn() != null) {
            constraintComponent.add(new LanguageInConstraintComponent(connection, properties.getLanguageIn()));
        }
        if (properties.getIn() != null) {
            constraintComponent.add(new InConstraintComponent(connection, properties.getIn()));
        }
        if (properties.getNodeKind() != null) {
            constraintComponent.add(new NodeKindConstraintComponent(properties.getNodeKind()));
        }
        if (properties.isClosed()) {
            constraintComponent.add(new ClosedConstraintComponent(connection, properties.getProperty(), properties.getIgnoredProperties()));
        }
        properties.getClazz().stream().map(ClassConstraintComponent::new).forEach(constraintComponent::add);
        properties.getHasValue().stream().map(HasValueConstraintComponent::new).forEach(constraintComponent::add);
        properties.getEquals().stream().map(EqualsConstraintComponent::new).forEach(constraintComponent::add);
        properties.getDisjoint().stream().map(DisjointConstraintComponent::new).forEach(constraintComponent::add);
        properties.getLessThan().stream().map(LessThanConstraintComponent::new).forEach(constraintComponent::add);
        properties.getLessThanOrEquals().stream().map(LessThanOrEqualsConstraintComponent::new).forEach(constraintComponent::add);
        if (properties.getQualifiedValueShape() != null) {
            if (properties.getQualifiedMaxCount() != null) {
                QualifiedMaxCountConstraintComponent qualifiedMaxCountConstraintComponent = new QualifiedMaxCountConstraintComponent(properties.getQualifiedValueShape(), connection, cache, shaclSail, properties.getQualifiedValueShapesDisjoint(), properties.getQualifiedMaxCount());
                constraintComponent.add(qualifiedMaxCountConstraintComponent);
            }
            if (properties.getQualifiedMinCount() != null) {
                QualifiedMinCountConstraintComponent qualifiedMinCountConstraintComponent = new QualifiedMinCountConstraintComponent(properties.getQualifiedValueShape(), connection, cache, shaclSail, properties.getQualifiedValueShapesDisjoint(), properties.getQualifiedMinCount());
                constraintComponent.add(qualifiedMinCountConstraintComponent);
            }
        }
        if (shaclSail.isDashDataShapes()) {
            properties.getHasValueIn().stream().map(hasValueIn -> new DashHasValueInConstraintComponent((Resource)hasValueIn, connection)).forEach(constraintComponent::add);
        }
        properties.getOr().stream().map(or -> new OrConstraintComponent((Resource)or, connection, cache, shaclSail)).forEach(constraintComponent::add);
        properties.getXone().stream().map(xone -> new XoneConstraintComponent((Resource)xone, connection, cache, shaclSail)).forEach(constraintComponent::add);
        properties.getAnd().stream().map(and -> new AndConstraintComponent((Resource)and, connection, cache, shaclSail)).forEach(constraintComponent::add);
        properties.getNot().stream().map(or -> new NotConstraintComponent((Resource)or, connection, cache, shaclSail)).forEach(constraintComponent::add);
        return constraintComponent;
    }

    @Override
    public TargetChain getTargetChain() {
        return this.targetChain;
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        this.targetChain = targetChain;
        this.constraintComponents.forEach(c -> c.setTargetChain(targetChain));
    }

    public PlanNode generatePlans(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean validateEntireBaseSail) {
        assert (this.constraintComponents.size() == 1);
        ValidationApproach validationApproach = ValidationApproach.SPARQL;
        if (!validateEntireBaseSail) {
            validationApproach = this.constraintComponents.stream().map(constraintComponent -> constraintComponent.getPreferredValidationApproach(connectionsGroup)).reduce(ValidationApproach::reducePreferred).get();
        }
        if (validationApproach == ValidationApproach.SPARQL) {
            if (connectionsGroup.isExperimentalSparqlValidation() && this.getOptimalBulkValidationApproach() == ValidationApproach.SPARQL) {
                logger.debug("Use validation approach {} for shape {}", (Object)validationApproach, (Object)this);
                return this.generateSparqlValidationQuery(connectionsGroup, logValidationPlans, false, false, ConstraintComponent.Scope.none).getValidationPlan(connectionsGroup.getBaseConnection());
            }
            logger.debug("Use fall back validation approach for bulk validation instead of SPARQL for shape {}", (Object)this);
            return this.generateTransactionalValidationPlan(connectionsGroup, logValidationPlans, () -> this.getTargetChain().getEffectiveTarget("_target", this instanceof NodeShape ? ConstraintComponent.Scope.nodeShape : ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner()).getAllTargets(connectionsGroup, this instanceof NodeShape ? ConstraintComponent.Scope.nodeShape : ConstraintComponent.Scope.propertyShape), ConstraintComponent.Scope.none);
        }
        if (validationApproach == ValidationApproach.Transactional) {
            logger.debug("Use validation approach {} for shape {}", (Object)validationApproach, (Object)this);
            if (this.requiresEvaluation(connectionsGroup, ConstraintComponent.Scope.none)) {
                return this.generateTransactionalValidationPlan(connectionsGroup, logValidationPlans, null, ConstraintComponent.Scope.none);
            }
            return EmptyNode.getInstance();
        }
        throw new ShaclUnsupportedException("Unkown validation approach: " + validationApproach);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        throw new ShaclUnsupportedException(this.getClass().getSimpleName());
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        return this.constraintComponents.stream().anyMatch(c -> c.requiresEvaluation(connectionsGroup, scope));
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        return this.constraintComponents.stream().map(ConstraintComponent::getOptimalBulkValidationApproach).reduce(ValidationApproach::reduceCompatible).orElse(ValidationApproach.MOST_COMPATIBLE);
    }

    public String toString() {
        Model statements = this.toModel((Model)new DynamicModel((ModelFactory)new LinkedHashModelFactory()));
        statements.setNamespace(SHACL.NS);
        statements.setNamespace(XSD.NS);
        statements.setNamespace(RSX.NS);
        statements.setNamespace(RDFS.NS);
        statements.setNamespace(RDF.NS);
        WriterConfig writerConfig = new WriterConfig();
        writerConfig.set(BasicWriterSettings.PRETTY_PRINT, (Object)true);
        writerConfig.set(BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
        StringWriter stringWriter = new StringWriter();
        Rio.write((Iterable)statements, (Writer)stringWriter, (RDFFormat)RDFFormat.TURTLE, (WriterConfig)writerConfig);
        return stringWriter.toString().replaceAll("(?m)^(@prefix)(.*)(\\.)$", "").trim();
    }

    public static class Factory {
        public static List<Shape> getShapes(RepositoryConnection connection, ShaclSail shaclSail) {
            List<Shape> parsed = Factory.parse(connection, shaclSail);
            List<Shape> split = Factory.split(parsed);
            Factory.calculateTargetChain(split);
            return split;
        }

        private static void calculateTargetChain(List<Shape> parsed) {
            for (Shape shape : parsed) {
                assert (shape.target.size() == 1);
                shape.setTargetChain(new TargetChain().add(shape.target.get(0)));
            }
        }

        private static List<Shape> split(List<Shape> collect) {
            return collect.stream().flatMap(s -> {
                ArrayList temp = new ArrayList();
                s.target.forEach(target -> s.constraintComponents.forEach(constraintComponent -> {
                    if (constraintComponent instanceof PropertyShape) {
                        ((PropertyShape)constraintComponent).constraintComponents.forEach(propertyConstraintComponent -> {
                            PropertyShape clonedConstraintComponent = (PropertyShape)((PropertyShape)constraintComponent).shallowClone();
                            clonedConstraintComponent.constraintComponents.add(propertyConstraintComponent.deepClone());
                            Shape shape = s.shallowClone();
                            shape.target.add((Target)target);
                            shape.constraintComponents.add(clonedConstraintComponent);
                            temp.add(shape);
                        });
                    } else {
                        Shape shape = s.shallowClone();
                        shape.target.add((Target)target);
                        shape.constraintComponents.add((ConstraintComponent)constraintComponent);
                        temp.add(shape);
                    }
                }));
                return temp.stream();
            }).collect(Collectors.toList());
        }

        private static List<Shape> parse(RepositoryConnection connection, ShaclSail shaclSail) {
            Cache cache = new Cache();
            Set<Resource> resources = Factory.getTargetableShapes(connection);
            return resources.stream().map(r -> new ShaclProperties((Resource)r, connection)).map(p -> {
                if (p.getType() == SHACL.NODE_SHAPE) {
                    return NodeShape.getInstance(p, connection, cache, true, shaclSail);
                }
                if (p.getType() == SHACL.PROPERTY_SHAPE) {
                    return PropertyShape.getInstance(p, connection, cache, shaclSail);
                }
                throw new IllegalStateException("Unknown shape type for " + p.getId());
            }).collect(Collectors.toList());
        }

        private static Set<Resource> getTargetableShapes(RepositoryConnection connection) {
            Set<Resource> collect;
            try (Stream TARGET_NODE = connection.getStatements(null, SHACL.TARGET_NODE, null, true, new Resource[0]).stream();
                 Stream TARGET_CLASS = connection.getStatements(null, SHACL.TARGET_CLASS, null, true, new Resource[0]).stream();
                 Stream TARGET_SUBJECTS_OF = connection.getStatements(null, SHACL.TARGET_SUBJECTS_OF, null, true, new Resource[0]).stream();
                 Stream TARGET_OBJECTS_OF = connection.getStatements(null, SHACL.TARGET_OBJECTS_OF, null, true, new Resource[0]).stream();
                 Stream TARGET = connection.getStatements(null, SHACL.TARGET_PROP, null, true, new Resource[0]).stream();
                 Stream RSX_TARGET_SHAPE = connection.getStatements(null, RSX.targetShape, null, true, new Resource[0]).stream();){
                collect = Stream.of(TARGET_CLASS, TARGET_NODE, TARGET_OBJECTS_OF, TARGET_SUBJECTS_OF, TARGET, RSX_TARGET_SHAPE).reduce(Stream::concat).get().map(Statement::getSubject).collect(Collectors.toSet());
            }
            return collect;
        }
    }
}

