/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class LanguageInFilter
extends FilterPlanNode {
    private final List<String> languageRanges;
    private final Set<String> lowerCaseLanguageIn;

    public LanguageInFilter(PlanNode parent, Set<String> lowerCaseLanguageIn, List<String> languageRanges) {
        super(parent);
        this.lowerCaseLanguageIn = lowerCaseLanguageIn;
        this.languageRanges = languageRanges;
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        if (!t.getValue().isLiteral()) {
            return false;
        }
        Optional<String> language = ((Literal)t.getValue()).getLanguage();
        if (!language.isPresent()) {
            return false;
        }
        boolean languageMatches = language.map(String::toLowerCase).filter(this.lowerCaseLanguageIn::contains).isPresent();
        if (languageMatches) {
            return true;
        }
        String langTag = language.get();
        for (String languageRange : this.languageRanges) {
            if (!Literals.langMatches(langTag, languageRange)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "LanguageInFilter{languageRanges=" + Arrays.toString(this.languageRanges.toArray()) + ", lowerCaseLanguageIn=" + Arrays.toString(this.lowerCaseLanguageIn.toArray()) + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LanguageInFilter that = (LanguageInFilter)o;
        return this.languageRanges.equals(that.languageRanges) && this.lowerCaseLanguageIn.equals(that.lowerCaseLanguageIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.languageRanges, this.lowerCaseLanguageIn);
    }
}

