/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.lucene.spin;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.lucene.spin.LuceneSpinSail;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.lucene.LuceneSailBuffer;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Experimental
public class LuceneSpinSailConnection
extends NotifyingSailConnectionWrapper {
    private static final Logger logger = LoggerFactory.getLogger(LuceneSpinSailConnection.class);
    private final SearchIndex luceneIndex;
    private final LuceneSpinSail sail;
    private final LuceneSailBuffer buffer = new LuceneSailBuffer();
    protected final SailConnectionListener connectionListener = new SailConnectionListener(){

        public void statementAdded(Statement statement) {
            if (statement.getObject() instanceof Literal) {
                statement = LuceneSpinSailConnection.this.sail.mapStatement(statement);
                if (statement == null) {
                    return;
                }
                Literal literal = (Literal)statement.getObject();
                if (LuceneSpinSailConnection.this.luceneIndex.accept(literal)) {
                    LuceneSpinSailConnection.this.buffer.add(statement);
                }
            }
        }

        public void statementRemoved(Statement statement) {
            if (statement.getObject() instanceof Literal) {
                statement = LuceneSpinSailConnection.this.sail.mapStatement(statement);
                if (statement == null) {
                    return;
                }
                Literal literal = (Literal)statement.getObject();
                if (LuceneSpinSailConnection.this.luceneIndex.accept(literal)) {
                    LuceneSpinSailConnection.this.buffer.remove(statement);
                }
            }
        }
    };
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public LuceneSpinSailConnection(NotifyingSailConnection wrappedConnection, SearchIndex luceneIndex, LuceneSpinSail sail) {
        super(wrappedConnection);
        this.luceneIndex = luceneIndex;
        this.sail = sail;
        wrappedConnection.addConnectionListener(this.connectionListener);
    }

    public synchronized void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        super.addStatement(subj, pred, obj, contexts);
    }

    public void close() throws SailException {
        if (this.closed.compareAndSet(false, true)) {
            super.close();
        }
    }

    public synchronized void clear(Resource ... resources) throws SailException {
        this.getWrappedConnection().removeConnectionListener(this.connectionListener);
        try {
            super.clear(resources);
            this.buffer.clear(resources);
        }
        finally {
            this.getWrappedConnection().addConnectionListener(this.connectionListener);
        }
    }

    public void begin() throws SailException {
        super.begin();
        this.buffer.reset();
        try {
            this.luceneIndex.begin();
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
    }

    public void commit() throws SailException {
        super.commit();
        logger.debug("Committing Lucene transaction with {} operations.", (Object)this.buffer.operations().size());
        try {
            this.buffer.optimize();
            Iterator i = this.buffer.operations().iterator();
            while (i.hasNext()) {
                LuceneSailBuffer.Operation op = (LuceneSailBuffer.Operation)i.next();
                if (op instanceof LuceneSailBuffer.AddRemoveOperation) {
                    LuceneSailBuffer.AddRemoveOperation addremove = (LuceneSailBuffer.AddRemoveOperation)op;
                    this.addRemoveStatements(addremove.getAdded(), addremove.getRemoved());
                } else if (op instanceof LuceneSailBuffer.ClearContextOperation) {
                    this.clearContexts(((LuceneSailBuffer.ClearContextOperation)op).getContexts());
                } else if (op instanceof LuceneSailBuffer.ClearOperation) {
                    logger.debug("clearing index...");
                    this.luceneIndex.clear();
                } else {
                    throw new SailException("Cannot interpret operation " + op + " of type " + op.getClass().getName());
                }
                i.remove();
            }
        }
        catch (Exception e) {
            logger.error("Committing operations in lucenesail, encountered exception " + e + ". Only some operations were stored, " + this.buffer.operations().size() + " operations are discarded. Lucene Index is now corrupt.", (Throwable)e);
            throw new SailException((Throwable)e);
        }
        finally {
            this.buffer.reset();
        }
    }

    private void addRemoveStatements(Set<Statement> toAdd, Set<Statement> toRemove) throws IOException {
        logger.debug("indexing {}/removing {} statements...", (Object)toAdd.size(), (Object)toRemove.size());
        this.luceneIndex.begin();
        try {
            this.luceneIndex.addRemoveStatements(toAdd, toRemove);
            this.luceneIndex.commit();
        }
        catch (IOException e) {
            logger.error("Rolling back", (Throwable)e);
            this.luceneIndex.rollback();
            throw e;
        }
    }

    private void clearContexts(Resource ... contexts) throws IOException {
        logger.debug("clearing contexts...");
        this.luceneIndex.begin();
        try {
            this.luceneIndex.clearContexts(contexts);
            this.luceneIndex.commit();
        }
        catch (IOException e) {
            logger.error("Rolling back", (Throwable)e);
            this.luceneIndex.rollback();
            throw e;
        }
    }

    public synchronized void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        super.removeStatements(subj, pred, obj, contexts);
    }

    public void rollback() throws SailException {
        super.rollback();
        this.buffer.reset();
        try {
            this.luceneIndex.rollback();
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
    }
}

