/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class Sort
implements PlanNode {
    private final PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Sort(PlanNode parent) {
        this.parent = parent = PlanNodeHelper.handleSorting(this, parent);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends ValidationTuple, SailException> iterator;
            List<ValidationTuple> sortedTuples;
            Iterator<ValidationTuple> sortedTuplesIterator;
            boolean closed;
            {
                this.iterator = Sort.this.parent.iterator();
                this.closed = false;
            }

            public void close() throws SailException {
                if (this.closed) {
                    throw new IllegalStateException("Already closed");
                }
                this.closed = true;
                assert (this.sortedTuples == null || !this.iterator.hasNext()) : "All tuples from parent iterator where not retrieved when sorting!";
                try {
                    this.iterator.close();
                }
                finally {
                    this.sortedTuplesIterator = Collections.emptyIterator();
                    this.sortedTuples = null;
                }
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.sortTuples();
                return this.sortedTuplesIterator.hasNext();
            }

            private void sortTuples() {
                if (this.closed) {
                    throw new IllegalStateException("Tried to iterate on a closed iterator");
                }
                if (this.sortedTuples == null) {
                    this.sortedTuples = new ArrayList<ValidationTuple>();
                    boolean alreadySorted = true;
                    ValidationTuple prev = null;
                    while (this.iterator.hasNext()) {
                        ValidationTuple next = (ValidationTuple)this.iterator.next();
                        this.sortedTuples.add(next);
                        if (this.sortedTuples.size() == 1 && !this.iterator.hasNext()) {
                            this.sortedTuplesIterator = this.sortedTuples.iterator();
                            return;
                        }
                        if (prev != null && prev.compareActiveTarget(next) > 0) {
                            alreadySorted = false;
                        }
                        prev = next;
                    }
                    if (!alreadySorted && this.sortedTuples.size() > 1) {
                        if (this.sortedTuples.size() > 8192) {
                            ValidationTuple[] objects = this.sortedTuples.toArray(new ValidationTuple[0]);
                            Arrays.parallelSort(objects, ValidationTuple::compareActiveTarget);
                            this.sortedTuples = Arrays.asList(objects);
                        } else {
                            this.sortedTuples.sort(ValidationTuple::compareActiveTarget);
                        }
                    }
                    this.sortedTuplesIterator = this.sortedTuples.iterator();
                }
                assert (!this.iterator.hasNext()) : "Iterator: " + this.iterator.toString();
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.sortTuples();
                return this.sortedTuplesIterator.next();
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort sort = (Sort)o;
        return this.parent.equals(sort.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public String toString() {
        return "Sort{parent=" + this.parent + '}';
    }
}

