/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationTuple {
    private static final Logger logger = LoggerFactory.getLogger(ValidationTuple.class);
    private static final ValueComparator valueComparator = new ValueComparator();
    private final List<Value> chain;
    private final ConstraintComponent.Scope scope;
    private final boolean propertyShapeScopeWithValue;
    private final List<ValidationResult> validationResults;
    private final Set<ValidationTuple> compressedTuples;

    public ValidationTuple(BindingSet bindingSet, String[] variables, ConstraintComponent.Scope scope, boolean hasValue) {
        this(bindingSet, Arrays.asList(variables), scope, hasValue);
    }

    public ValidationTuple(BindingSet bindingSet, List<String> variables, ConstraintComponent.Scope scope, boolean hasValue) {
        ArrayList<Value> chain = new ArrayList<Value>();
        for (String variable : variables) {
            chain.add(bindingSet.getValue(variable));
        }
        this.chain = Collections.unmodifiableList(chain);
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
        this.validationResults = Collections.emptyList();
        this.compressedTuples = Collections.emptySet();
    }

    public ValidationTuple(List<Value> targets, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = Collections.unmodifiableList(targets);
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
        this.validationResults = Collections.emptyList();
        this.compressedTuples = Collections.emptySet();
    }

    public ValidationTuple(Value a, Value c, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = Collections.unmodifiableList(Arrays.asList(a, c));
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
        this.validationResults = Collections.emptyList();
        this.compressedTuples = Collections.emptySet();
    }

    public ValidationTuple(Value subject, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = Collections.singletonList(subject);
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
        this.validationResults = Collections.emptyList();
        this.compressedTuples = Collections.emptySet();
    }

    private ValidationTuple(List<ValidationResult> validationResults, List<Value> chain, ConstraintComponent.Scope scope, boolean propertyShapeScopeWithValue, Set<ValidationTuple> compressedTuples) {
        this.validationResults = Collections.unmodifiableList(validationResults);
        this.chain = Collections.unmodifiableList(chain);
        this.scope = scope;
        this.propertyShapeScopeWithValue = propertyShapeScopeWithValue;
        this.compressedTuples = Collections.unmodifiableSet(compressedTuples);
    }

    public ValidationTuple(ValidationTuple temp, Set<ValidationTuple> compressedTuples) {
        this.validationResults = temp.validationResults;
        this.chain = temp.chain;
        this.scope = temp.scope;
        this.propertyShapeScopeWithValue = temp.propertyShapeScopeWithValue;
        this.compressedTuples = Collections.unmodifiableSet(compressedTuples);
    }

    public boolean sameTargetAs(ValidationTuple other) {
        Value current = this.getActiveTarget();
        Value currentRight = other.getActiveTarget();
        return current.equals(currentRight);
    }

    public boolean hasValue() {
        assert (this.scope != null);
        return this.propertyShapeScopeWithValue || this.scope == ConstraintComponent.Scope.nodeShape;
    }

    public Value getValue() {
        assert (this.scope != null);
        if (this.hasValue()) {
            return this.chain.get(this.chain.size() - 1);
        }
        return null;
    }

    public ConstraintComponent.Scope getScope() {
        return this.scope;
    }

    public int compareActiveTarget(ValidationTuple other) {
        Value left = this.getActiveTarget();
        Value right = other.getActiveTarget();
        return valueComparator.compare(left, right);
    }

    public int compareFullTarget(ValidationTuple other) {
        int min = Math.min(this.getFullChainSize(false), other.getFullChainSize(false));
        List<Value> targetChain = this.getTargetChain(false);
        ArrayList<Value> otherTargetChain = new ArrayList<Value>(other.getTargetChain(false));
        Iterator iterator = targetChain.iterator();
        for (int i = 0; i < min; ++i) {
            Value value = (Value)iterator.next();
            int compare = valueComparator.compare(value, otherTargetChain.get(i));
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(this.getFullChainSize(true), other.getFullChainSize(true));
    }

    public List<ValidationResult> getValidationResult() {
        return this.validationResults;
    }

    public ValidationTuple addValidationResult(Function<ValidationTuple, ValidationResult> validationResult) {
        List<ValidationResult> validationResults;
        if (!this.validationResults.isEmpty()) {
            validationResults = new ArrayList<ValidationResult>(this.validationResults);
            validationResults.add(validationResult.apply(this));
        } else {
            validationResults = Collections.singletonList(validationResult.apply(this));
        }
        Set<ValidationTuple> compressedTuples = this.compressedTuples.stream().map(t -> t.addValidationResult(validationResult)).collect(Collectors.toSet());
        return new ValidationTuple(validationResults, this.chain, this.scope, this.propertyShapeScopeWithValue, compressedTuples);
    }

    public Value getActiveTarget() {
        assert (this.scope != null);
        if (!this.propertyShapeScopeWithValue || this.scope != ConstraintComponent.Scope.propertyShape) {
            return this.chain.get(this.chain.size() - 1);
        }
        assert (this.chain.size() >= 2);
        return this.chain.get(this.chain.size() - 2);
    }

    public String toString() {
        return "ValidationTuple{chain=" + this.chain + ", scope=" + (Object)((Object)this.scope) + ", propertyShapeScopeWithValue=" + this.propertyShapeScopeWithValue + ", compressedTuples=" + Arrays.toString(this.compressedTuples.toArray()) + '}';
    }

    public List<ValidationTuple> shiftToNodeShape() {
        assert (this.scope == ConstraintComponent.Scope.propertyShape);
        if (this.compressedTuples.isEmpty()) {
            List<Value> chain = this.chain;
            boolean propertyShapeScopeWithValue = this.propertyShapeScopeWithValue;
            ConstraintComponent.Scope scope = ConstraintComponent.Scope.nodeShape;
            if (this.propertyShapeScopeWithValue) {
                propertyShapeScopeWithValue = false;
                chain = chain.subList(0, chain.size() - 1);
            }
            return Collections.singletonList(new ValidationTuple(this.validationResults, chain, scope, propertyShapeScopeWithValue, Collections.emptySet()));
        }
        return this.compressedTuples.stream().map(t -> {
            List<Value> chain = t.chain;
            boolean propertyShapeScopeWithValue = t.propertyShapeScopeWithValue;
            ConstraintComponent.Scope scope = ConstraintComponent.Scope.nodeShape;
            if (this.propertyShapeScopeWithValue) {
                propertyShapeScopeWithValue = false;
                chain = chain.subList(0, chain.size() - 1);
            }
            return new ValidationTuple(t.validationResults, chain, scope, propertyShapeScopeWithValue, Collections.emptySet());
        }).collect(Collectors.toList());
    }

    public List<ValidationTuple> shiftToPropertyShapeScope() {
        assert (this.scope == ConstraintComponent.Scope.nodeShape);
        assert (this.chain.size() >= 2);
        boolean propertyShapeScopeWithValue = true;
        ConstraintComponent.Scope scope = ConstraintComponent.Scope.propertyShape;
        if (!this.compressedTuples.isEmpty()) {
            return this.compressedTuples.stream().map(t -> new ValidationTuple(t.validationResults, t.chain, scope, propertyShapeScopeWithValue, Collections.emptySet())).collect(Collectors.toList());
        }
        return Collections.singletonList(new ValidationTuple(this.validationResults, this.chain, scope, propertyShapeScopeWithValue, Collections.emptySet()));
    }

    public int getFullChainSize(boolean includePropertyShapeValue) {
        if (!includePropertyShapeValue && this.propertyShapeScopeWithValue) {
            return this.chain.size() - 1;
        }
        return this.chain.size();
    }

    public List<Value> getTargetChain(boolean includePropertyShapeValues) {
        if (this.scope == ConstraintComponent.Scope.propertyShape && this.hasValue() && !includePropertyShapeValues) {
            return this.chain.stream().limit(this.chain.size() - 1).collect(Collectors.toList());
        }
        return new ArrayList<Value>(this.chain);
    }

    public ValidationTuple setValue(Value value) {
        if (value.equals(this.getValue())) {
            return this;
        }
        ArrayList<Value> chain = new ArrayList<Value>(this.chain);
        if (this.scope == ConstraintComponent.Scope.propertyShape) {
            if (this.propertyShapeScopeWithValue) {
                chain.remove(this.chain.size() - 1);
            }
        } else {
            throw new IllegalStateException("Can't set value on NodeShape scoped ValidationTuple because it will also change the target!");
        }
        chain.add(value);
        boolean propertyShapeScopeWithValue = true;
        Set<ValidationTuple> compressedTuples = this.compressedTuples.stream().map(t -> t.setValue(value)).collect(Collectors.toSet());
        return new ValidationTuple(this.validationResults, chain, this.scope, propertyShapeScopeWithValue, compressedTuples);
    }

    public int compareValue(ValidationTuple other) {
        Value left = this.getValue();
        Value right = other.getValue();
        return valueComparator.compare(left, right);
    }

    public ValidationTuple trimToTarget() {
        if (this.scope == ConstraintComponent.Scope.propertyShape && this.propertyShapeScopeWithValue) {
            List<Value> chain = this.chain.subList(0, this.chain.size() - 1);
            boolean propertyShapeScopeWithValue = false;
            Set<ValidationTuple> compressedTuples = this.compressedTuples.stream().map(ValidationTuple::trimToTarget).collect(Collectors.toSet());
            return new ValidationTuple(this.validationResults, chain, this.scope, propertyShapeScopeWithValue, compressedTuples);
        }
        return this;
    }

    public List<ValidationTuple> pop() {
        if (this.compressedTuples.isEmpty()) {
            List<Value> chain = this.chain;
            boolean propertyShapeScopeWithValue = this.propertyShapeScopeWithValue;
            if (this.getScope() == ConstraintComponent.Scope.propertyShape) {
                if (this.hasValue()) {
                    assert (chain.size() > 1) : "Attempting to pop chain will not leave any elements on the chain! " + this.toString();
                    chain = chain.subList(0, chain.size() - 1);
                } else {
                    propertyShapeScopeWithValue = true;
                }
            } else {
                assert (chain.size() > 1) : "Attempting to pop chain will not leave any elements on the chain! " + this.toString();
                chain = chain.subList(0, chain.size() - 1);
            }
            return Collections.singletonList(new ValidationTuple(this.validationResults, chain, this.scope, propertyShapeScopeWithValue, Collections.emptySet()));
        }
        return this.compressedTuples.stream().flatMap(t1 -> t1.pop().stream().map(t -> new ValidationTuple(t.validationResults, t.chain, t.scope, t.propertyShapeScopeWithValue, t.compressedTuples))).collect(Collectors.toList());
    }

    public Set<ValidationTuple> getCompressedTuples() {
        return this.compressedTuples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationTuple that = (ValidationTuple)o;
        return this.propertyShapeScopeWithValue == that.propertyShapeScopeWithValue && this.chain.equals(that.chain) && this.scope == that.scope && this.validationResults.equals(that.validationResults) && this.compressedTuples.equals(that.compressedTuples);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chain, this.scope, this.propertyShapeScopeWithValue, this.validationResults, this.compressedTuples});
    }

    public ValidationTuple join(ValidationTuple right) {
        HashSet<ValidationTuple> compressedTuples = new HashSet<ValidationTuple>(this.compressedTuples);
        compressedTuples.addAll(right.getCompressedTuples());
        ValidationTuple validationTuple = new ValidationTuple(this.validationResults, this.chain, this.scope, this.propertyShapeScopeWithValue, compressedTuples);
        if (this.scope == ConstraintComponent.Scope.propertyShape) {
            validationTuple = validationTuple.setValue(right.getValue());
        }
        return validationTuple;
    }
}

