/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.GroupByCountFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.NotValuesIn;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TupleMapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;

public class QualifiedMaxCountConstraintComponent
extends AbstractConstraintComponent {
    Shape qualifiedValueShape;
    Boolean qualifiedValueShapesDisjoint;
    Long qualifiedMaxCount;

    public QualifiedMaxCountConstraintComponent(Resource id, RepositoryConnection connection, Cache cache, ShaclSail shaclSail, Boolean qualifiedValueShapesDisjoint, Long qualifiedMaxCount) {
        super(id);
        ShaclProperties p = new ShaclProperties(id, connection);
        this.qualifiedValueShapesDisjoint = qualifiedValueShapesDisjoint;
        this.qualifiedMaxCount = qualifiedMaxCount;
        if (p.getType() == SHACL.NODE_SHAPE) {
            this.qualifiedValueShape = NodeShape.getInstance(p, connection, cache, false, shaclSail);
        } else if (p.getType() == SHACL.PROPERTY_SHAPE) {
            this.qualifiedValueShape = PropertyShape.getInstance(p, connection, cache, shaclSail);
        } else {
            throw new IllegalStateException("Unknown shape type for " + p.getId());
        }
    }

    public QualifiedMaxCountConstraintComponent(QualifiedMaxCountConstraintComponent constraintComponent) {
        super(constraintComponent.getId());
        this.qualifiedValueShape = (Shape)constraintComponent.qualifiedValueShape.deepClone();
        this.qualifiedValueShapesDisjoint = constraintComponent.qualifiedValueShapesDisjoint;
        this.qualifiedMaxCount = constraintComponent.qualifiedMaxCount;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.QUALIFIED_VALUE_SHAPE, (Value)this.getId(), new Resource[0]);
        if (this.qualifiedValueShapesDisjoint != null) {
            model.add(subject, SHACL.QUALIFIED_VALUE_SHAPES_DISJOINT, (Value)Values.literal((Object)this.qualifiedValueShapesDisjoint), new Resource[0]);
        }
        if (this.qualifiedMaxCount != null) {
            model.add(subject, SHACL.QUALIFIED_MAX_COUNT, (Value)Values.literal((BigInteger)BigInteger.valueOf(this.qualifiedMaxCount)), new Resource[0]);
        }
        this.qualifiedValueShape.toModel(null, null, model, cycleDetection);
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain);
        this.qualifiedValueShape.setTargetChain(targetChain.setOptimizable(false));
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.QualifiedMaxCountConstraintComponent;
    }

    @Override
    public PlanNode generateSparqlValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        assert (scope == ConstraintComponent.Scope.propertyShape);
        throw new ShaclUnsupportedException();
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        assert (scope == ConstraintComponent.Scope.propertyShape);
        PlanNode target = overrideTargetNode != null ? this.getTargetChain().getEffectiveTarget("_target", scope, connectionsGroup.getRdfsSubClassOfReasoner()).extend(overrideTargetNode.getPlanNode(), connectionsGroup, scope, EffectiveTarget.Extend.right, false) : this.getAllTargetsPlan(connectionsGroup, scope);
        PlanNode planNode = this.negated(connectionsGroup, logValidationPlans, overrideTargetNode, scope);
        planNode = new LeftOuterJoin(target, planNode);
        GroupByCountFilter groupByCountFilter = new GroupByCountFilter(planNode, count -> count > this.qualifiedMaxCount);
        return new Unique(new TrimToTarget(groupByCountFilter), false);
    }

    public PlanNode negated(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        PlanNodeProvider planNodeProvider = () -> {
            PlanNode target = this.getAllTargetsPlan(connectionsGroup, scope);
            if (overrideTargetNode != null) {
                target = this.getTargetChain().getEffectiveTarget("_target", scope, connectionsGroup.getRdfsSubClassOfReasoner()).extend(overrideTargetNode.getPlanNode(), connectionsGroup, scope, EffectiveTarget.Extend.right, false);
            }
            target = new Unique(new TrimToTarget(target), false);
            BulkedExternalLeftOuterJoin relevantTargetsWithPath = new BulkedExternalLeftOuterJoin(target, connectionsGroup.getBaseConnection(), this.getTargetChain().getPath().get().getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner()), false, null, b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true));
            return new TupleMapper(relevantTargetsWithPath, t -> {
                List<Value> targetChain = t.getTargetChain(true);
                return new ValidationTuple(targetChain, ConstraintComponent.Scope.propertyShape, false);
            });
        };
        PlanNode planNode = this.qualifiedValueShape.generateTransactionalValidationPlan(connectionsGroup, logValidationPlans, planNodeProvider, scope);
        PlanNode invalid = new Unique(planNode, false);
        PlanNode allTargetsPlan = this.getAllTargetsPlan(connectionsGroup, scope);
        if (overrideTargetNode != null) {
            allTargetsPlan = this.getTargetChain().getEffectiveTarget("_target", scope, connectionsGroup.getRdfsSubClassOfReasoner()).extend(overrideTargetNode.getPlanNode(), connectionsGroup, scope, EffectiveTarget.Extend.right, false);
        }
        allTargetsPlan = new Unique(new TrimToTarget(allTargetsPlan), false);
        allTargetsPlan = new BulkedExternalLeftOuterJoin(allTargetsPlan, connectionsGroup.getBaseConnection(), this.getTargetChain().getPath().get().getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner()), false, null, b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true));
        invalid = new NotValuesIn(allTargetsPlan, invalid);
        return invalid;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        assert (scope == ConstraintComponent.Scope.propertyShape);
        PlanNode allTargets = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.propertyShape, true);
        PlanNode subTargets = this.qualifiedValueShape.getAllTargetsPlan(connectionsGroup, scope);
        Unique unique = new Unique(new TrimToTarget(new UnionNode(allTargets, subTargets)), false);
        return unique;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new QualifiedMaxCountConstraintComponent(this);
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        return true;
    }
}

