/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.model;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ExceptionConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iterator.CloseableIterationIterator;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.AbstractModel;
import org.eclipse.rdf4j.model.impl.FilteredModel;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.model.NonSerializables;

@InternalUseOnly
public class SailModel
extends AbstractModel {
    private static final long serialVersionUID = -2104886971549374410L;
    private transient SailConnection conn;
    private UUID connKey;
    private boolean includeInferred;

    public SailModel(SailConnection conn, boolean includeInferred) {
        this.conn = conn;
        this.includeInferred = includeInferred;
    }

    public void setConnection(SailConnection conn) {
        this.conn = conn;
    }

    @Override
    public Set<Namespace> getNamespaces() {
        Set<Namespace> namespaces;
        try (CloseableIteration<? extends Namespace, SailException> iter = this.conn.getNamespaces();){
            namespaces = Iterations.asSet(this.conn.getNamespaces());
        }
        catch (SailException e) {
            throw new ModelException(e);
        }
        return namespaces;
    }

    @Override
    public Optional<Namespace> getNamespace(String prefix) {
        try {
            String name = this.conn.getNamespace(prefix);
            return name != null ? Optional.of(new SimpleNamespace(prefix, name)) : Optional.ofNullable(null);
        }
        catch (SailException e) {
            throw new ModelException(e);
        }
    }

    @Override
    public Namespace setNamespace(String prefix, String name) {
        try {
            this.conn.setNamespace(prefix, name);
        }
        catch (SailException e) {
            throw new ModelException(e);
        }
        return new SimpleNamespace(prefix, name);
    }

    @Override
    public void setNamespace(Namespace namespace) {
        try {
            this.conn.setNamespace(namespace.getPrefix(), namespace.getName());
        }
        catch (SailException e) {
            throw new ModelException(e);
        }
    }

    @Override
    public Optional<Namespace> removeNamespace(String prefix) {
        Namespace namespace = this.getNamespace(prefix).orElse(null);
        if (namespace != null) {
            try {
                this.conn.removeNamespace(prefix);
            }
            catch (SailException e) {
                throw new ModelException(e);
            }
        }
        return Optional.ofNullable(namespace);
    }

    @Override
    public boolean contains(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        try {
            return this.conn.hasStatement(subj, pred, obj, this.includeInferred, contexts);
        }
        catch (SailException e) {
            throw new ModelException(e);
        }
    }

    @Override
    public boolean add(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (subj == null || pred == null || obj == null) {
            throw new UnsupportedOperationException("Incomplete statement");
        }
        boolean exists = this.contains(subj, pred, obj, contexts);
        if (!exists) {
            try {
                this.conn.addStatement(subj, pred, obj, contexts);
            }
            catch (SailException e) {
                throw new ModelException(e);
            }
        }
        return !exists;
    }

    @Override
    public boolean remove(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        boolean exists = this.contains(subj, pred, obj, contexts);
        if (exists) {
            try {
                this.conn.removeStatements(subj, pred, obj, contexts);
            }
            catch (SailException e) {
                throw new ModelException(e);
            }
        }
        return exists;
    }

    @Override
    public boolean clear(Resource ... contexts) {
        boolean exists = this.contains(null, null, null, contexts);
        if (exists) {
            try {
                this.conn.clear(contexts);
            }
            catch (SailException e) {
                throw new ModelException(e);
            }
        }
        return exists;
    }

    @Override
    public Model filter(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return new FilteredModel(this, subj, pred, obj, contexts){
            private static final long serialVersionUID = -3834026632361358191L;

            @Override
            public Iterator<Statement> iterator() {
                return SailModel.this.iterator(this.subj, this.pred, this.obj, this.contexts);
            }

            @Override
            protected void removeFilteredTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
                SailModel.this.removeTermIteration(iter, subj, pred, obj, contexts);
            }
        };
    }

    @Override
    public void removeTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
        try {
            this.conn.removeStatements(subj, pred, obj, contexts);
        }
        catch (SailException e) {
            throw new ModelException(e);
        }
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.iterator(null, null, null, new Resource[0]);
    }

    private Iterator<Statement> iterator(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        try {
            CloseableIteration<? extends Statement, SailException> iter = this.conn.getStatements(subj, pred, obj, this.includeInferred, contexts);
            return new CloseableIterationIterator<Statement>(new ExceptionConvertingIteration<Statement, ModelException>(iter){
                private Statement last;

                @Override
                public Statement next() {
                    this.last = (Statement)super.next();
                    return this.last;
                }

                @Override
                public void remove() {
                    if (this.last == null) {
                        throw new IllegalStateException("next() not yet called");
                    }
                    SailModel.this.remove(this.last);
                    this.last = null;
                }

                @Override
                protected ModelException convert(Exception e) {
                    throw new ModelException(e);
                }
            });
        }
        catch (SailException e) {
            throw new ModelException(e);
        }
    }

    @Override
    protected void closeIterator(Iterator<?> iter) {
        if (iter instanceof Closeable) {
            try {
                ((Closeable)((Object)iter)).close();
            }
            catch (IOException ioe) {
                throw new ModelException(ioe);
            }
        } else {
            super.closeIterator(iter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long lsize;
        if (!this.includeInferred) {
            try {
                lsize = this.conn.size(new Resource[0]);
            }
            catch (SailException e) {
                throw new ModelException(e);
            }
        }
        lsize = 0L;
        Iterator<Statement> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                ++lsize;
                iter.next();
            }
        }
        finally {
            this.closeIterator(iter);
        }
        return lsize < Integer.MAX_VALUE ? (int)lsize : Integer.MAX_VALUE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.connKey = NonSerializables.register(this.conn);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.conn = (SailConnection)SailConnection.class.cast(NonSerializables.get(this.connKey));
    }
}

