/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlTargetSelect
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(SparqlTargetSelect.class);
    private final SailConnection connection;
    private final String query;
    private final String[] variables;
    private final ConstraintComponent.Scope scope;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public SparqlTargetSelect(SailConnection connection, String query, ConstraintComponent.Scope scope) {
        this.connection = connection;
        this.query = query;
        assert (query.contains("?this")) : "Query should contain ?this: " + query;
        this.variables = new String[]{"?this"};
        this.scope = scope;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet;
            {
                QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
                try {
                    ParsedQuery parsedQuery = queryParserFactory.getParser().parseQuery(SparqlTargetSelect.this.query, null);
                    this.bindingSet = SparqlTargetSelect.this.connection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)new MapBindingSet(), true);
                }
                catch (MalformedQueryException e) {
                    logger.error("Malformed query: \n{}", (Object)SparqlTargetSelect.this.query);
                    throw e;
                }
            }

            public void close() throws SailException {
                this.bindingSet.close();
            }

            @Override
            protected boolean localHasNext() throws SailException {
                return this.bindingSet.hasNext();
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                return new ValidationTuple((BindingSet)this.bindingSet.next(), SparqlTargetSelect.this.variables, SparqlTargetSelect.this.scope, false);
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId()).append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "SparqlTargetSelect{query='" + this.query.replace("\n", "  ") + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparqlTargetSelect select = (SparqlTargetSelect)o;
        return Objects.equals(this.connection instanceof MemoryStoreConnection ? ((MemoryStoreConnection)this.connection).getSail() : this.connection, select.connection instanceof MemoryStoreConnection ? ((MemoryStoreConnection)select.connection).getSail() : select.connection) && this.query.equals(select.query);
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()), this.query);
        }
        return Objects.hash(System.identityHashCode(this.connection), this.query);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }
}

