/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.CloseablePeakableIteration;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unique
implements PlanNode {
    private final Logger logger = LoggerFactory.getLogger(Unique.class);
    private final boolean compress;
    private StackTraceElement[] stackTrace;
    PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Unique(PlanNode parent, boolean compress) {
        this.parent = parent = PlanNodeHelper.handleSorting(this, parent);
        this.compress = compress;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseablePeakableIteration<? extends ValidationTuple, SailException> parentIterator;
            Set<ValidationTupleValueAndActiveTarget> targetAndValueDedupeSet;
            boolean propertyShapeWithValue;
            ValidationTuple next;
            ValidationTuple previous;
            {
                this.parentIterator = new CloseablePeakableIteration<ValidationTuple, SailException>(Unique.this.parent.iterator());
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                while (this.next == null && this.parentIterator.hasNext()) {
                    ValidationTuple temp = this.parentIterator.next();
                    assert (!this.propertyShapeWithValue || temp.getScope() == ConstraintComponent.Scope.propertyShape && temp.hasValue());
                    if (temp.getScope() == ConstraintComponent.Scope.propertyShape && temp.hasValue()) {
                        this.propertyShapeWithValue = true;
                    }
                    if (Unique.this.compress) {
                        HashSet<ValidationTuple> tuples = new HashSet<ValidationTuple>();
                        if (this.propertyShapeWithValue) {
                            while (this.parentIterator.hasNext() && this.parentIterator.peek().getValue().equals(temp.getValue())) {
                                tuples.add(this.parentIterator.next());
                            }
                        } else {
                            while (this.parentIterator.hasNext() && this.parentIterator.peek().sameTargetAs(temp)) {
                                tuples.add(this.parentIterator.next());
                            }
                        }
                        if (tuples.isEmpty()) {
                            this.next = temp;
                        } else {
                            tuples.add(temp);
                            this.next = new ValidationTuple(temp, tuples);
                        }
                    } else if (this.previous == null) {
                        this.next = temp;
                    } else if (this.propertyShapeWithValue) {
                        if (this.targetAndValueDedupeSet == null || !this.previous.sameTargetAs(temp)) {
                            this.targetAndValueDedupeSet = new HashSet<ValidationTupleValueAndActiveTarget>();
                            if (this.previous.sameTargetAs(temp)) {
                                this.targetAndValueDedupeSet.add(new ValidationTupleValueAndActiveTarget(this.previous));
                            }
                        }
                        if (!this.targetAndValueDedupeSet.contains(new ValidationTupleValueAndActiveTarget(temp))) {
                            this.next = temp;
                            this.targetAndValueDedupeSet.add(new ValidationTupleValueAndActiveTarget(this.next));
                        }
                    } else if (!this.previous.sameTargetAs(temp)) {
                        this.next = temp;
                    }
                    if (this.next != null) {
                        this.previous = this.next;
                        continue;
                    }
                    if (!GlobalValidationExecutionLogging.loggingEnabled) continue;
                    Unique.this.validationExecutionLogger.log(Unique.this.depth(), Unique.this.getClass().getSimpleName() + ":IgnoredNotUnique ", temp, Unique.this, Unique.this.getId(), Unique.this.stackTrace != null ? Unique.this.stackTrace[2].toString() : null);
                }
            }

            @Override
            public void close() throws SailException {
                this.targetAndValueDedupeSet = null;
                this.parentIterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                assert (this.previous == null || this.next.compareActiveTarget(this.previous) >= 0);
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Unique unique = (Unique)o;
        return this.parent.equals(unique.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent, Unique.class);
    }

    public String toString() {
        return "Unique{compress=" + this.compress + ", parent=" + this.parent + '}';
    }

    static class ValidationTupleValueAndActiveTarget {
        private final ValidationTuple validationTuple;

        public ValidationTupleValueAndActiveTarget(ValidationTuple validationTuple) {
            this.validationTuple = validationTuple;
        }

        public ValidationTuple getValidationTuple() {
            return this.validationTuple;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidationTupleValueAndActiveTarget oValidationTuple = (ValidationTupleValueAndActiveTarget)o;
            if (this.validationTuple.hasValue() || oValidationTuple.validationTuple.hasValue()) {
                assert (this.validationTuple.hasValue() && oValidationTuple.validationTuple.hasValue());
                return this.validationTuple.getValue().equals(oValidationTuple.validationTuple.getValue()) && this.validationTuple.getActiveTarget().equals(oValidationTuple.validationTuple.getActiveTarget());
            }
            return this.validationTuple.getActiveTarget().equals(oValidationTuple.validationTuple.getActiveTarget());
        }

        public int hashCode() {
            return Objects.hash(this.validationTuple.getActiveTarget(), this.validationTuple.getValue());
        }
    }
}

