/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.NotValuesIn;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;

public class NotConstraintComponent
extends AbstractConstraintComponent {
    Shape not;

    public NotConstraintComponent(Resource id, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        super(id);
        ShaclProperties p = new ShaclProperties(id, connection);
        if (p.getType() == SHACL.NODE_SHAPE) {
            this.not = NodeShape.getInstance(p, connection, cache, false, shaclSail);
        } else if (p.getType() == SHACL.PROPERTY_SHAPE) {
            this.not = PropertyShape.getInstance(p, connection, cache, shaclSail);
        } else {
            throw new IllegalStateException("Unknown shape type for " + p.getId());
        }
    }

    public NotConstraintComponent(NotConstraintComponent notConstraintComponent) {
        super(notConstraintComponent.getId());
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> exported) {
        model.add(subject, SHACL.NOT, (Value)this.getId(), new Resource[0]);
        this.not.toModel(null, null, model, exported);
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain);
        this.not.setTargetChain(targetChain.setOptimizable(false));
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.NotConstraintComponent;
    }

    @Override
    public PlanNode generateSparqlValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        return this.not.generateSparqlValidationPlan(connectionsGroup, logValidationPlans, !negatePlan, false, scope);
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        PlanNode allTargetsPlan;
        PlanNodeProvider planNodeProvider = overrideTargetNode != null ? overrideTargetNode : () -> this.getAllTargetsPlan(connectionsGroup, scope);
        PlanNode planNode = this.not.generateTransactionalValidationPlan(connectionsGroup, logValidationPlans, planNodeProvider, scope);
        PlanNode invalid = new Unique(planNode);
        if (overrideTargetNode != null) {
            if (scope == ConstraintComponent.Scope.propertyShape) {
                allTargetsPlan = this.getTargetChain().getEffectiveTarget("_target", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).extend(planNodeProvider.getPlanNode(), connectionsGroup, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.right, false);
                allTargetsPlan = new Unique(new ShiftToPropertyShape(allTargetsPlan));
            } else {
                allTargetsPlan = this.getTargetChain().getEffectiveTarget("_target", scope, connectionsGroup.getRdfsSubClassOfReasoner()).extend(planNodeProvider.getPlanNode(), connectionsGroup, scope, EffectiveTarget.Extend.right, false);
            }
        } else {
            allTargetsPlan = planNodeProvider.getPlanNode();
        }
        invalid = new NotValuesIn(allTargetsPlan, invalid);
        return invalid;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        PlanNode allTargets;
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.nodeShape, true);
            allTargets = new Unique(new ShiftToPropertyShape(allTargetsPlan));
        } else {
            allTargets = this.getTargetChain().getEffectiveTarget("target_", scope, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, scope, true);
        }
        PlanNode notTargets = this.not.getAllTargetsPlan(connectionsGroup, scope);
        return new Unique(new UnionNode(allTargets, notTargets));
    }

    @Override
    public ConstraintComponent deepClone() {
        NotConstraintComponent notConstraintComponent = new NotConstraintComponent(this);
        notConstraintComponent.not = (Shape)this.not.deepClone();
        return notConstraintComponent;
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        return this.not.requiresEvaluation(connectionsGroup, scope);
    }
}

