/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class MaxLengthFilter
extends FilterPlanNode {
    private final long maxLength;

    public MaxLengthFilter(PlanNode parent, long maxLength) {
        super(parent);
        this.maxLength = maxLength;
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value literal = t.getValue();
        return (long)literal.stringValue().length() <= this.maxLength;
    }

    @Override
    public String toString() {
        return "MaxLengthFilter{maxLength=" + this.maxLength + '}';
    }
}

