/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.MultiStreamPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PushablePlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTupleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerJoin
implements MultiStreamPlanNode,
PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(InnerJoin.class);
    private StackTraceElement[] stackTrace;
    private boolean printed = false;
    private final PlanNode left;
    private final PlanNode right;
    private CloseableIteration<ValidationTuple, SailException> iterator;
    private PushablePlanNode joined;
    private PushablePlanNode discardedLeft;
    private PushablePlanNode discardedRight;
    private ValidationExecutionLogger validationExecutionLogger;

    public InnerJoin(PlanNode left, PlanNode right) {
        left = PlanNodeHelper.handleSorting(this, left);
        right = PlanNodeHelper.handleSorting(this, right);
        this.left = left;
        this.right = right;
    }

    public List<PlanNode> parent() {
        return Arrays.asList(this.left, this.right);
    }

    public PlanNode getJoined(Class<? extends PushablePlanNode> type) {
        if (this.joined != null) {
            throw new IllegalStateException();
        }
        this.joined = type == BufferedPlanNode.class ? new BufferedPlanNode<InnerJoin>(this, "Joined") : new UnBufferedPlanNode<InnerJoin>(this, "Joined");
        return this.joined;
    }

    public PlanNode getDiscardedLeft(Class<? extends PushablePlanNode> type) {
        if (this.discardedLeft != null) {
            throw new IllegalStateException();
        }
        this.discardedLeft = type == BufferedPlanNode.class ? new BufferedPlanNode<InnerJoin>(this, "DiscardedLeft") : new UnBufferedPlanNode<InnerJoin>(this, "DiscaredLeft");
        return this.discardedLeft;
    }

    public PlanNode getDiscardedRight(Class<? extends PushablePlanNode> type) {
        if (this.discardedRight != null) {
            throw new IllegalStateException();
        }
        this.discardedRight = type == BufferedPlanNode.class ? new BufferedPlanNode<InnerJoin>(this, "DiscardedRight") : new UnBufferedPlanNode<InnerJoin>(this, "DiscardedRight");
        return this.discardedRight;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        throw new IllegalStateException();
    }

    public CloseableIteration<ValidationTuple, SailException> internalIterator() {
        return new CloseableIteration<ValidationTuple, SailException>(){
            final CloseableIteration<? extends ValidationTuple, SailException> leftIterator;
            final CloseableIteration<? extends ValidationTuple, SailException> rightIterator;
            ValidationTuple next;
            ValidationTuple nextLeft;
            ValidationTuple nextRight;
            ValidationTuple joinedLeft;
            {
                this.leftIterator = InnerJoin.this.left.iterator();
                this.rightIterator = InnerJoin.this.right.iterator();
            }

            void calculateNext() {
                if (this.next != null) {
                    return;
                }
                ValidationTuple prevLeft = this.nextLeft;
                if (this.nextLeft == null && this.leftIterator.hasNext()) {
                    this.nextLeft = (ValidationTuple)this.leftIterator.next();
                }
                if (this.nextRight == null && this.rightIterator.hasNext()) {
                    this.nextRight = (ValidationTuple)this.rightIterator.next();
                }
                if (this.nextRight == null && prevLeft == null && this.nextLeft != null) {
                    if (InnerJoin.this.discardedLeft != null) {
                        InnerJoin.this.discardedLeft.push(this.nextLeft);
                    }
                    return;
                }
                if (this.nextLeft == null) {
                    if (InnerJoin.this.discardedRight != null) {
                        while (this.nextRight != null) {
                            InnerJoin.this.discardedRight.push(this.nextRight);
                            if (this.rightIterator.hasNext()) {
                                this.nextRight = (ValidationTuple)this.rightIterator.next();
                                continue;
                            }
                            this.nextRight = null;
                        }
                    }
                    return;
                }
                while (this.next == null) {
                    if (this.nextRight != null) {
                        if (this.nextLeft.sameTargetAs(this.nextRight)) {
                            this.next = ValidationTupleHelper.join(this.nextLeft, this.nextRight);
                            this.joinedLeft = this.nextLeft;
                            this.nextRight = null;
                            continue;
                        }
                        int compareTo = this.nextLeft.compareTarget(this.nextRight);
                        if (compareTo < 0) {
                            if (this.joinedLeft != this.nextLeft && InnerJoin.this.discardedLeft != null) {
                                InnerJoin.this.discardedLeft.push(this.nextLeft);
                            }
                            if (this.leftIterator.hasNext()) {
                                this.nextLeft = (ValidationTuple)this.leftIterator.next();
                                continue;
                            }
                            this.nextLeft = null;
                            break;
                        }
                        if (InnerJoin.this.discardedRight != null) {
                            InnerJoin.this.discardedRight.push(this.nextRight);
                        }
                        if (this.rightIterator.hasNext()) {
                            this.nextRight = (ValidationTuple)this.rightIterator.next();
                            continue;
                        }
                        this.nextRight = null;
                        break;
                    }
                    if (InnerJoin.this.discardedLeft != null) {
                        while (this.leftIterator.hasNext()) {
                            InnerJoin.this.discardedLeft.push((ValidationTuple)this.leftIterator.next());
                        }
                    }
                    return;
                }
            }

            @Override
            public void close() throws SailException {
                this.leftIterator.close();
                this.rightIterator.close();
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            public ValidationTuple next() throws SailException {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return Math.max(this.left.depth(), this.right.depth());
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        this.left.getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.left.getId() + " -> " + this.getId() + " [label=\"left\"];").append("\n");
        stringBuilder.append(this.right.getId() + " -> " + this.getId() + " [label=\"right\"];").append("\n");
        this.right.getPlanAsGraphvizDot(stringBuilder);
        if (this.discardedRight != null) {
            stringBuilder.append(this.getId() + " -> " + this.discardedRight.getId() + " [label=\"discardedRight\"];").append("\n");
        }
        if (this.discardedLeft != null) {
            stringBuilder.append(this.getId() + " -> " + this.discardedLeft.getId() + " [label=\"discardedLeft\"];").append("\n");
        }
        if (this.joined != null) {
            stringBuilder.append(this.getId() + " -> " + this.joined.getId() + " [label=\"joined\"];").append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "InnerJoin";
    }

    private String leadingSpace() {
        return StringUtils.leftPad((String)"", (int)this.depth(), (String)"    ");
    }

    @Override
    public void init() {
        if (this.iterator == null) {
            this.iterator = this.internalIterator();
        }
    }

    @Override
    public void close() {
        if (!(this.discardedLeft != null && !this.discardedLeft.isClosed() || this.discardedRight != null && !this.discardedRight.isClosed() || this.joined != null && !this.joined.isClosed())) {
            this.iterator.close();
            this.iterator = null;
        }
    }

    @Override
    public boolean incrementIterator() {
        if (this.iterator.hasNext()) {
            ValidationTuple next = (ValidationTuple)this.iterator.next();
            if (this.joined != null) {
                this.joined.push(next);
            }
            return true;
        }
        return false;
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        PlanNode[] planNodes;
        this.validationExecutionLogger = validationExecutionLogger;
        for (PlanNode planNode : planNodes = new PlanNode[]{this.joined, this.discardedLeft, this.discardedRight, this.left, this.right}) {
            if (planNode == null) continue;
            planNode.receiveLogger(validationExecutionLogger);
        }
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }
}

