/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.SailConflictException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailDatasetImpl;
import org.eclipse.rdf4j.sail.base.SailSink;

abstract class Changeset
implements SailSink,
ModelFactory {
    private Set<SailDatasetImpl> refbacks;
    private Set<Changeset> prepend;
    private Set<StatementPattern> observations;
    private Model approved;
    private Model deprecated;
    private Set<Resource> approvedContexts;
    private Set<Resource> deprecatedContexts;
    private Map<String, String> addedNamespaces;
    private Set<String> removedPrefixes;
    private boolean namespaceCleared;
    private boolean statementCleared;

    Changeset() {
    }

    @Override
    public void close() throws SailException {
    }

    @Override
    public void prepare() throws SailException {
        if (this.prepend != null && this.observations != null) {
            for (StatementPattern p : this.observations) {
                Resource subj = (Resource)p.getSubjectVar().getValue();
                IRI pred = (IRI)p.getPredicateVar().getValue();
                Value obj = p.getObjectVar().getValue();
                Var ctxVar = p.getContextVar();
                Resource[] contexts = ctxVar == null ? new Resource[]{} : new Resource[]{(Resource)ctxVar.getValue()};
                for (Changeset changeset : this.prepend) {
                    if (!changeset.hasApproved(subj, pred, obj, contexts) && !changeset.hasDeprecated(subj, pred, obj, contexts)) continue;
                    throw new SailConflictException("Observed State has Changed");
                }
            }
        }
    }

    synchronized boolean hasApproved(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        if (this.approved == null) {
            return false;
        }
        return this.approved.contains(subj, pred, obj, contexts);
    }

    synchronized boolean hasDeprecated(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        if (this.deprecated == null) {
            return false;
        }
        return this.deprecated.contains(subj, pred, obj, contexts);
    }

    public synchronized void addRefback(SailDatasetImpl dataset) {
        if (this.refbacks == null) {
            this.refbacks = new HashSet<SailDatasetImpl>();
        }
        this.refbacks.add(dataset);
    }

    public synchronized void removeRefback(SailDatasetImpl dataset) {
        if (this.refbacks != null) {
            this.refbacks.remove(dataset);
        }
    }

    public synchronized boolean isRefback() {
        return this.refbacks != null && !this.refbacks.isEmpty();
    }

    public synchronized void prepend(Changeset changeset) {
        if (this.prepend == null) {
            this.prepend = new HashSet<Changeset>();
        }
        this.prepend.add(changeset);
    }

    @Override
    public synchronized void setNamespace(String prefix, String name) {
        if (this.removedPrefixes == null) {
            this.removedPrefixes = new HashSet<String>();
        }
        this.removedPrefixes.add(prefix);
        if (this.addedNamespaces == null) {
            this.addedNamespaces = new HashMap<String, String>();
        }
        this.addedNamespaces.put(prefix, name);
    }

    @Override
    public synchronized void removeNamespace(String prefix) {
        if (this.addedNamespaces != null) {
            this.addedNamespaces.remove(prefix);
        }
        if (this.removedPrefixes == null) {
            this.removedPrefixes = new HashSet<String>();
        }
        this.removedPrefixes.add(prefix);
    }

    @Override
    public synchronized void clearNamespaces() {
        if (this.removedPrefixes != null) {
            this.removedPrefixes.clear();
        }
        if (this.addedNamespaces != null) {
            this.addedNamespaces.clear();
        }
        this.namespaceCleared = true;
    }

    @Override
    public synchronized void observe(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailConflictException {
        if (this.observations == null) {
            this.observations = new HashSet<StatementPattern>();
        }
        if (contexts == null) {
            this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj), new Var("g", null)));
        } else if (contexts.length == 0) {
            this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj)));
        } else {
            for (Resource ctx : contexts) {
                this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj), new Var("g", (Value)ctx)));
            }
        }
    }

    @Override
    public synchronized void clear(Resource ... contexts) {
        if (contexts != null && contexts.length == 0) {
            if (this.approved != null) {
                this.approved.clear();
            }
            if (this.approvedContexts != null) {
                this.approvedContexts.clear();
            }
            this.statementCleared = true;
        } else {
            if (this.approved != null) {
                this.approved.remove(null, null, null, contexts);
            }
            if (this.approvedContexts != null) {
                this.approvedContexts.removeAll(Arrays.asList(contexts));
            }
            if (this.deprecatedContexts == null) {
                this.deprecatedContexts = new HashSet<Resource>();
            }
            this.deprecatedContexts.addAll(Arrays.asList(contexts));
        }
    }

    @Override
    public synchronized void approve(Resource subj, IRI pred, Value obj, Resource ctx) {
        if (this.deprecated != null) {
            this.deprecated.remove(subj, pred, obj, new Resource[]{ctx});
        }
        if (this.approved == null) {
            this.approved = this.createEmptyModel();
        }
        this.approved.add(subj, pred, obj, new Resource[]{ctx});
        if (ctx != null) {
            if (this.approvedContexts == null) {
                this.approvedContexts = new HashSet<Resource>();
            }
            this.approvedContexts.add(ctx);
        }
    }

    @Override
    public synchronized void approve(Statement statement) {
        if (this.deprecated != null) {
            this.deprecated.remove((Object)statement);
        }
        if (this.approved == null) {
            this.approved = this.createEmptyModel();
        }
        this.approved.add((Object)statement);
        if (statement.getContext() != null) {
            if (this.approvedContexts == null) {
                this.approvedContexts = new HashSet<Resource>();
            }
            this.approvedContexts.add(statement.getContext());
        }
    }

    @Override
    public synchronized void deprecate(Statement statement) {
        if (this.approved != null) {
            this.approved.remove((Object)statement);
        }
        if (this.deprecated == null) {
            this.deprecated = this.createEmptyModel();
        }
        this.deprecated.add((Object)statement);
        Resource ctx = statement.getContext();
        if (this.approvedContexts != null && this.approvedContexts.contains(ctx) && !this.approved.contains(null, null, null, new Resource[]{ctx})) {
            this.approvedContexts.remove(ctx);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.observations != null) {
            sb.append(this.observations.size());
            sb.append(" observations, ");
        }
        if (this.namespaceCleared) {
            sb.append("namespaceCleared, ");
        }
        if (this.removedPrefixes != null) {
            sb.append(this.removedPrefixes.size());
            sb.append(" removedPrefixes, ");
        }
        if (this.addedNamespaces != null) {
            sb.append(this.addedNamespaces.size());
            sb.append(" addedNamespaces, ");
        }
        if (this.statementCleared) {
            sb.append("statementCleared, ");
        }
        if (this.deprecatedContexts != null && !this.deprecatedContexts.isEmpty()) {
            sb.append(this.deprecatedContexts.size());
            sb.append(" deprecatedContexts, ");
        }
        if (this.deprecated != null) {
            sb.append(this.deprecated.size());
            sb.append(" deprecated, ");
        }
        if (this.approved != null) {
            sb.append(this.approved.size());
            sb.append(" approved, ");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 2);
        }
        return super.toString();
    }

    protected void setChangeset(Changeset from) {
        this.observations = from.observations;
        this.approved = from.approved;
        this.deprecated = from.deprecated;
        this.approvedContexts = from.approvedContexts;
        this.deprecatedContexts = from.deprecatedContexts;
        this.addedNamespaces = from.addedNamespaces;
        this.removedPrefixes = from.removedPrefixes;
        this.namespaceCleared = from.namespaceCleared;
        this.statementCleared = from.statementCleared;
    }

    public synchronized Set<StatementPattern> getObservations() {
        return this.cloneSet(this.observations);
    }

    public synchronized Set<Resource> getApprovedContexts() {
        return this.cloneSet(this.approvedContexts);
    }

    public synchronized Set<Resource> getDeprecatedContexts() {
        return this.cloneSet(this.deprecatedContexts);
    }

    public synchronized boolean isStatementCleared() {
        return this.statementCleared;
    }

    public synchronized Map<String, String> getAddedNamespaces() {
        return this.addedNamespaces;
    }

    public synchronized Set<String> getRemovedPrefixes() {
        return this.cloneSet(this.removedPrefixes);
    }

    public synchronized boolean isNamespaceCleared() {
        return this.namespaceCleared;
    }

    public synchronized boolean hasDeprecated() {
        return this.deprecated != null && !this.deprecated.isEmpty();
    }

    boolean isChanged() {
        return this.approved != null || this.deprecated != null || this.approvedContexts != null || this.deprecatedContexts != null || this.addedNamespaces != null || this.removedPrefixes != null || this.statementCleared || this.namespaceCleared || this.observations != null;
    }

    synchronized List<Statement> getDeprecatedStatements() {
        if (this.deprecated == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Statement>((Collection<Statement>)this.deprecated);
    }

    synchronized List<Statement> getApprovedStatements() {
        if (this.approved == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Statement>((Collection<Statement>)this.approved);
    }

    synchronized boolean hasDeprecated(Statement statement) {
        if (this.deprecated == null) {
            return false;
        }
        return this.deprecated.contains((Object)statement);
    }

    synchronized boolean hasApproved() {
        return this.approved != null && !this.approved.isEmpty();
    }

    synchronized Iterable<Statement> getApprovedStatements(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        if (this.approved == null) {
            return Collections.emptyList();
        }
        Iterable statements = this.approved.getStatements(subj, pred, obj, contexts);
        if (statements instanceof Collection) {
            return new ArrayList<Statement>((Collection)statements);
        }
        return StreamSupport.stream(statements.spliterator(), false).collect(Collectors.toList());
    }

    synchronized Iterable<Triple> getApprovedTriples(Resource subj, IRI pred, Value obj) {
        if (this.approved == null) {
            return Collections.emptyList();
        }
        Stream<Triple> approvedSubjectTriples = this.approved.parallelStream().filter(st -> st.getSubject() instanceof Triple).map(st -> (Triple)st.getSubject()).filter(t -> {
            if (subj != null && !subj.equals(t.getSubject())) {
                return false;
            }
            if (pred != null && !pred.equals((Object)t.getPredicate())) {
                return false;
            }
            return obj == null || obj.equals(t.getObject());
        });
        Stream<Triple> approvedObjectTriples = this.approved.parallelStream().filter(st -> st.getObject() instanceof Triple).map(st -> (Triple)st.getObject()).filter(t -> {
            if (subj != null && !subj.equals(t.getSubject())) {
                return false;
            }
            if (pred != null && !pred.equals((Object)t.getPredicate())) {
                return false;
            }
            return obj == null || obj.equals(t.getObject());
        });
        return Stream.concat(approvedSubjectTriples, approvedObjectTriples).collect(Collectors.toList());
    }

    synchronized void removeApproved(Statement next) {
        if (this.approved != null) {
            this.approved.remove((Object)next);
        }
    }

    private <T> Set<T> cloneSet(Set<T> deprecatedContexts) {
        if (deprecatedContexts == null) {
            return null;
        }
        return new HashSet<T>(deprecatedContexts);
    }
}

