/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LogStatement;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationExecutionLogger {
    private static final Logger logger = LoggerFactory.getLogger(ValidationExecutionLogger.class);
    private List<LogStatement> list = null;
    private static final boolean groupedLogging = true;

    void log(int depth, String name, ValidationTuple tuple, PlanNode planNode, String id) {
        LogStatement logStatement = new LogStatement(depth, name, tuple, planNode, id);
        if (this.list == null) {
            this.list = new ArrayList<LogStatement>();
        }
        this.list.add(logStatement);
    }

    public void flush() {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        HashMap map = new HashMap();
        this.list.forEach(s -> {
            map.computeIfAbsent(s.getId(), ss -> new ArrayList());
            ((List)map.get(s.getId())).add(s);
        });
        HashSet<String> printed = new HashSet<String>();
        for (LogStatement logStatement : this.list) {
            if (printed.contains(logStatement.getId())) continue;
            printed.add(logStatement.getId());
            ((List)map.get(logStatement.getId())).stream().map(Object::toString).forEachOrdered(arg_0 -> ((Logger)logger).info(arg_0));
        }
    }
}

