/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedSplitter
implements PlanNodeProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    PlanNode parent;
    private List<ValidationTuple> tuplesBuffer;

    public BufferedSplitter(PlanNode planNode) {
        this.parent = planNode;
    }

    private synchronized void init() {
        if (this.tuplesBuffer == null) {
            this.tuplesBuffer = new ArrayList<ValidationTuple>();
            try (CloseableIteration<? extends ValidationTuple, SailException> iterator = this.parent.iterator();){
                while (iterator.hasNext()) {
                    ValidationTuple next = (ValidationTuple)iterator.next();
                    this.tuplesBuffer.add(next);
                }
            }
        }
    }

    @Override
    public PlanNode getPlanNode() {
        return new PlanNode(){
            private boolean printed = false;
            private ValidationExecutionLogger validationExecutionLogger;

            @Override
            public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
                BufferedSplitter.this.init();
                final Iterator iterator = BufferedSplitter.this.tuplesBuffer.iterator();
                return new CloseableIteration<ValidationTuple, SailException>(){

                    public void close() throws SailException {
                    }

                    public boolean hasNext() throws SailException {
                        return iterator.hasNext();
                    }

                    public ValidationTuple next() throws SailException {
                        ValidationTuple tuple = new ValidationTuple((ValidationTuple)iterator.next());
                        if (GlobalValidationExecutionLogging.loggingEnabled) {
                            validationExecutionLogger.log(this.depth(), BufferedSplitter.this.parent.getClass().getSimpleName() + ":BufferedSplitter.next()", tuple, BufferedSplitter.this.parent, this.getId());
                        }
                        return tuple;
                    }

                    public void remove() throws SailException {
                        throw new ShaclUnsupportedException();
                    }
                };
            }

            @Override
            public int depth() {
                return BufferedSplitter.this.parent.depth() + 1;
            }

            @Override
            public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
                if (this.printed) {
                    return;
                }
                this.printed = true;
                stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
                stringBuilder.append(BufferedSplitter.this.parent.getId() + " -> " + this.getId()).append("\n");
                BufferedSplitter.this.parent.getPlanAsGraphvizDot(stringBuilder);
            }

            @Override
            public String getId() {
                return System.identityHashCode(BufferedSplitter.this) + "";
            }

            public String toString() {
                return "BufferedSplitter";
            }

            @Override
            public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
                this.validationExecutionLogger = validationExecutionLogger;
                BufferedSplitter.this.parent.receiveLogger(validationExecutionLogger);
            }

            @Override
            public boolean producesSorted() {
                return BufferedSplitter.this.parent.producesSorted();
            }

            @Override
            public boolean requiresSorted() {
                return BufferedSplitter.this.parent.requiresSorted();
            }
        };
    }
}

