/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.results;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.Severity;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;

@Deprecated
public class ValidationResult {
    private final Resource id = SimpleValueFactory.getInstance().createBNode(UUID.randomUUID() + "");
    private final Optional<Value> value;
    private final Shape shape;
    private final SourceConstraintComponent sourceConstraintComponent;
    private final Severity severity;
    private final Value focusNode;
    private Path path;
    private ValidationResult detail;

    public ValidationResult(Value focusNode, Value value, Shape shape, SourceConstraintComponent sourceConstraintComponent, Severity severity, ConstraintComponent.Scope scope) {
        this.focusNode = focusNode;
        assert (this.focusNode != null);
        this.sourceConstraintComponent = sourceConstraintComponent;
        this.shape = shape;
        if (sourceConstraintComponent.producesValidationResultValue()) {
            assert (value != null);
            this.value = Optional.of(value);
        } else {
            if (scope == ConstraintComponent.Scope.propertyShape) assert (value == null);
            this.value = Optional.empty();
        }
        if (shape instanceof PropertyShape) {
            this.path = ((PropertyShape)shape).getPath();
        }
        this.severity = severity;
    }

    public ValidationResult getDetail() {
        return this.detail;
    }

    public void setDetail(ValidationResult detail) {
        this.detail = detail;
    }

    public List<ValidationResult> getDetails() {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        ValidationResult temp = this.detail;
        while (temp != null) {
            validationResults.add(temp);
            temp = temp.detail;
        }
        return validationResults;
    }

    public Model asModel(Model model) {
        model.add(this.getId(), RDF.TYPE, (Value)SHACL.VALIDATION_RESULT, new Resource[0]);
        model.add(this.getId(), SHACL.FOCUS_NODE, this.focusNode, new Resource[0]);
        this.value.ifPresent(v -> model.add(this.getId(), SHACL.VALUE, v, new Resource[0]));
        if (this.path != null) {
            this.path.toModel(this.path.getId(), null, model, new HashSet<Resource>());
            model.add(this.getId(), SHACL.RESULT_PATH, (Value)this.path.getId(), new Resource[0]);
        }
        model.add(this.getId(), SHACL.SOURCE_CONSTRAINT_COMPONENT, (Value)this.getSourceConstraintComponent().getIri(), new Resource[0]);
        model.add(this.getId(), SHACL.RESULT_SEVERITY, this.severity.getIri(), new Resource[0]);
        this.shape.toModel(this.getId(), SHACL.SOURCE_SHAPE, model, new HashSet<Resource>());
        return model;
    }

    private Path getPath() {
        return this.path;
    }

    private Value getFocusNode() {
        return this.focusNode;
    }

    public Resource getId() {
        return this.id;
    }

    public SourceConstraintComponent getSourceConstraintComponent() {
        return this.sourceConstraintComponent;
    }

    public String toString() {
        return "ValidationResult{sourceConstraintComponent=" + (Object)((Object)this.sourceConstraintComponent) + ", path=" + this.path + ", detail=" + this.detail + ", focusNode=" + this.focusNode + '}';
    }
}

