/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesBackedNode
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(ValuesBackedNode.class);
    private final Collection<Value> collection;
    private ValidationExecutionLogger validationExecutionLogger;
    boolean printed = false;

    public ValuesBackedNode(Collection<Value> collection) {
        this.collection = collection;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            Iterator<Value> iterator;
            {
                this.iterator = ValuesBackedNode.this.collection.iterator();
            }

            public void close() throws SailException {
            }

            @Override
            public boolean localHasNext() throws SailException {
                return this.iterator.hasNext();
            }

            @Override
            public Tuple loggingNext() throws SailException {
                return new Tuple(this.iterator.next());
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return IteratorData.tripleBased;
    }

    public String toString() {
        return "ValuesBackedNode{collection=" + this.collection + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValuesBackedNode that = (ValuesBackedNode)o;
        return this.collection.equals(that.collection);
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }
}

