/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.intervals.IntervalIterator;

final class IntervalMatches {
    IntervalMatches() {
    }

    static MatchesIterator asMatches(final IntervalIterator iterator, final MatchesIterator source, int doc) throws IOException {
        if (source == null) {
            return null;
        }
        if (iterator.advance(doc) != doc) {
            return null;
        }
        if (iterator.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return new MatchesIterator(){
            boolean cached = true;

            public boolean next() throws IOException {
                if (this.cached) {
                    this.cached = false;
                    return true;
                }
                return iterator.nextInterval() != Integer.MAX_VALUE;
            }

            public int startPosition() {
                return source.startPosition();
            }

            public int endPosition() {
                return source.endPosition();
            }

            public int startOffset() throws IOException {
                return source.startOffset();
            }

            public int endOffset() throws IOException {
                return source.endOffset();
            }

            public MatchesIterator getSubMatches() throws IOException {
                return source.getSubMatches();
            }

            public Query getQuery() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static IntervalIterator wrapMatches(final MatchesIterator mi, final int doc) {
        return new IntervalIterator(){
            State state = State.UNPOSITIONED;

            @Override
            public int start() {
                assert (this.state == State.ITERATING);
                return mi.startPosition();
            }

            @Override
            public int end() {
                assert (this.state == State.ITERATING);
                return mi.endPosition();
            }

            @Override
            public int nextInterval() throws IOException {
                assert (this.state == State.ITERATING);
                if (mi.next()) {
                    return mi.startPosition();
                }
                return Integer.MAX_VALUE;
            }

            @Override
            public float matchCost() {
                return 1.0f;
            }

            public int docID() {
                switch (this.state) {
                    case UNPOSITIONED: {
                        return -1;
                    }
                    case ITERATING: {
                        return doc;
                    }
                }
                return Integer.MAX_VALUE;
            }

            public int nextDoc() {
                switch (this.state) {
                    case UNPOSITIONED: {
                        this.state = State.ITERATING;
                        return doc;
                    }
                    case ITERATING: {
                        this.state = State.EXHAUSTED;
                    }
                }
                return Integer.MAX_VALUE;
            }

            public int advance(int target) {
                if (target == doc) {
                    this.state = State.ITERATING;
                    return doc;
                }
                this.state = State.EXHAUSTED;
                return Integer.MAX_VALUE;
            }

            public long cost() {
                return 1L;
            }
        };
    }

    static enum State {
        UNPOSITIONED,
        ITERATING,
        EXHAUSTED;

    }
}

