/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.ExternalFilterByQuery;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleMapper;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValueInFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasValueInPropertyShape
extends PathPropertyShape {
    private final Set<Value> hasValueIn;
    private static final Logger logger = LoggerFactory.getLogger(HasValueInPropertyShape.class);

    HasValueInPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Resource hasValueIn) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.hasValueIn = HasValueInPropertyShape.toSet(connection, hasValueIn);
        assert (!this.hasValueIn.isEmpty());
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        PlaneNodeWrapper planeNodeWrapper;
        if (this.deactivated) {
            return null;
        }
        assert (!negateSubPlans) : "There are no subplans!";
        if (!this.hasOwnPath()) {
            if (this.getPath() == null) {
                PlanNode addedTargets = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
                if (overrideTargetNode != null) {
                    addedTargets = overrideTargetNode.getPlanNode();
                }
                PlanNode invalidTargets = new TupleMapper(addedTargets, t -> {
                    List<Value> line = t.getLine();
                    t.getLine().add(line.get(0));
                    return t;
                });
                invalidTargets = negateThisPlan ? new ValueInFilter(invalidTargets, this.hasValueIn).getTrueNode(UnBufferedPlanNode.class) : new ValueInFilter(invalidTargets, this.hasValueIn).getFalseNode(UnBufferedPlanNode.class);
                if (printPlans) {
                    String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidTargets, connectionsGroup);
                    logger.info(planAsGraphvizDot);
                }
                return new EnrichWithShape(invalidTargets, this);
            }
            PlanNode addedTargets = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
            PlanNode addedByPath = this.getPath().getPlanAddedStatements(connectionsGroup, null);
            addedTargets = new UnionNode(new TrimTuple(addedByPath, 0, 1), addedTargets);
            addedTargets = new Unique(addedTargets);
            addedTargets = this.nodeShape.getTargetFilter(connectionsGroup, addedTargets);
            if (overrideTargetNode != null) {
                addedTargets = overrideTargetNode.getPlanNode();
            }
            BulkedExternalInnerJoin joined = new BulkedExternalInnerJoin(addedTargets, connectionsGroup.getBaseConnection(), this.getPath().getQuery("?a", "?c", null), false, null, "?a", "?c");
            PlanNode invalidTargets = negateThisPlan ? new ValueInFilter(joined, this.hasValueIn).getTrueNode(UnBufferedPlanNode.class) : new ValueInFilter(joined, this.hasValueIn).getFalseNode(UnBufferedPlanNode.class);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidTargets, connectionsGroup);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(invalidTargets, this);
        }
        if (overrideTargetNode != null) {
            PlanNode planNode2 = overrideTargetNode.getPlanNode();
            ExternalFilterByQuery externalFilterByQuery = new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), planNode2, 0, this.buildSparqlValidNodes("?this"), "?this");
            planNode2 = negateThisPlan ? externalFilterByQuery.getTrueNode(UnBufferedPlanNode.class) : externalFilterByQuery.getFalseNode(UnBufferedPlanNode.class);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(planNode2, connectionsGroup);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(planNode2, this);
        }
        PlanNode planAddedStatements = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
        ExternalFilterByQuery externalFilterByQuery = new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), planAddedStatements, 0, this.buildSparqlValidNodes("?this"), "?this");
        PlanNode invalidValues = negateThisPlan ? externalFilterByQuery.getTrueNode(UnBufferedPlanNode.class) : externalFilterByQuery.getFalseNode(UnBufferedPlanNode.class);
        if (negateThisPlan && connectionsGroup.getStats().hasAdded()) {
            planeNodeWrapper = planNode -> {
                PlanNode targetFilter = this.nodeShape.getTargetFilter(connectionsGroup, planNode);
                return new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), targetFilter, 0, this.buildSparqlValidNodes("?this"), "?this").getTrueNode(UnBufferedPlanNode.class);
            };
            invalidValues = new UnionNode(invalidValues, this.getPlanAddedStatements(connectionsGroup, planeNodeWrapper));
        }
        if (!negateThisPlan && connectionsGroup.getStats().hasRemoved()) {
            planeNodeWrapper = planNode -> {
                PlanNode targetFilter = this.nodeShape.getTargetFilter(connectionsGroup, planNode);
                return new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), targetFilter, 0, this.buildSparqlValidNodes("?this"), "?this").getFalseNode(UnBufferedPlanNode.class);
            };
            invalidValues = new UnionNode(invalidValues, this.getPlanRemovedStatements(connectionsGroup, planeNodeWrapper));
        }
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, connectionsGroup);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidValues, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.HasValueInConstraintComponent;
    }

    @Override
    public String buildSparqlValidNodes(String targetVar) {
        if (this.hasOwnPath()) {
            return this.hasValueIn.stream().map(value -> {
                String objectVar = "?hasValueIn_" + UUID.randomUUID().toString().replace("-", "");
                if (value instanceof IRI) {
                    return "BIND(<" + value + "> as " + objectVar + ")\n" + this.getPath().getQuery(targetVar, objectVar, null);
                }
                if (value instanceof Literal) {
                    return "BIND(" + value.toString() + " as " + objectVar + ")\n" + this.getPath().getQuery(targetVar, objectVar, null);
                }
                throw new UnsupportedOperationException("value was unsupported type: " + value.getClass().getSimpleName());
            }).collect(Collectors.joining("} UNION {\n#VALUES_INJECTION_POINT#\n", "{\n#VALUES_INJECTION_POINT#\n", "}"));
        }
        return this.hasValueIn.stream().map(value -> {
            if (value instanceof IRI) {
                return targetVar + " = <" + value + ">";
            }
            if (value instanceof Literal) {
                return targetVar + " = " + value;
            }
            throw new UnsupportedOperationException("value was unsupported type: " + value.getClass().getSimpleName());
        }).reduce((a, b) -> a + " || " + b).orElseThrow(() -> new IllegalStateException("hasValueIn was empty"));
    }

    @Override
    public Stream<StatementPattern> getStatementPatterns() {
        return this.hasValueIn.stream().flatMap(value -> this.getPath().getStatementsPatterns(new Var("?this"), new Var(UUID.randomUUID().toString(), (Value)value)));
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, boolean negated) {
        PlanNode plan = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
        plan = new UnionNode(plan, this.nodeShape.getPlanRemovedStatements(connectionsGroup, null));
        Path path = this.getPath();
        if (path != null) {
            plan = new UnionNode(plan, this.getPlanAddedStatements(connectionsGroup, null));
            plan = new UnionNode(plan, this.getPlanRemovedStatements(connectionsGroup, null));
        }
        plan = new Unique(new TrimTuple(plan, 0, 1));
        return this.nodeShape.getTargetFilter(connectionsGroup, plan);
    }
}

