/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.impl;

import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

public class PackedCoordinateSequenceFactory
implements CoordinateSequenceFactory,
Serializable {
    private static final long serialVersionUID = -3558264771905224525L;
    public static final int DOUBLE = 0;
    public static final int FLOAT = 1;
    public static final PackedCoordinateSequenceFactory DOUBLE_FACTORY = new PackedCoordinateSequenceFactory(0);
    public static final PackedCoordinateSequenceFactory FLOAT_FACTORY = new PackedCoordinateSequenceFactory(1);
    private int type = 0;
    private int dimension = 3;

    public PackedCoordinateSequenceFactory() {
        this(0);
    }

    public PackedCoordinateSequenceFactory(int type) {
        this(type, 3);
    }

    public PackedCoordinateSequenceFactory(int type, int dimension) {
        this.setType(type);
        this.setDimension(dimension);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        this.type = type;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    @Override
    public CoordinateSequence create(Coordinate[] coordinates) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(coordinates, this.dimension);
        }
        return new PackedCoordinateSequence.Float(coordinates, this.dimension);
    }

    @Override
    public CoordinateSequence create(CoordinateSequence coordSeq) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(coordSeq.toCoordinateArray(), this.dimension);
        }
        return new PackedCoordinateSequence.Float(coordSeq.toCoordinateArray(), this.dimension);
    }

    public CoordinateSequence create(double[] packedCoordinates, int dimension) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(packedCoordinates, dimension);
        }
        return new PackedCoordinateSequence.Float(packedCoordinates, dimension);
    }

    public CoordinateSequence create(float[] packedCoordinates, int dimension) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(packedCoordinates, dimension);
        }
        return new PackedCoordinateSequence.Float(packedCoordinates, dimension);
    }

    @Override
    public CoordinateSequence create(int size, int dimension) {
        if (this.type == 0) {
            return new PackedCoordinateSequence.Double(size, dimension);
        }
        return new PackedCoordinateSequence.Float(size, dimension);
    }
}

