/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.impl.StreamingBinaryResponseParser;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.SolrPing;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public abstract class SolrClient
implements Serializable,
Closeable {
    private static final long serialVersionUID = 1L;
    private DocumentObjectBinder binder;

    public UpdateResponse add(String collection, Collection<SolrInputDocument> docs) throws SolrServerException, IOException {
        return this.add(collection, docs, -1);
    }

    public UpdateResponse add(Collection<SolrInputDocument> docs) throws SolrServerException, IOException {
        return this.add(null, docs);
    }

    public UpdateResponse add(String collection, Collection<SolrInputDocument> docs, int commitWithinMs) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.add(docs);
        req.setCommitWithin(commitWithinMs);
        return (UpdateResponse)req.process(this, collection);
    }

    public UpdateResponse add(Collection<SolrInputDocument> docs, int commitWithinMs) throws SolrServerException, IOException {
        return this.add(null, docs, commitWithinMs);
    }

    public UpdateResponse add(String collection, SolrInputDocument doc) throws SolrServerException, IOException {
        return this.add(collection, doc, -1);
    }

    public UpdateResponse add(SolrInputDocument doc) throws SolrServerException, IOException {
        return this.add(null, doc);
    }

    public UpdateResponse add(String collection, SolrInputDocument doc, int commitWithinMs) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.add(doc);
        req.setCommitWithin(commitWithinMs);
        return (UpdateResponse)req.process(this, collection);
    }

    public UpdateResponse add(SolrInputDocument doc, int commitWithinMs) throws SolrServerException, IOException {
        return this.add(null, doc, commitWithinMs);
    }

    public UpdateResponse add(String collection, Iterator<SolrInputDocument> docIterator) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.setDocIterator(docIterator);
        return (UpdateResponse)req.process(this, collection);
    }

    public UpdateResponse add(Iterator<SolrInputDocument> docIterator) throws SolrServerException, IOException {
        return this.add(null, docIterator);
    }

    public UpdateResponse addBean(String collection, Object obj) throws IOException, SolrServerException {
        return this.addBean(collection, obj, -1);
    }

    public UpdateResponse addBean(Object obj) throws IOException, SolrServerException {
        return this.addBean(null, obj, -1);
    }

    public UpdateResponse addBean(String collection, Object obj, int commitWithinMs) throws IOException, SolrServerException {
        return this.add(collection, this.getBinder().toSolrInputDocument(obj), commitWithinMs);
    }

    public UpdateResponse addBean(Object obj, int commitWithinMs) throws IOException, SolrServerException {
        return this.add(null, this.getBinder().toSolrInputDocument(obj), commitWithinMs);
    }

    public UpdateResponse addBeans(String collection, Collection<?> beans) throws SolrServerException, IOException {
        return this.addBeans(collection, beans, -1);
    }

    public UpdateResponse addBeans(Collection<?> beans) throws SolrServerException, IOException {
        return this.addBeans(null, beans, -1);
    }

    public UpdateResponse addBeans(String collection, Collection<?> beans, int commitWithinMs) throws SolrServerException, IOException {
        DocumentObjectBinder binder = this.getBinder();
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>(beans.size());
        for (Object bean : beans) {
            docs.add(binder.toSolrInputDocument(bean));
        }
        return this.add(collection, docs, commitWithinMs);
    }

    public UpdateResponse addBeans(Collection<?> beans, int commitWithinMs) throws SolrServerException, IOException {
        return this.addBeans(null, beans, commitWithinMs);
    }

    public UpdateResponse addBeans(String collection, final Iterator<?> beanIterator) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.setDocIterator(new Iterator<SolrInputDocument>(){

            @Override
            public boolean hasNext() {
                return beanIterator.hasNext();
            }

            @Override
            public SolrInputDocument next() {
                Object o = beanIterator.next();
                if (o == null) {
                    return null;
                }
                return SolrClient.this.getBinder().toSolrInputDocument(o);
            }

            @Override
            public void remove() {
                beanIterator.remove();
            }
        });
        return (UpdateResponse)req.process(this, collection);
    }

    public UpdateResponse addBeans(Iterator<?> beanIterator) throws SolrServerException, IOException {
        return this.addBeans(null, beanIterator);
    }

    public UpdateResponse commit(String collection) throws SolrServerException, IOException {
        return this.commit(collection, true, true);
    }

    public UpdateResponse commit() throws SolrServerException, IOException {
        return this.commit(null, true, true);
    }

    public UpdateResponse commit(String collection, boolean waitFlush, boolean waitSearcher) throws SolrServerException, IOException {
        return (UpdateResponse)new UpdateRequest().setAction(AbstractUpdateRequest.ACTION.COMMIT, waitFlush, waitSearcher).process(this, collection);
    }

    public UpdateResponse commit(boolean waitFlush, boolean waitSearcher) throws SolrServerException, IOException {
        return this.commit(null, waitFlush, waitSearcher);
    }

    public UpdateResponse commit(String collection, boolean waitFlush, boolean waitSearcher, boolean softCommit) throws SolrServerException, IOException {
        return (UpdateResponse)new UpdateRequest().setAction(AbstractUpdateRequest.ACTION.COMMIT, waitFlush, waitSearcher, softCommit).process(this, collection);
    }

    public UpdateResponse commit(boolean waitFlush, boolean waitSearcher, boolean softCommit) throws SolrServerException, IOException {
        return this.commit(null, waitFlush, waitSearcher, softCommit);
    }

    public UpdateResponse optimize(String collection) throws SolrServerException, IOException {
        return this.optimize(collection, true, true, 1);
    }

    public UpdateResponse optimize() throws SolrServerException, IOException {
        return this.optimize(null, true, true, 1);
    }

    public UpdateResponse optimize(String collection, boolean waitFlush, boolean waitSearcher) throws SolrServerException, IOException {
        return this.optimize(collection, waitFlush, waitSearcher, 1);
    }

    public UpdateResponse optimize(boolean waitFlush, boolean waitSearcher) throws SolrServerException, IOException {
        return this.optimize(null, waitFlush, waitSearcher);
    }

    public UpdateResponse optimize(String collection, boolean waitFlush, boolean waitSearcher, int maxSegments) throws SolrServerException, IOException {
        return (UpdateResponse)new UpdateRequest().setAction(AbstractUpdateRequest.ACTION.OPTIMIZE, waitFlush, waitSearcher, maxSegments).process(this, collection);
    }

    public UpdateResponse optimize(boolean waitFlush, boolean waitSearcher, int maxSegments) throws SolrServerException, IOException {
        return this.optimize(null, waitFlush, waitSearcher, maxSegments);
    }

    public UpdateResponse rollback(String collection) throws SolrServerException, IOException {
        return (UpdateResponse)new UpdateRequest().rollback().process(this, collection);
    }

    public UpdateResponse rollback() throws SolrServerException, IOException {
        return this.rollback(null);
    }

    public UpdateResponse deleteById(String collection, String id) throws SolrServerException, IOException {
        return this.deleteById(collection, id, -1);
    }

    public UpdateResponse deleteById(String id) throws SolrServerException, IOException {
        return this.deleteById(null, id);
    }

    public UpdateResponse deleteById(String collection, String id, int commitWithinMs) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.deleteById(id);
        req.setCommitWithin(commitWithinMs);
        return (UpdateResponse)req.process(this, collection);
    }

    public UpdateResponse deleteById(String id, int commitWithinMs) throws SolrServerException, IOException {
        return this.deleteById(null, id, commitWithinMs);
    }

    public UpdateResponse deleteById(String collection, List<String> ids) throws SolrServerException, IOException {
        return this.deleteById(collection, ids, -1);
    }

    public UpdateResponse deleteById(List<String> ids) throws SolrServerException, IOException {
        return this.deleteById(null, ids);
    }

    public UpdateResponse deleteById(String collection, List<String> ids, int commitWithinMs) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.deleteById(ids);
        req.setCommitWithin(commitWithinMs);
        return (UpdateResponse)req.process(this, collection);
    }

    public UpdateResponse deleteById(List<String> ids, int commitWithinMs) throws SolrServerException, IOException {
        return this.deleteById(null, ids, commitWithinMs);
    }

    public UpdateResponse deleteByQuery(String collection, String query) throws SolrServerException, IOException {
        return this.deleteByQuery(collection, query, -1);
    }

    public UpdateResponse deleteByQuery(String query) throws SolrServerException, IOException {
        return this.deleteByQuery(null, query);
    }

    public UpdateResponse deleteByQuery(String collection, String query, int commitWithinMs) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.deleteByQuery(query);
        req.setCommitWithin(commitWithinMs);
        return (UpdateResponse)req.process(this, collection);
    }

    public UpdateResponse deleteByQuery(String query, int commitWithinMs) throws SolrServerException, IOException {
        return this.deleteByQuery(null, query, commitWithinMs);
    }

    public SolrPingResponse ping() throws SolrServerException, IOException {
        return (SolrPingResponse)new SolrPing().process(this, null);
    }

    public QueryResponse query(String collection, SolrParams params) throws SolrServerException, IOException {
        return (QueryResponse)new QueryRequest(params).process(this, collection);
    }

    public QueryResponse query(SolrParams params) throws SolrServerException, IOException {
        return this.query(null, params);
    }

    public QueryResponse query(String collection, SolrParams params, SolrRequest.METHOD method) throws SolrServerException, IOException {
        return (QueryResponse)new QueryRequest(params, method).process(this, collection);
    }

    public QueryResponse query(SolrParams params, SolrRequest.METHOD method) throws SolrServerException, IOException {
        return this.query(null, params, method);
    }

    public QueryResponse queryAndStreamResponse(String collection, SolrParams params, StreamingResponseCallback callback) throws SolrServerException, IOException {
        StreamingBinaryResponseParser parser = new StreamingBinaryResponseParser(callback);
        QueryRequest req = new QueryRequest(params);
        req.setStreamingResponseCallback(callback);
        req.setResponseParser(parser);
        return (QueryResponse)req.process(this, collection);
    }

    public QueryResponse queryAndStreamResponse(SolrParams params, StreamingResponseCallback callback) throws SolrServerException, IOException {
        return this.queryAndStreamResponse(null, params, callback);
    }

    public SolrDocument getById(String collection, String id) throws SolrServerException, IOException {
        return this.getById(collection, id, null);
    }

    public SolrDocument getById(String id) throws SolrServerException, IOException {
        return this.getById(null, id, null);
    }

    public SolrDocument getById(String collection, String id, SolrParams params) throws SolrServerException, IOException {
        SolrDocumentList docs = this.getById(collection, Collections.singletonList(id), params);
        if (!docs.isEmpty()) {
            return (SolrDocument)docs.get(0);
        }
        return null;
    }

    public SolrDocument getById(String id, SolrParams params) throws SolrServerException, IOException {
        return this.getById(null, id, params);
    }

    public SolrDocumentList getById(String collection, Collection<String> ids) throws SolrServerException, IOException {
        return this.getById(collection, ids, null);
    }

    public SolrDocumentList getById(Collection<String> ids) throws SolrServerException, IOException {
        return this.getById(null, ids);
    }

    public SolrDocumentList getById(String collection, Collection<String> ids, SolrParams params) throws SolrServerException, IOException {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("Must provide an identifier of a document to retrieve.");
        }
        ModifiableSolrParams reqParams = new ModifiableSolrParams(params);
        if (StringUtils.isEmpty(reqParams.get("qt"))) {
            reqParams.set("qt", "/get");
        }
        reqParams.set("ids", ids.toArray(new String[ids.size()]));
        return this.query(collection, reqParams).getResults();
    }

    public SolrDocumentList getById(Collection<String> ids, SolrParams params) throws SolrServerException, IOException {
        return this.getById(null, ids, params);
    }

    public abstract NamedList<Object> request(SolrRequest var1, String var2) throws SolrServerException, IOException;

    public final NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        return this.request(request, null);
    }

    public DocumentObjectBinder getBinder() {
        if (this.binder == null) {
            this.binder = new DocumentObjectBinder();
        }
        return this.binder;
    }
}

