/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.IOException;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.Close;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;

public class Disconnect
extends ConsoleCommand {
    private final Close close;

    @Override
    public String getName() {
        return "disconnect";
    }

    @Override
    public String getHelpShort() {
        return "Disconnects from the current set of repositories";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\ndisconnect   Disconnects from the current set of repositories or server\n";
    }

    public Disconnect(ConsoleIO consoleIO, ConsoleState state, Close close) {
        super(consoleIO, state);
        this.close = close;
    }

    public void execute(boolean verbose) {
        RepositoryManager manager = this.state.getManager();
        if (manager == null) {
            if (verbose) {
                this.consoleIO.writeln("Already disconnected");
            }
        } else {
            this.close.closeRepository(false);
            this.consoleIO.writeln("Disconnecting from " + this.state.getManagerID());
            manager.shutDown();
            this.state.setManager(null);
            this.state.setManagerID(null);
        }
    }

    @Override
    public void execute(String ... parameters) throws IOException {
        this.execute(true);
    }
}

