/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.app.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.io.ResourceUtil;

public class ConfigurationUtil {
    public static String loadConfigurationContents(File file) throws IOException {
        String result = null;
        if (file.exists()) {
            result = IOUtil.readString(file);
        }
        return result;
    }

    public static String loadConfigurationContents(String resourceName) throws IOException {
        String result = null;
        InputStream in = ResourceUtil.getInputStream(ConfigurationUtil.getResourceName(resourceName));
        if (in == null) {
            in = ResourceUtil.getInputStream(ConfigurationUtil.getDefaultResourceName(resourceName));
        }
        if (in != null) {
            result = IOUtil.readString(in);
        }
        return result;
    }

    public static Properties loadConfigurationProperties(File file, Properties defaults) throws IOException {
        Properties result = null;
        result = file.exists() ? IOUtil.readProperties(file, defaults) : new Properties(defaults);
        return result;
    }

    public static Properties loadConfigurationProperties(String resourceName, Properties defaults) throws IOException {
        Properties result = null;
        String defaultResourceName = ConfigurationUtil.getDefaultResourceName(resourceName);
        Properties defaultResult = null;
        InputStream in = ResourceUtil.getInputStream(defaultResourceName);
        defaultResult = in != null ? IOUtil.readProperties(in, defaults) : new Properties(defaults);
        in = ResourceUtil.getInputStream(ConfigurationUtil.getResourceName(resourceName));
        result = in != null ? IOUtil.readProperties(in, defaultResult) : new Properties(defaultResult);
        return result;
    }

    private static String getResourceName(String resourceName) {
        StringBuilder result = new StringBuilder("/org/eclipse/rdf4j/common/app/config/");
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        result.append(resourceName);
        return result.toString();
    }

    private static String getDefaultResourceName(String resourceName) {
        StringBuilder result = new StringBuilder("/org/eclipse/rdf4j/common/app/config/defaults/");
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        result.append(resourceName);
        return result.toString();
    }

    public static void saveConfigurationContents(String contents, File file) throws IOException {
        if (file.getParentFile().mkdirs() || file.getParentFile().canWrite()) {
            IOUtil.writeString(contents, file);
        }
    }

    public static void saveConfigurationProperties(Properties props, File file, boolean includeDefaults) throws IOException {
        if (file.getParentFile().mkdirs() || file.getParentFile().canWrite()) {
            IOUtil.writeProperties(props, file, includeDefaults);
        }
    }
}

