/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.CalleeMethodWrapper;
import org.eclipse.jdt.internal.corext.callhierarchy.CallerMethodWrapper;
import org.eclipse.jdt.internal.corext.callhierarchy.Implementors;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.ui.util.StringMatcher;

public class CallHierarchyCore {
    public static final String PREF_SHOW_ALL_CODE = "PREF_SHOW_ALL_CODE";
    public static final String PREF_HIDE_TEST_CODE = "PREF_HIDE_TEST_CODE";
    public static final String PREF_SHOW_TEST_CODE_ONLY = "PREF_SHOW_TEST_CODE_ONLY";
    public static final String PREF_USE_IMPLEMENTORS = "PREF_USE_IMPLEMENTORS";
    public static final String PREF_USE_FILTERS = "PREF_USE_FILTERS";
    public static final String PREF_FILTERS_LIST = "PREF_FILTERS_LIST";
    private String defaultIgnoreFilters = "java.*,javax.*";
    private static CallHierarchyCore fgInstance;
    private IJavaSearchScope fSearchScope;
    private StringMatcher[] fFilters;

    public static CallHierarchyCore getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchyCore();
        }
        return fgInstance;
    }

    public boolean isSearchUsingImplementorsEnabled() {
        return Boolean.parseBoolean(JavaManipulation.getPreference(PREF_USE_IMPLEMENTORS, null));
    }

    public boolean isShowTestCode() {
        return Boolean.parseBoolean(JavaManipulation.getPreference(PREF_SHOW_TEST_CODE_ONLY, null));
    }

    public boolean isShowAll() {
        return Boolean.parseBoolean(JavaManipulation.getPreference(PREF_SHOW_ALL_CODE, null));
    }

    public boolean isHideTestCode() {
        return Boolean.parseBoolean(JavaManipulation.getPreference(PREF_HIDE_TEST_CODE, null));
    }

    public Collection<IJavaElement> getImplementingMethods(IMethod method) {
        IJavaElement[] result;
        if (this.isSearchUsingImplementorsEnabled() && (result = Implementors.getInstance().searchForImplementors(new IJavaElement[]{method}, (IProgressMonitor)new NullProgressMonitor())) != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return new ArrayList<IJavaElement>(0);
    }

    public Collection<IJavaElement> getInterfaceMethods(IMethod method) {
        IJavaElement[] result;
        if (this.isSearchUsingImplementorsEnabled() && (result = Implementors.getInstance().searchForInterfaces(new IJavaElement[]{method}, (IProgressMonitor)new NullProgressMonitor())) != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return new ArrayList<IJavaElement>(0);
    }

    public MethodWrapper[] getCallerRoots(IMember[] members) {
        return this.getRoots(members, true);
    }

    public MethodWrapper[] getCalleeRoots(IMember[] members) {
        return this.getRoots(members, false);
    }

    private MethodWrapper[] getRoots(IMember[] members, boolean callers) {
        ArrayList<MethodWrapper> roots = new ArrayList<MethodWrapper>();
        IMember[] iMemberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (member instanceof IType) {
                IType type = (IType)member;
                try {
                    if (!type.isAnonymous()) {
                        IMethod[] constructors = JavaElementUtil.getAllConstructors(type);
                        if (constructors.length == 0) {
                            this.addRoot(member, roots, callers);
                        } else {
                            if (type.isRecord()) {
                                this.addRoot(member, roots, callers);
                            }
                            IMethod[] iMethodArray = constructors;
                            int n3 = constructors.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IMethod constructor = iMethodArray[n4];
                                this.addRoot((IMember)constructor, roots, callers);
                                ++n4;
                            }
                        }
                    } else {
                        this.addRoot(member, roots, callers);
                    }
                }
                catch (JavaModelException e) {
                    JavaManipulationPlugin.log(e);
                }
            } else {
                this.addRoot(member, roots, callers);
            }
            ++n2;
        }
        return roots.toArray(new MethodWrapper[roots.size()]);
    }

    private void addRoot(IMember member, ArrayList<MethodWrapper> roots, boolean callers) {
        MethodCall methodCall = new MethodCall(member);
        MethodWrapper root = callers ? new CallerMethodWrapper(null, methodCall) : new CalleeMethodWrapper(null, methodCall);
        roots.add(root);
    }

    public static CallLocation getCallLocation(Object element) {
        CallLocation callLocation = null;
        if (element instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)element);
            MethodCall methodCall = methodWrapper.getMethodCall();
            if (methodCall != null) {
                callLocation = methodCall.getFirstCallLocation();
            }
        } else if (element instanceof CallLocation) {
            callLocation = (CallLocation)element;
        }
        return callLocation;
    }

    public IJavaSearchScope getSearchScope() {
        if (this.fSearchScope == null) {
            this.fSearchScope = SearchEngine.createWorkspaceScope();
        }
        return this.fSearchScope;
    }

    public void setSearchScope(IJavaSearchScope searchScope) {
        this.fSearchScope = searchScope;
    }

    public boolean isIgnored(String fullyQualifiedName) {
        if (this.getIgnoreFilters() != null && this.getIgnoreFilters().length > 0) {
            StringMatcher[] stringMatcherArray = this.getIgnoreFilters();
            int n = stringMatcherArray.length;
            int n2 = 0;
            while (n2 < n) {
                StringMatcher ignoreFilter = stringMatcherArray[n2];
                String fullyQualifiedName1 = fullyQualifiedName;
                if (ignoreFilter.match(fullyQualifiedName1)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isFilterEnabled() {
        return Boolean.parseBoolean(JavaManipulation.getPreference(PREF_USE_FILTERS, null));
    }

    public String getFilters() {
        String pref = JavaManipulation.getPreference(PREF_FILTERS_LIST, null);
        if (pref == null) {
            return "";
        }
        return pref;
    }

    public void setDefaultIgnoreFilters(String defaultIgnoreFilters) {
        this.defaultIgnoreFilters = defaultIgnoreFilters;
    }

    public void resetFilters() {
        this.fFilters = null;
    }

    public StringMatcher[] getIgnoreFilters() {
        if (this.fFilters == null) {
            String filterString = null;
            if (this.isFilterEnabled() && (filterString = this.getFilters()).isEmpty()) {
                filterString = this.defaultIgnoreFilters;
            }
            this.fFilters = filterString != null ? CallHierarchyCore.parseList(filterString) : null;
        }
        return this.fFilters;
    }

    public static boolean arePossibleInputElements(List<?> elements) {
        if (elements.size() < 1) {
            return false;
        }
        for (Object name : elements) {
            if (CallHierarchyCore.isPossibleInputElement(name)) continue;
            return false;
        }
        return true;
    }

    private static StringMatcher[] parseList(String listString) {
        ArrayList<StringMatcher> list = new ArrayList<StringMatcher>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String textFilter = tokenizer.nextToken().trim();
            list.add(new StringMatcher(textFilter, false, false));
        }
        return list.toArray(new StringMatcher[list.size()]);
    }

    static CompilationUnit getCompilationUnitNode(IMember member, boolean resolveBindings) {
        ITypeRoot typeRoot = member.getTypeRoot();
        try {
            if (typeRoot.exists() && typeRoot.getBuffer() != null) {
                ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
                parser.setSource(typeRoot);
                parser.setResolveBindings(resolveBindings);
                return (CompilationUnit)parser.createAST(null);
            }
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.log(e);
        }
        return null;
    }

    public static boolean isPossibleInputElement(Object element) {
        if (!(element instanceof IMember)) {
            return false;
        }
        if (element instanceof IModuleDescription) {
            return false;
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            try {
                return type.isClass() || type.isEnum() || type.isRecord();
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return true;
    }
}

