/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.core.text;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSFactoryProperties;
import org.eclipse.pde.internal.ds.core.IDSFactoryProperty;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.pde.internal.ds.core.text.DSObject;

public class DSComponent
extends DSObject
implements IDSComponent {
    private static final long serialVersionUID = 1L;

    public DSComponent(DSModel model) {
        super(model, "component");
        this.setAttributeName("component");
        this.setNamespace("http://www.osgi.org/xmlns/scr/v1.1.0");
        this.setNamespacePrefix("scr");
        this.setInTheModel(true);
    }

    public boolean isRoot() {
        return true;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean canBeParent() {
        return true;
    }

    @Override
    public String getName() {
        return this.getAttributeName();
    }

    @Override
    public boolean canAddChild(int objectType) {
        return objectType == 1 || objectType == 2 || objectType == 3 || objectType == 4 || objectType == 6;
    }

    @Override
    public void setAttributeName(String name) {
        this.setXMLAttribute("name", name);
    }

    @Override
    public String getAttributeName() {
        return this.getXMLAttributeValue("name");
    }

    @Override
    public void setEnabled(boolean bool) {
        this.setBooleanAttributeValue("enabled", bool);
    }

    @Override
    public boolean getEnabled() {
        return this.getBooleanAttributeValue("enabled", true);
    }

    @Override
    public void setFactory(String factory) {
        this.setXMLAttribute("factory", factory);
    }

    @Override
    public String getFactory() {
        return this.getXMLAttributeValue("factory");
    }

    @Override
    public void setImmediate(boolean bool) {
        this.setBooleanAttributeValue("immediate", bool);
    }

    @Override
    public boolean getImmediate() {
        return this.getBooleanAttributeValue("immediate", false);
    }

    @Override
    public IDSImplementation getImplementation() {
        ArrayList childNodesList = this.getChildNodesList(IDSImplementation.class, true);
        if (childNodesList.isEmpty()) {
            return null;
        }
        return (IDSImplementation)childNodesList.get(0);
    }

    @Override
    public IDSProperties[] getPropertiesElements() {
        ArrayList childNodesList = this.getChildNodesList(IDSProperties.class, true);
        IDSProperties[] array = new IDSProperties[childNodesList.size()];
        int i = 0;
        while (i < childNodesList.size()) {
            array[i] = (IDSProperties)childNodesList.get(i);
            ++i;
        }
        return array;
    }

    @Override
    public IDSFactoryProperties[] getFactoryPropertiesElements() {
        ArrayList childNodesList = this.getChildNodesList(IDSFactoryProperties.class, true);
        IDSFactoryProperties[] array = new IDSFactoryProperties[childNodesList.size()];
        int i = 0;
        while (i < childNodesList.size()) {
            array[i] = (IDSFactoryProperties)childNodesList.get(i);
            ++i;
        }
        return array;
    }

    @Override
    public IDSProperty[] getPropertyElements() {
        ArrayList childNodesList = this.getChildNodesList(IDSProperty.class, true);
        IDSProperty[] array = new IDSProperty[childNodesList.size()];
        int i = 0;
        while (i < childNodesList.size()) {
            array[i] = (IDSProperty)childNodesList.get(i);
            ++i;
        }
        return array;
    }

    @Override
    public IDSFactoryProperty[] getFactoryPropertyElements() {
        ArrayList childNodesList = this.getChildNodesList(IDSFactoryProperty.class, true);
        IDSFactoryProperty[] array = new IDSFactoryProperty[childNodesList.size()];
        int i = 0;
        while (i < childNodesList.size()) {
            array[i] = (IDSFactoryProperty)childNodesList.get(i);
            ++i;
        }
        return array;
    }

    @Override
    public IDSReference[] getReferences() {
        ArrayList childNodesList = this.getChildNodesList(IDSReference.class, true);
        IDSReference[] array = new IDSReference[childNodesList.size()];
        int i = 0;
        while (i < childNodesList.size()) {
            array[i] = (IDSReference)childNodesList.get(i);
            ++i;
        }
        return array;
    }

    @Override
    public IDSService getService() {
        ArrayList childNodesList = this.getChildNodesList(IDSService.class, true);
        if (childNodesList.isEmpty()) {
            return null;
        }
        return (IDSService)childNodesList.get(0);
    }

    @Override
    public void addPropertiesElement(IDSProperties properties) {
        this.addChildNode((IDocumentElementNode)properties, true);
    }

    @Override
    public void addPropertyElement(IDSProperty property) {
        this.addChildNode((IDocumentElementNode)property, true);
    }

    @Override
    public void addReference(IDSReference reference) {
        this.addChildNode((IDocumentElementNode)reference, true);
    }

    @Override
    public void removePropertiesElement(IDSProperties properties) {
        this.removeChildNode((IDocumentElementNode)properties, true);
    }

    @Override
    public void removePropertyElement(IDSProperty property) {
        this.removeChildNode((IDocumentElementNode)property, true);
    }

    @Override
    public void removeReference(IDSReference reference) {
        this.removeChildNode((IDocumentElementNode)reference, true);
    }

    @Override
    public void setImplementation(IDSImplementation implementation) {
        if (this.getImplementation() == null) {
            this.addChildNode((IDocumentElementNode)implementation, true);
        }
    }

    @Override
    public void setService(IDSService service) {
        if (this.getService() == null) {
            this.addChildNode((IDocumentElementNode)service, true);
        }
    }

    @Override
    public void removeService(IDSService service) {
        this.removeChildNode((IDocumentElementNode)service, true);
    }

    @Override
    public String[] getAttributesNames() {
        return new String[]{"enabled", "factory", "immediate", "name", "configuration-policy", "activate", "deactivate", "modified"};
    }

    @Override
    public String getConfigurationPolicy() {
        return this.getXMLAttributeValue("configuration-policy");
    }

    @Override
    public void setConfigurationPolicy(String policy) {
        this.setXMLAttribute("configuration-policy", policy);
    }

    @Override
    public String getActivateMethod() {
        return this.getXMLAttributeValue("activate");
    }

    @Override
    public String getDeactivateMethod() {
        return this.getXMLAttributeValue("deactivate");
    }

    @Override
    public void setActivateMethod(String name) {
        this.setXMLAttribute("activate", name);
    }

    @Override
    public void setDeactivateMethod(String name) {
        this.setXMLAttribute("deactivate", name);
    }

    @Override
    public String getModifiedMethod() {
        return this.getXMLAttributeValue("modified");
    }

    @Override
    public void setModifiedeMethod(String name) {
        this.setXMLAttribute("modified", name);
    }

    public void setNamespace(String namespace) {
        String oldNs = this.getNamespace();
        super.setNamespace(namespace);
        if (!Objects.equals(namespace, oldNs)) {
            this.firePropertyChanged("xml_namespace", oldNs, namespace);
        }
    }

    public void setNamespacePrefix(String prefix) {
        String oldPrefix = this.getNamespacePrefix();
        super.setNamespacePrefix(prefix);
        if (!Objects.equals(oldPrefix, prefix)) {
            this.firePropertyChanged("xml_namespace_prefix", oldPrefix, prefix);
        }
    }
}

