/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class BreakpointChange
extends Change {
    protected static final int NO_LINE_NUMBER = -1;
    private final IJavaBreakpoint fBreakpoint;
    private final String fTypeName;
    private final int fHitCount;
    private final IJavaObject[] fInstanceFilters;
    private final int fSuspendPolicy;
    private final IJavaThread[] fThreadFilters;
    private final boolean fEnabled;
    private final String fWorkingSetNames;

    public BreakpointChange(IJavaBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
        this.fTypeName = breakpoint.getTypeName();
        this.fHitCount = breakpoint.getHitCount();
        this.fInstanceFilters = breakpoint.getInstanceFilters();
        this.fSuspendPolicy = breakpoint.getSuspendPolicy();
        this.fThreadFilters = breakpoint.getThreadFilters();
        this.fEnabled = breakpoint.isEnabled();
        this.fWorkingSetNames = (String)breakpoint.getMarker().getAttribute("workingset_name");
    }

    protected void apply(IJavaBreakpoint breakpoint) throws CoreException {
        IJavaObject filter;
        breakpoint.setHitCount(this.fHitCount);
        IJavaObject[] iJavaObjectArray = this.fInstanceFilters;
        int n = this.fInstanceFilters.length;
        int n2 = 0;
        while (n2 < n) {
            filter = iJavaObjectArray[n2];
            breakpoint.addInstanceFilter(filter);
            ++n2;
        }
        breakpoint.setSuspendPolicy(this.fSuspendPolicy);
        iJavaObjectArray = this.fThreadFilters;
        n = this.fThreadFilters.length;
        n2 = 0;
        while (n2 < n) {
            filter = iJavaObjectArray[n2];
            breakpoint.setThreadFilter((IJavaThread)filter);
            ++n2;
        }
        breakpoint.setEnabled(this.fEnabled);
    }

    protected IJavaBreakpoint getOriginalBreakpoint() {
        return this.fBreakpoint;
    }

    protected String getOriginalBreakpointTypeName() {
        return this.fTypeName;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Object getModifiedElement() {
        return this.fBreakpoint;
    }

    protected int[] getNewLineNumberAndRange(IMember member) throws CoreException {
        ISourceRange nameRange = member.getNameRange();
        int offset = nameRange.getOffset();
        int lineNumber = this.getNewLineNumber(member, offset);
        return new int[]{lineNumber, offset, offset + nameRange.getLength()};
    }

    private int getNewLineNumber(IMember member, int offset) throws JavaModelException {
        int lineNumber = this.getLineNumber();
        Document document = new Document(member.getCompilationUnit().getSource());
        try {
            lineNumber = document.getLineOfOffset(offset);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return lineNumber;
    }

    protected int getLineNumber() {
        return -1;
    }

    protected int getHitCount() {
        return this.fHitCount;
    }

    public static IType getType(IJavaElement parent, String simpleName) {
        switch (parent.getElementType()) {
            case 5: {
                return ((ICompilationUnit)parent).getType(simpleName);
            }
            case 7: {
                return ((IType)parent).getType(simpleName);
            }
            case 8: 
            case 9: 
            case 10: {
                return ((IMember)parent).getType(simpleName, -1);
            }
        }
        return null;
    }

    public static IJavaElement findElement(IJavaElement parent, IJavaElement element) {
        List<IJavaElement> children = BreakpointChange.getPath(element);
        List<IJavaElement> path = BreakpointChange.getPath(parent);
        IJavaElement currentElement = parent;
        int i = children.size() - path.size() - 1;
        while (i >= 0) {
            IJavaElement child = children.get(i);
            switch (child.getElementType()) {
                case 11: {
                    currentElement = ((ICompilationUnit)currentElement).getPackageDeclaration(child.getElementName());
                    break;
                }
                case 12: {
                    currentElement = ((ICompilationUnit)currentElement).getImportContainer();
                    break;
                }
                case 13: {
                    currentElement = ((IImportContainer)currentElement).getImport(child.getElementName());
                    break;
                }
                case 7: {
                    switch (currentElement.getElementType()) {
                        case 5: {
                            currentElement = ((ICompilationUnit)currentElement).getType(child.getElementName());
                            break;
                        }
                        case 6: {
                            if (!(currentElement instanceof IOrdinaryClassFile)) break;
                            currentElement = ((IOrdinaryClassFile)currentElement).getType();
                            break;
                        }
                        case 7: {
                            currentElement = ((IType)currentElement).getType(child.getElementName());
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            currentElement = ((IMember)currentElement).getType(child.getElementName(), ((IMember)child).getOccurrenceCount());
                        }
                    }
                    break;
                }
                case 10: {
                    currentElement = ((IType)currentElement).getInitializer(((IMember)child).getOccurrenceCount());
                    break;
                }
                case 8: {
                    currentElement = ((IType)currentElement).getField(child.getElementName());
                    break;
                }
                case 9: {
                    currentElement = ((IType)currentElement).getMethod(child.getElementName(), ((IMethod)child).getParameterTypes());
                }
            }
            --i;
        }
        return currentElement;
    }

    private static List<IJavaElement> getPath(IJavaElement element) {
        ArrayList<IJavaElement> children = new ArrayList<IJavaElement>();
        while (element != null && element.getElementType() != 5) {
            children.add(element);
            element = element.getParent();
        }
        return children;
    }

    protected String getBreakpointLabel(IBreakpoint breakpoint) {
        return JDIDebugUIPlugin.getDefault().getModelPresentation().getText((Object)breakpoint);
    }

    protected String getOriginalWorkingSets() {
        return this.fWorkingSetNames;
    }
}

