/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl.actions;

import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.TextNavigationAction;

public class EclTextNavigationAction
extends TextNavigationAction {
    protected final EclEditor eclEditor;
    private int fAction;
    private boolean enabled = true;

    public EclTextNavigationAction(EclEditor eclEditor, StyledText textWidget, int action) {
        super(textWidget, action);
        this.eclEditor = eclEditor;
        this.fAction = action;
    }

    protected void internalRun(TextViewer viewer) {
        Point selection = viewer.getTextWidget().getSelection();
        viewer.getTextWidget().invokeAction(this.getAction());
        this.fireSelectionChanged(selection);
    }

    protected int getAction() {
        return this.fAction;
    }

    public void run() {
        boolean editorsActive;
        boolean bl = editorsActive = !this.eclEditor.viewer.getControl().isFocusControl() && (this.eclEditor.header.isInFocus() || this.eclEditor.editorContent.isInFocus());
        if (!editorsActive) {
            this.internalRun(this.eclEditor.doGetSourceViewer());
        } else {
            if (this.eclEditor.header.isInFocus()) {
                this.eclEditor.header.doTextCommand(this.getAction());
            }
            if (this.eclEditor.editorContent.isInFocus()) {
                TextViewer textViewer = this.eclEditor.editorContent.getTextViewer();
                if (textViewer != null) {
                    this.internalRun(textViewer);
                } else {
                    this.eclEditor.editorContent.doTextCommand(this.getAction());
                }
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            Boolean oldVal = this.enabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean newVal = enabled ? Boolean.TRUE : Boolean.FALSE;
            this.enabled = enabled;
            this.firePropertyChange("enabled", oldVal, newVal);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

