/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.BoxedValue;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.core.EclBoolean;
import org.eclipse.rcptt.ecl.core.EclByte;
import org.eclipse.rcptt.ecl.core.EclChar;
import org.eclipse.rcptt.ecl.core.EclDouble;
import org.eclipse.rcptt.ecl.core.EclFloat;
import org.eclipse.rcptt.ecl.core.EclInteger;
import org.eclipse.rcptt.ecl.core.EclLong;
import org.eclipse.rcptt.ecl.core.EclShort;
import org.eclipse.rcptt.ecl.core.EclString;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;

public class BoxedValues {
    private static final String VALUE_FEATURE = "value";
    private static final Map<String, String> TO_BOXED_TYPE = new HashMap<String, String>();
    private static final Map<String, String> FROM_BOXED_TYPE = new HashMap<String, String>();
    private static BoxedSwitch<Boolean> toBoolean;
    private static BoxedSwitch<Byte> toByte;
    protected static BoxedSwitch<Character> toChar;
    protected static BoxedSwitch<Double> toDouble;
    protected static BoxedSwitch<Float> toFloat;
    protected static BoxedSwitch<Integer> toInteger;
    protected static BoxedSwitch<Long> toLong;
    protected static BoxedSwitch<Short> toShort;
    protected static BoxedSwitch<String> toString;
    private static Map<EClass, BoxedSwitch<? extends Object>> converters;

    static {
        TO_BOXED_TYPE.put(Byte.class.getName(), CorePackage.eINSTANCE.getEclByte().getName());
        TO_BOXED_TYPE.put(Short.class.getName(), CorePackage.eINSTANCE.getEclShort().getName());
        TO_BOXED_TYPE.put(Integer.class.getName(), CorePackage.eINSTANCE.getEclInteger().getName());
        TO_BOXED_TYPE.put(Long.class.getName(), CorePackage.eINSTANCE.getEclLong().getName());
        TO_BOXED_TYPE.put(Float.class.getName(), CorePackage.eINSTANCE.getEclFloat().getName());
        TO_BOXED_TYPE.put(Double.class.getName(), CorePackage.eINSTANCE.getEclDouble().getName());
        TO_BOXED_TYPE.put(Boolean.class.getName(), CorePackage.eINSTANCE.getEclBoolean().getName());
        TO_BOXED_TYPE.put(Character.class.getName(), CorePackage.eINSTANCE.getEclChar().getName());
        TO_BOXED_TYPE.put(String.class.getName(), CorePackage.eINSTANCE.getEclString().getName());
        for (Map.Entry<String, String> entry : TO_BOXED_TYPE.entrySet()) {
            FROM_BOXED_TYPE.put(entry.getValue(), entry.getKey());
        }
        toBoolean = new BoxedSwitch<Boolean>(){

            @Override
            protected Boolean caseBoolean(EclBoolean value) throws CoreException {
                return value.isValue();
            }

            @Override
            protected Boolean caseByte(EclByte value) throws CoreException {
                if (value.getValue() != 0) {
                    return true;
                }
                return false;
            }

            @Override
            protected Boolean caseChar(EclChar value) throws CoreException {
                if (value.getValue() != '\u0000') {
                    return true;
                }
                return false;
            }

            @Override
            protected Boolean caseDouble(EclDouble value) throws CoreException {
                if (value.getValue() != 0.0) {
                    return true;
                }
                return false;
            }

            @Override
            protected Boolean caseFloat(EclFloat value) throws CoreException {
                if (value.getValue() != 0.0f) {
                    return true;
                }
                return false;
            }

            @Override
            protected Boolean caseInteger(EclInteger value) throws CoreException {
                if (value.getValue() != 0) {
                    return true;
                }
                return false;
            }

            @Override
            protected Boolean caseLong(EclLong value) throws CoreException {
                if (value.getValue() != 0L) {
                    return true;
                }
                return false;
            }

            @Override
            protected Boolean caseShort(EclShort value) throws CoreException {
                if (value.getValue() != 0) {
                    return true;
                }
                return false;
            }

            @Override
            protected Boolean caseString(EclString value) throws CoreException {
                return Boolean.parseBoolean(value.getValue());
            }

            @Override
            protected Boolean caseDefault(BoxedValue value, String friendlyName) throws CoreException {
                throw new CoreException(BoxedValues.createConversionError(BoxedValues.toString(value), friendlyName, "Boolean"));
            }
        };
        toByte = new BoxedSwitch<Byte>(){
            private static final byte MIN = -128;
            private static final byte MAX = 127;

            @Override
            protected Byte caseDefault(BoxedValue value, String friendlyName) throws CoreException {
                throw new CoreException(BoxedValues.createConversionError(BoxedValues.toString(value), friendlyName, "Byte"));
            }

            @Override
            protected Byte caseBoolean(EclBoolean value) throws CoreException {
                return (byte)(value.isValue() ? 1 : 0);
            }

            @Override
            protected Byte caseByte(EclByte value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Byte caseChar(EclChar value) throws CoreException {
                char val = value.getValue();
                return val < '\uffffff80' || val > '\u007f' ? (Byte)super.caseChar(value) : (byte)val;
            }

            @Override
            protected Byte caseDouble(EclDouble value) throws CoreException {
                double val = value.getValue();
                return val < -128.0 || val > 127.0 ? (Byte)super.caseDouble(value) : (byte)val;
            }

            @Override
            protected Byte caseFloat(EclFloat value) throws CoreException {
                float val = value.getValue();
                return val < -128.0f || val > 127.0f ? (Byte)super.caseFloat(value) : (byte)val;
            }

            @Override
            protected Byte caseInteger(EclInteger value) throws CoreException {
                int val = value.getValue();
                return val < -128 || val > 127 ? (Byte)super.caseInteger(value) : (byte)val;
            }

            @Override
            protected Byte caseLong(EclLong value) throws CoreException {
                float val = value.getValue();
                return val < -128.0f || val > 127.0f ? (Byte)super.caseLong(value) : (byte)val;
            }

            @Override
            protected Byte caseShort(EclShort value) throws CoreException {
                short val = value.getValue();
                return val < -128 || val > 127 ? (Byte)super.caseShort(value) : (byte)val;
            }

            @Override
            protected Byte caseString(EclString value) throws CoreException {
                String val = value.getValue();
                try {
                    return Byte.parseByte(val);
                }
                catch (NumberFormatException e) {
                    return (Byte)super.caseString(value);
                }
            }
        };
        toChar = new BoxedSwitch<Character>(){
            private static final char MIN = '\u0000';
            private static final char MAX = '\uffff';

            @Override
            protected Character caseDefault(BoxedValue value, String friendlyName) throws CoreException {
                throw new CoreException(BoxedValues.createConversionError(BoxedValues.toString(value), friendlyName, "Char"));
            }

            @Override
            protected Character caseBoolean(EclBoolean value) throws CoreException {
                return Character.valueOf((char)(value.isValue() ? 1 : 0));
            }

            @Override
            protected Character caseByte(EclByte value) throws CoreException {
                return Character.valueOf((char)value.getValue());
            }

            @Override
            protected Character caseChar(EclChar value) throws CoreException {
                return Character.valueOf(value.getValue());
            }

            @Override
            protected Character caseDouble(EclDouble value) throws CoreException {
                double val = value.getValue();
                return Character.valueOf(val < 0.0 || val > 65535.0 ? ((Character)super.caseDouble(value)).charValue() : (char)val);
            }

            @Override
            protected Character caseFloat(EclFloat value) throws CoreException {
                float val = value.getValue();
                return Character.valueOf(val < 0.0f || val > 65535.0f ? ((Character)super.caseFloat(value)).charValue() : (char)val);
            }

            @Override
            protected Character caseInteger(EclInteger value) throws CoreException {
                int val = value.getValue();
                return Character.valueOf(val < 0 || val > 65535 ? ((Character)super.caseInteger(value)).charValue() : (char)val);
            }

            @Override
            protected Character caseLong(EclLong value) throws CoreException {
                long val = value.getValue();
                return Character.valueOf(val < 0L || val > 65535L ? ((Character)super.caseLong(value)).charValue() : (char)val);
            }

            @Override
            protected Character caseShort(EclShort value) throws CoreException {
                short val = value.getValue();
                return Character.valueOf(val < 0 || val > 65535 ? ((Character)super.caseShort(value)).charValue() : (char)val);
            }

            @Override
            protected Character caseString(EclString value) throws CoreException {
                String val = value.getValue();
                return Character.valueOf(val.length() == 1 ? val.charAt(0) : ((Character)super.caseString(value)).charValue());
            }
        };
        toDouble = new BoxedSwitch<Double>(){

            @Override
            protected Double caseDefault(BoxedValue value, String friendlyName) throws CoreException {
                throw new CoreException(BoxedValues.createConversionError(BoxedValues.toString(value), friendlyName, "Double"));
            }

            @Override
            protected Double caseBoolean(EclBoolean value) throws CoreException {
                return value.isValue() ? 1.0 : 0.0;
            }

            @Override
            protected Double caseByte(EclByte value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Double caseChar(EclChar value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Double caseDouble(EclDouble value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Double caseFloat(EclFloat value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Double caseInteger(EclInteger value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Double caseLong(EclLong value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Double caseShort(EclShort value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Double caseString(EclString value) throws CoreException {
                try {
                    return Double.parseDouble(value.getValue());
                }
                catch (NumberFormatException e) {
                    return (Double)super.caseString(value);
                }
            }
        };
        toFloat = new BoxedSwitch<Float>(){
            private static final float MIN = -3.4028235E38f;
            private static final float MAX = Float.MAX_VALUE;

            @Override
            protected Float caseDefault(BoxedValue value, String friendlyName) throws CoreException {
                throw new CoreException(BoxedValues.createConversionError(BoxedValues.toString(value), friendlyName, "Float"));
            }

            @Override
            protected Float caseBoolean(EclBoolean value) throws CoreException {
                return Float.valueOf(value.isValue() ? 1.0f : 0.0f);
            }

            @Override
            protected Float caseByte(EclByte value) throws CoreException {
                return Float.valueOf(value.getValue());
            }

            @Override
            protected Float caseChar(EclChar value) throws CoreException {
                return Float.valueOf(value.getValue());
            }

            @Override
            protected Float caseDouble(EclDouble value) throws CoreException {
                double val = value.getValue();
                return Float.valueOf(val < -3.4028234663852886E38 || val > 3.4028234663852886E38 ? ((Float)super.caseDouble(value)).floatValue() : (float)val);
            }

            @Override
            protected Float caseFloat(EclFloat value) throws CoreException {
                return Float.valueOf(value.getValue());
            }

            @Override
            protected Float caseInteger(EclInteger value) throws CoreException {
                return Float.valueOf(value.getValue());
            }

            @Override
            protected Float caseLong(EclLong value) throws CoreException {
                return Float.valueOf(value.getValue());
            }

            @Override
            protected Float caseShort(EclShort value) throws CoreException {
                return Float.valueOf(value.getValue());
            }

            @Override
            protected Float caseString(EclString value) throws CoreException {
                try {
                    return Float.valueOf(Float.parseFloat(value.getValue()));
                }
                catch (NumberFormatException e) {
                    return (Float)super.caseString(value);
                }
            }
        };
        toInteger = new BoxedSwitch<Integer>(){
            private static final int MIN = Integer.MIN_VALUE;
            private static final int MAX = Integer.MAX_VALUE;

            @Override
            protected Integer caseDefault(BoxedValue value, String friendlyName) throws CoreException {
                throw new CoreException(BoxedValues.createConversionError(BoxedValues.toString(value), friendlyName, "Integer"));
            }

            @Override
            protected Integer caseBoolean(EclBoolean value) throws CoreException {
                return value.isValue() ? 1 : 0;
            }

            @Override
            protected Integer caseByte(EclByte value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Integer caseChar(EclChar value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Integer caseDouble(EclDouble value) throws CoreException {
                double val = value.getValue();
                return val < -2.147483648E9 || val > 2.147483647E9 ? (Integer)super.caseDouble(value) : (int)val;
            }

            @Override
            protected Integer caseFloat(EclFloat value) throws CoreException {
                float val = value.getValue();
                return val < -2.1474836E9f || val > 2.1474836E9f ? (Integer)super.caseFloat(value) : (int)val;
            }

            @Override
            protected Integer caseInteger(EclInteger value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Integer caseLong(EclLong value) throws CoreException {
                long val = value.getValue();
                return val < Integer.MIN_VALUE || val > Integer.MAX_VALUE ? (Integer)super.caseLong(value) : (int)val;
            }

            @Override
            protected Integer caseShort(EclShort value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Integer caseString(EclString value) throws CoreException {
                try {
                    return Integer.parseInt(value.getValue());
                }
                catch (NumberFormatException e) {
                    return (Integer)super.caseString(value);
                }
            }
        };
        toLong = new BoxedSwitch<Long>(){
            private static final long MIN = Long.MIN_VALUE;
            private static final long MAX = Long.MAX_VALUE;

            @Override
            protected Long caseDefault(BoxedValue value, String friendlyName) throws CoreException {
                throw new CoreException(BoxedValues.createConversionError(BoxedValues.toString(value), friendlyName, "Long"));
            }

            @Override
            protected Long caseBoolean(EclBoolean value) throws CoreException {
                return value.isValue() ? 1L : 0L;
            }

            @Override
            protected Long caseByte(EclByte value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Long caseChar(EclChar value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Long caseDouble(EclDouble value) throws CoreException {
                double val = value.getValue();
                return val < -9.223372036854776E18 || val > 9.223372036854776E18 ? (Long)super.caseDouble(value) : (long)val;
            }

            @Override
            protected Long caseFloat(EclFloat value) throws CoreException {
                float val = value.getValue();
                return val < -9.223372E18f || val > 9.223372E18f ? (Long)super.caseFloat(value) : (long)val;
            }

            @Override
            protected Long caseInteger(EclInteger value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Long caseLong(EclLong value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Long caseShort(EclShort value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Long caseString(EclString value) throws CoreException {
                try {
                    return Long.parseLong(value.getValue());
                }
                catch (NumberFormatException e) {
                    return (Long)super.caseString(value);
                }
            }
        };
        toShort = new BoxedSwitch<Short>(){
            private static final short MIN = Short.MIN_VALUE;
            private static final short MAX = Short.MAX_VALUE;

            @Override
            protected Short caseDefault(BoxedValue value, String friendlyName) throws CoreException {
                throw new CoreException(BoxedValues.createConversionError(BoxedValues.toString(value), friendlyName, "Short"));
            }

            @Override
            protected Short caseBoolean(EclBoolean value) throws CoreException {
                return (short)(value.isValue() ? 1 : 0);
            }

            @Override
            protected Short caseByte(EclByte value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Short caseChar(EclChar value) throws CoreException {
                return (short)value.getValue();
            }

            @Override
            protected Short caseDouble(EclDouble value) throws CoreException {
                double val = value.getValue();
                return val < -32768.0 || val > 32767.0 ? (Short)super.caseDouble(value) : (short)val;
            }

            @Override
            protected Short caseFloat(EclFloat value) throws CoreException {
                float val = value.getValue();
                return val < -32768.0f || val > 32767.0f ? (Short)super.caseFloat(value) : (short)val;
            }

            @Override
            protected Short caseInteger(EclInteger value) throws CoreException {
                int val = value.getValue();
                return val < Short.MIN_VALUE || val > Short.MAX_VALUE ? (Short)super.caseInteger(value) : (short)val;
            }

            @Override
            protected Short caseLong(EclLong value) throws CoreException {
                long val = value.getValue();
                return val < -32768L || val > 32767L ? (Short)super.caseLong(value) : (short)val;
            }

            @Override
            protected Short caseShort(EclShort value) throws CoreException {
                return value.getValue();
            }

            @Override
            protected Short caseString(EclString value) throws CoreException {
                try {
                    return Short.parseShort(value.getValue());
                }
                catch (NumberFormatException e) {
                    return (Short)super.caseString(value);
                }
            }
        };
        toString = new BoxedSwitch<String>(){

            @Override
            protected String caseDefault(BoxedValue value, String friendlyName) throws CoreException {
                return value.eGet(value.eClass().getEStructuralFeature(BoxedValues.VALUE_FEATURE)).toString();
            }
        };
        converters = new HashMap<EClass, BoxedSwitch<? extends Object>>(){
            {
                this.put(CorePackage.Literals.ECL_BOOLEAN, toBoolean);
                this.put(CorePackage.Literals.ECL_BYTE, toByte);
                this.put(CorePackage.Literals.ECL_CHAR, toChar);
                this.put(CorePackage.Literals.ECL_DOUBLE, toDouble);
                this.put(CorePackage.Literals.ECL_FLOAT, toFloat);
                this.put(CorePackage.Literals.ECL_INTEGER, toInteger);
                this.put(CorePackage.Literals.ECL_LONG, toLong);
                this.put(CorePackage.Literals.ECL_SHORT, toShort);
                this.put(CorePackage.Literals.ECL_STRING, toString);
            }
        };
    }

    private BoxedValues() {
    }

    public static EObject box(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EObject) {
            return (EObject)object;
        }
        String className = object.getClass().getName();
        if (!TO_BOXED_TYPE.containsKey(className)) {
            throw new IllegalArgumentException(String.format("Do not know how to box value of type '%s'", object.getClass().getName()));
        }
        EClass boxedType = (EClass)CorePackage.eINSTANCE.getEClassifier(TO_BOXED_TYPE.get(object.getClass().getName()));
        EObject result = CoreFactory.eINSTANCE.create(boxedType);
        result.eSet(boxedType.getEStructuralFeature(VALUE_FEATURE), object);
        return result;
    }

    public static EclBoolean box(boolean b) {
        EclBoolean result = CoreFactory.eINSTANCE.createEclBoolean();
        result.setValue(b);
        return result;
    }

    public static EclByte box(byte b) {
        EclByte result = CoreFactory.eINSTANCE.createEclByte();
        result.setValue(b);
        return result;
    }

    public static EclChar box(char c) {
        EclChar result = CoreFactory.eINSTANCE.createEclChar();
        result.setValue(c);
        return result;
    }

    public static EclDouble box(double d) {
        EclDouble result = CoreFactory.eINSTANCE.createEclDouble();
        result.setValue(d);
        return result;
    }

    public static EclFloat box(float f) {
        EclFloat result = CoreFactory.eINSTANCE.createEclFloat();
        result.setValue(f);
        return result;
    }

    public static EclInteger box(int i) {
        EclInteger result = CoreFactory.eINSTANCE.createEclInteger();
        result.setValue(i);
        return result;
    }

    public static EclLong box(long l) {
        EclLong result = CoreFactory.eINSTANCE.createEclLong();
        result.setValue(l);
        return result;
    }

    public static EclShort box(short s) {
        EclShort result = CoreFactory.eINSTANCE.createEclShort();
        result.setValue(s);
        return result;
    }

    public static EclString box(String s) {
        EclString result = CoreFactory.eINSTANCE.createEclString();
        result.setValue(s);
        return result;
    }

    public static Object unbox(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof EObject)) {
            return object;
        }
        EClass eClass = ((EObject)object).eClass();
        if (FROM_BOXED_TYPE.containsKey(eClass.getName())) {
            return ((EObject)object).eGet(eClass.getEStructuralFeature(VALUE_FEATURE));
        }
        return object;
    }

    public static BoxedValue toType(BoxedValue value, EClass to) throws CoreException {
        if (!converters.containsKey(to)) {
            throw new CoreException(CorePlugin.err(String.format("Don't know how to convert to %s", to.getName())));
        }
        return (BoxedValue)BoxedValues.box(converters.get(to).doSwitch(value));
    }

    public static Boolean toBoolean(BoxedValue boxed) throws CoreException {
        return toBoolean.doSwitch(boxed);
    }

    public static Byte toByte(BoxedValue boxed) throws CoreException {
        return toByte.doSwitch(boxed);
    }

    public static Character toChar(BoxedValue boxed) throws CoreException {
        return toChar.doSwitch(boxed);
    }

    public static Double toDouble(BoxedValue boxed) throws CoreException {
        return toDouble.doSwitch(boxed);
    }

    public static Float toFloat(BoxedValue boxed) throws CoreException {
        return toFloat.doSwitch(boxed);
    }

    public static Integer toInteger(BoxedValue boxed) throws CoreException {
        return toInteger.doSwitch(boxed);
    }

    public static Long toLong(BoxedValue boxed) throws CoreException {
        return toLong.doSwitch(boxed);
    }

    public static Short toShort(BoxedValue boxed) throws CoreException {
        return toShort.doSwitch(boxed);
    }

    public static String toString(BoxedValue boxed) {
        try {
            return toString.doSwitch(boxed);
        }
        catch (CoreException e) {
            return boxed == null ? "null" : boxed.toString();
        }
    }

    private static IStatus createConversionError(String value, String from, String to) {
        return new Status(4, "org.eclipse.rcptt.ecl.core", String.format("Cannot convert value '%s' from %s to %s", value, from, to));
    }

    public static class BoxedSwitch<T> {
        public T doSwitch(BoxedValue value) throws CoreException {
            switch (value.eClass().getClassifierID()) {
                case 25: {
                    return this.caseBoolean((EclBoolean)value);
                }
                case 19: {
                    return this.caseByte((EclByte)value);
                }
                case 26: {
                    return this.caseChar((EclChar)value);
                }
                case 23: {
                    return this.caseDouble((EclDouble)value);
                }
                case 24: {
                    return this.caseFloat((EclFloat)value);
                }
                case 21: {
                    return this.caseInteger((EclInteger)value);
                }
                case 22: {
                    return this.caseLong((EclLong)value);
                }
                case 20: {
                    return this.caseShort((EclShort)value);
                }
                case 27: {
                    return this.caseString((EclString)value);
                }
            }
            return this.caseDefault(value, value.eClass().getName());
        }

        protected T caseBoolean(EclBoolean value) throws CoreException {
            return this.caseDefault(value, "Boolean");
        }

        protected T caseByte(EclByte value) throws CoreException {
            return this.caseDefault(value, "Byte");
        }

        protected T caseChar(EclChar value) throws CoreException {
            return this.caseDefault(value, "Char");
        }

        protected T caseDouble(EclDouble value) throws CoreException {
            return this.caseDefault(value, "Double");
        }

        protected T caseFloat(EclFloat value) throws CoreException {
            return this.caseDefault(value, "Float");
        }

        protected T caseInteger(EclInteger value) throws CoreException {
            return this.caseDefault(value, "Integer");
        }

        protected T caseLong(EclLong value) throws CoreException {
            return this.caseDefault(value, "Long");
        }

        protected T caseShort(EclShort value) throws CoreException {
            return this.caseDefault(value, "Short");
        }

        protected T caseString(EclString value) throws CoreException {
            return this.caseDefault(value, "String");
        }

        protected T caseDefault(BoxedValue value, String friendlyName) throws CoreException {
            return null;
        }
    }
}

