/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.log.impl.rap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.VerificationProcessor;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.verifications.log.ErrorLogVerification;
import org.eclipse.rcptt.verifications.log.LogEntryPredicate;
import org.eclipse.rcptt.verifications.log.LogFactory;
import org.eclipse.rcptt.verifications.log.tools.ErrorLogUtil;
import org.eclipse.rcptt.verifications.runtime.ErrorList;

public class ErrorLogVerificationProcessor
extends VerificationProcessor
implements ILogListener {
    private final List<LogEntry> testLog = new ArrayList<LogEntry>();

    public ErrorLogVerificationProcessor() {
        Platform.addLogListener((ILogListener)this);
    }

    public synchronized Object start(Verification verification, IProcess process) {
        this.testLog.clear();
        return null;
    }

    public synchronized Object run(Verification verification, Object data, IProcess process) {
        return data;
    }

    public void finish(Verification verification, Object data, IProcess process) throws CoreException {
        ErrorList errors = this.findErrors((ErrorLogVerification)verification);
        errors.throwIfAny(String.format("Error log verification '%s' failed:", verification.getName()), ((Object)((Object)this)).getClass().getPackage().getName(), verification.getId());
    }

    private ErrorList findErrors(ErrorLogVerification logVerification) {
        ArrayList<LogEntryPredicate> whiteList = new ArrayList<LogEntryPredicate>();
        whiteList.addAll((Collection<LogEntryPredicate>)logVerification.getAllowed());
        whiteList.addAll((Collection<LogEntryPredicate>)logVerification.getRequired());
        ErrorList errors = new ErrorList();
        for (LogEntry entry : this.testLog) {
            LogEntryPredicate denied;
            boolean ignoreContext;
            boolean bl = ignoreContext = !logVerification.isIncludeContexts() && ErrorLogVerificationProcessor.isContext(entry.node);
            if (ignoreContext || this.isWhiteListed(whiteList, entry.status) || (denied = ErrorLogUtil.find((Iterable)logVerification.getDenied(), (IStatus)entry.status)) == null) continue;
            errors.add("Log entry\n%s\nis denied by predicate\n%s", new Object[]{ErrorLogUtil.describe((IStatus)entry.status), ErrorLogUtil.describe((LogEntryPredicate)denied)});
        }
        for (LogEntryPredicate predicate : logVerification.getRequired()) {
            if (ErrorLogVerificationProcessor.contains(this.testLog, predicate)) continue;
            errors.add("Required \n%s\nnot found", new Object[]{ErrorLogUtil.describe((LogEntryPredicate)predicate)});
        }
        return errors;
    }

    private static boolean contains(Collection<LogEntry> entries, LogEntryPredicate predicate) {
        for (LogEntry entry : entries) {
            if (!ErrorLogUtil.match((LogEntryPredicate)predicate, (IStatus)entry.status)) continue;
            return true;
        }
        return false;
    }

    public synchronized void logging(IStatus status, String plugin) {
        INodeBuilder node = ReportManager.getCurrentReportNode();
        this.testLog.add(new LogEntry(status, node));
    }

    private boolean isWhiteListed(Iterable<LogEntryPredicate> whiteList, IStatus status) {
        LogEntryPredicate rv = ErrorLogUtil.find(whiteList, (IStatus)status);
        if (rv != null) {
            ErrorLogVerification verification = (ErrorLogVerification)rv.eContainer();
            ReportManager.appendLog((String)String.format("Log entry %s is allowed by verification %s with %s", ErrorLogUtil.describe((IStatus)status), verification.getName(), ErrorLogUtil.describe((LogEntryPredicate)rv)));
        }
        return rv != null;
    }

    public Verification create(EObject param, IProcess process) throws CoreException {
        ErrorLogVerification rv = LogFactory.eINSTANCE.createErrorLogVerification();
        if (param instanceof ErrorLogVerification) {
            rv.setIncludeContexts(((ErrorLogVerification)param).isIncludeContexts());
        }
        for (LogEntry entry : this.testLog) {
            if (!rv.isIncludeContexts() && ErrorLogVerificationProcessor.isContext(entry.node)) continue;
            rv.getAllowed().add((Object)ErrorLogUtil.createMatchingPredicate((IStatus)entry.status));
        }
        return rv;
    }

    private static boolean isContext(INodeBuilder node) {
        while (node != null) {
            Q7Info info = (Q7Info)node.getProperty("q7");
            if (info != null && ItemKind.CONTEXT.equals((Object)info.getType())) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private static class LogEntry {
        final IStatus status;
        final INodeBuilder node;

        LogEntry(IStatus status, INodeBuilder node) {
            if (status == null) {
                throw new NullPointerException("Status should not be null");
            }
            this.status = status;
            this.node = node;
        }
    }
}

