/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools.change;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.InfoFilesUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.osgi.framework.Version;

public class CreatePackageInfoChange
extends ResourceChange {
    public static final String PACKAGE_INFO_JAVA = "package-info.java";
    private IPackageFragment fragment;
    private String name;
    private Version version;

    public CreatePackageInfoChange(IPackageFragment fragment, String name, Version version) {
        this.fragment = fragment;
        this.name = name;
        this.version = version;
    }

    protected IResource getModifiedResource() {
        try {
            return this.fragment.getCorrespondingResource();
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public String getName() {
        return NLS.bind((String)PDEUIMessages.CreatePackageInfoChange_name, (Object)PACKAGE_INFO_JAVA, (Object)this.fragment.getElementName());
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        StringBuilder fileContent = new StringBuilder("@org.osgi.annotation.bundle.Export(substitution = org.osgi.annotation.bundle.Export.Substitution.NOIMPORT)");
        if (this.version != null && !this.version.equals((Object)Version.emptyVersion)) {
            fileContent.append("@org.osgi.annotation.versioning.Version(\"");
            fileContent.append(this.version.getMajor());
            fileContent.append('.');
            fileContent.append(this.version.getMinor());
            fileContent.append('.');
            fileContent.append(this.version.getMicro());
            fileContent.append("\")");
        }
        fileContent.append("package ");
        fileContent.append(this.name);
        fileContent.append(";");
        InfoFilesUtil.createInfoJavaFile((String)PACKAGE_INFO_JAVA, (String)fileContent.toString(), (IPackageFragment)this.fragment, (boolean)false, (IProgressMonitor)pm);
        return new DeleteResourceChange(this.fragment.getPath(), true);
    }
}

