/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.TextUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.PlatformUI;

public final class TextViewerActions
implements NamedElementEditorActions.INamedElementActions {
    private final TextViewer textViewer;

    public TextViewerActions(TextViewer textViewer) {
        this.textViewer = textViewer;
        textViewer.setDocument((IDocument)new Document());
        textViewer.setUndoManager((IUndoManager)new TextViewerUndoManager(25));
        textViewer.activatePlugins();
    }

    @Override
    public void undo() {
        IUndoContext ctx = this.getUndoContext();
        if (ctx != null) {
            try {
                this.getHistory().undo(ctx, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Q7UIPlugin.log(e);
            }
        }
    }

    @Override
    public void redo() {
        IUndoContext ctx = this.getUndoContext();
        if (ctx != null) {
            try {
                this.getHistory().redo(ctx, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Q7UIPlugin.log(e);
            }
        }
    }

    @Override
    public boolean canUndo() {
        IUndoContext ctx = this.getUndoContext();
        if (ctx != null) {
            return this.getHistory().canUndo(ctx);
        }
        return false;
    }

    @Override
    public boolean canRedo() {
        IUndoContext ctx = this.getUndoContext();
        if (ctx != null) {
            return this.getHistory().canRedo(ctx);
        }
        return false;
    }

    IOperationHistory getHistory() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager;
        if (this.getTextViewer() instanceof ITextViewerExtension6 && (undoManager = this.getTextViewer().getUndoManager()) instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    private TextViewer getTextViewer() {
        return this.textViewer;
    }

    private StyledText getTextControl() {
        return this.getTextViewer().getTextWidget();
    }

    @Override
    public void copy() {
        TextUtils.copy(this.getTextControl());
    }

    @Override
    public void paste() {
        TextUtils.paste(this.getTextControl());
    }

    @Override
    public void cut() {
        TextUtils.cut(this.getTextControl());
    }

    @Override
    public boolean canCopy() {
        return TextUtils.canCopy(this.getTextControl());
    }

    @Override
    public boolean canPaste() {
        return TextUtils.canPaste(this.getTextControl());
    }

    @Override
    public boolean canCut() {
        return TextUtils.canCut(this.getTextControl());
    }
}

