/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete;

import java.util.HashMap;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TargetCompletionProposal;

public class TagCompletionProposal
extends TargetCompletionProposal {
    private static final HashMap<String, Attribute[]> tagStartingAttributesAndValues = new HashMap();

    static {
        tagStartingAttributesAndValues.put("target", new Attribute[]{new Attribute("name", null), new Attribute("sequenceNumber", "1")});
        tagStartingAttributesAndValues.put("location (Directory)", new Attribute[]{new Attribute("path", null), new Attribute("type", "Directory")});
        tagStartingAttributesAndValues.put("location (Feature)", new Attribute[]{new Attribute("path", null), new Attribute("id", null), new Attribute("type", "Feature")});
        tagStartingAttributesAndValues.put("location (Installable Unit)", new Attribute[]{new Attribute("type", "InstallableUnit")});
        tagStartingAttributesAndValues.put("location (Profile)", new Attribute[]{new Attribute("path", null), new Attribute("type", "Profile")});
        tagStartingAttributesAndValues.put("unit", new Attribute[]{new Attribute("id", null), new Attribute("version", "0.0.0")});
        tagStartingAttributesAndValues.put("repository", new Attribute[]{new Attribute("location", null)});
        tagStartingAttributesAndValues.put("targetJRE", new Attribute[]{new Attribute("path", null)});
    }

    public TagCompletionProposal(String tagType, int replacementOffset, int replacementLength, StyledString displayString) {
        super(TagCompletionProposal.getReplacementStringFromTagType(tagType), TagCompletionProposal.getcursorPositionFromReplacementString(TagCompletionProposal.getReplacementStringFromTagType(tagType)), replacementOffset, replacementLength, displayString);
    }

    private static String getReplacementStringFromTagType(String tagType) {
        Object tagName = TagCompletionProposal.getTagNameFromTageType(tagType);
        Object handyAddition = tagType.equalsIgnoreCase("unit") || tagType.equalsIgnoreCase("repository") || tagType.equalsIgnoreCase("targetJRE") || tagType.equalsIgnoreCase("location (Profile)") || tagType.equalsIgnoreCase("location (Directory)") || tagType.equalsIgnoreCase("location (Feature)") ? "/>" : "></" + (String)tagName + ">";
        if (tagStartingAttributesAndValues.containsKey(tagType)) {
            Attribute[] attributeArray = tagStartingAttributesAndValues.get(tagType);
            int n = attributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                tagName = (String)tagName + " " + attribute.toString();
                ++n2;
            }
        }
        return (String)tagName + (String)handyAddition;
    }

    private static String getTagNameFromTageType(String tagType) {
        if ("location (Directory)".equals(tagType) || "location (Installable Unit)".equals(tagType) || "location (Profile)".equals(tagType) || "location (Feature)".equals(tagType)) {
            return "location";
        }
        return tagType;
    }

    private static int getcursorPositionFromReplacementString(String replacementString) {
        int emptyAttributeIndex = replacementString.indexOf("\"\"");
        if (emptyAttributeIndex >= 0) {
            return emptyAttributeIndex + 1;
        }
        int tagEndingIndex = replacementString.indexOf(62);
        if (tagEndingIndex >= 0) {
            return tagEndingIndex + 1;
        }
        return replacementString.length() + 1;
    }

    private static class Attribute {
        public String name;
        public String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            if (this.value == null) {
                return this.name + "=\"\"";
            }
            return this.name + "=\"" + this.value + "\"";
        }
    }
}

