/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IgnoreColumnsMode implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    LEFT(1, "LEFT", "LEFT"),
    RIGHT(2, "RIGHT", "RIGHT"),
    BOTH(3, "BOTH", "BOTH");

    public static final int NONE_VALUE = 0;
    public static final int LEFT_VALUE = 1;
    public static final int RIGHT_VALUE = 2;
    public static final int BOTH_VALUE = 3;
    private static final IgnoreColumnsMode[] VALUES_ARRAY;
    public static final List<IgnoreColumnsMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IgnoreColumnsMode[]{NONE, LEFT, RIGHT, BOTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IgnoreColumnsMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IgnoreColumnsMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IgnoreColumnsMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IgnoreColumnsMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IgnoreColumnsMode get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return LEFT;
            }
            case 2: {
                return RIGHT;
            }
            case 3: {
                return BOTH;
            }
        }
        return null;
    }

    private IgnoreColumnsMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

