/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.logger;

import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.logger.LogServiceEnabledLogger;
import org.apache.felix.scr.impl.logger.LogServiceSupport;
import org.apache.felix.scr.impl.logger.ScrLogger;
import org.osgi.framework.BundleContext;

public class BundleLogger
extends LogServiceEnabledLogger {
    private final ScrLogger parent;

    public BundleLogger(BundleContext bundleContext, ScrLogger parent) {
        super(parent.getConfiguration(), bundleContext);
        this.parent = parent;
    }

    @Override
    InternalLogger getDefaultLogger() {
        return new InternalLogger(){

            @Override
            public boolean checkScrConfig() {
                return BundleLogger.this.parent.getLogger().checkScrConfig();
            }

            @Override
            public void log(int level, String message, Throwable ex) {
                BundleLogger.this.parent.getLogger().log(level, message, ex);
            }

            @Override
            public boolean isLogEnabled(int level) {
                return BundleLogger.this.parent.getLogger().isLogEnabled(level);
            }
        };
    }

    int getTrackingCount() {
        return this.trackingCount;
    }

    InternalLogger getLogger(String className) {
        Object logServiceSupport;
        if (className != null && (logServiceSupport = this.logServiceTracker.getService()) != null) {
            return ((LogServiceSupport)logServiceSupport).getLogger(className);
        }
        return this.getLogger();
    }

    @Override
    public boolean log(int level, String pattern, Throwable ex, Object ... arguments) {
        if (!super.log(level, pattern, ex, arguments)) {
            return this.parent.log(level, pattern, ex, arguments);
        }
        return false;
    }

    @Override
    public boolean log(int level, String message, Throwable ex) {
        if (!super.log(level, message, ex)) {
            return this.parent.log(level, message, ex);
        }
        return false;
    }
}

