/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.resources.impl;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipInputStream;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.resources.impl.WSOptions;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.util.resources.ResourcesUtil;
import org.eclipse.rcptt.verifications.resources.impl.LineComparator;
import org.eclipse.rcptt.verifications.resources.internal.impl.Activator;
import org.eclipse.rcptt.verifications.runtime.ErrorList;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceVerification;

public class WorkspaceVerificationChecker {
    private final WorkspaceVerification verification;
    private WSRoot root;
    private String location;
    private boolean allowUncapturedFiles;
    private String[] notAllowedPatterns;
    private boolean ignoreWhiteSpace;
    private Pattern[] ignoredLinePatterns;
    private ErrorList errors;
    private int maxFileDiffsCount;

    public WorkspaceVerificationChecker(WorkspaceVerification verification) {
        this.verification = verification;
    }

    private void initialize() throws CoreException {
        this.root = this.verification.getContent();
        this.location = this.verification.getLocation();
        this.ignoreWhiteSpace = this.verification.isIgnoreWhiteSpace();
        this.allowUncapturedFiles = this.verification.isAllowUncapturedFiles();
        this.notAllowedPatterns = WSOptions.resolveIgnoredPattern((String)"", (String)this.verification.getNotAllowedPatterns());
        if (this.verification.getIgnoredLines() != null) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            String ignoredLines = this.verification.getIgnoredLines().replaceAll("\\r", "");
            String[] stringArray = ignoredLines.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String skippedline = stringArray[n2];
                try {
                    patterns.add(Pattern.compile(skippedline));
                }
                catch (PatternSyntaxException e) {
                    String message = String.format("Invalid '%s' regex", skippedline);
                    IStatus status = Activator.createStatus(message, e);
                    throw new CoreException(status);
                }
                ++n2;
            }
            this.ignoredLinePatterns = patterns.toArray(new Pattern[patterns.size()]);
        }
        this.errors = new ErrorList();
        this.maxFileDiffsCount = TeslaFeatures.getInstance().getIntValue("org.eclipse.rcptt.resources.verification.hunks.count");
    }

    public void verifyWorkspace() throws CoreException {
        this.initialize();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.verifyProjects(this.root, wsRoot);
        this.errors.throwIfAny(String.format("Workspace verification '%s' failed:", this.verification.getName()), this.getClass().getPackage().getName(), this.verification.getId());
    }

    private void verifyProjects(WSRoot root, IWorkspaceRoot rRoot) throws CoreException {
        ArrayList rProjects = new ArrayList();
        Collections.addAll(rProjects, rRoot.getProjects());
        for (WSProject project : root.getProjects()) {
            IProject rProject = (IProject)ResourcesUtil.getCaseInsensitiveChild((IContainer)rRoot, (String)project.getName(), IProject.class);
            if (rProject == null) {
                this.reportError(String.format("Project '%s' is not found", project.getName()));
                continue;
            }
            if (!rProject.exists()) {
                this.reportError(String.format("Project '%s' does not exist", project.getName()));
                continue;
            }
            if (!rProject.isOpen()) {
                this.reportError(String.format("Project '%s' is not open", project.getName()));
                continue;
            }
            rProjects.remove(rProject);
            this.verifyContainer((WSFolder)project, (IContainer)rProject, "", true);
        }
        if (!this.isUncapturedFilesAllowed()) {
            for (IProject rChild : rProjects) {
                if (this.isAllowedFile(rChild.getName())) continue;
                this.reportError(String.format("Unexpected '%s' project", rChild.getName()));
            }
        }
    }

    private void verifyContainers(WSFolder folder, IContainer rFolder, String path, boolean isUncapturedAllowedInFolder) throws CoreException {
        ArrayList<IFolder> rFolders = new ArrayList<IFolder>();
        IResource[] iResourceArray = rFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource rResource = iResourceArray[n2];
            if (rResource instanceof IFolder) {
                rFolders.add((IFolder)rResource);
            }
            ++n2;
        }
        for (WSFolder child : folder.getFolders()) {
            IFolder rChild = rFolder.getFolder((IPath)new Path(child.getName()));
            if (!rChild.exists()) {
                this.reportError(String.format("Folder '%s%s/' does not exist", path, rChild.getName()));
                continue;
            }
            rFolders.remove(rChild);
            this.verifyContainer(child, (IContainer)rChild, path, isUncapturedAllowedInFolder);
        }
        if (!this.isUncapturedFilesAllowed()) {
            for (IFolder rChild : rFolders) {
                if (this.isAllowedFile(rChild.getName()) && isUncapturedAllowedInFolder) continue;
                this.reportError(String.format("Unexpected '%s%s/' folder", path, rChild.getName()));
            }
        }
    }

    private void verifyFiles(WSFolder folder, IContainer rFolder, String path, boolean isUncapturedAllowedInFolder) throws CoreException {
        ArrayList<IFile> rFiles = new ArrayList<IFile>();
        IResource[] iResourceArray = rFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource rResource = iResourceArray[n2];
            if (rResource instanceof IFile) {
                rFiles.add((IFile)rResource);
            }
            ++n2;
        }
        for (WSFile child : folder.getFiles()) {
            IFile rChild = rFolder.getFile((IPath)new Path(child.getName()));
            if (!rChild.exists()) {
                this.reportError(String.format("File '%s%s' does not exist", path, child.getName()));
                continue;
            }
            rFiles.remove(rChild);
            this.verifyFile(child, rChild, path);
        }
        if (!this.isUncapturedFilesAllowed()) {
            for (IFile rChild : rFiles) {
                if (this.isAllowedFile(rChild.getName()) && isUncapturedAllowedInFolder) continue;
                this.reportError(String.format("Unexpected '%s%s' file", path, rChild.getName()));
            }
        }
    }

    private void verifyContainer(WSFolder folder, IContainer rFolder, String path, boolean isUncapturedAllowedInFolder) throws CoreException {
        this.verifyContainers(folder, rFolder, this.getFullPath(path, rFolder), isUncapturedAllowedInFolder &= this.isAllowedFile(folder.getName()));
        this.verifyFiles(folder, rFolder, this.getFullPath(path, rFolder), isUncapturedAllowedInFolder);
    }

    private void verifyFile(WSFile file, IFile rFile, String path) throws CoreException {
        try {
            InputStream stream = this.getWSFileStream(file);
            InputStream rStream = rFile.getContents();
            try {
                try {
                    this.verifyLineByLine(stream, rStream, String.valueOf(path) + file.getName());
                }
                catch (CoreException e) {
                    String message = String.format("Error while verifying '%s%s' file:\n%s", path, file.getName(), e.getMessage());
                    IStatus status = Activator.createStatus(message, e);
                    throw new CoreException(status);
                }
            }
            finally {
                WSUtils.safeClose((Closeable)stream);
                WSUtils.safeClose((Closeable)rStream);
            }
        }
        catch (IOException e) {
            IStatus status = Activator.createStatus(e.getMessage(), e);
            throw new CoreException(status);
        }
    }

    private void verifyLineByLine(InputStream stream, InputStream rStream, String fileName) throws IOException, CoreException {
        LineComparator comparator = new LineComparator(stream, this.ignoreWhiteSpace);
        LineComparator rComparator = new LineComparator(rStream, this.ignoreWhiteSpace);
        RangeDifference[] diffs = RangeDifferencer.findRanges(null, (IRangeComparator)comparator, (IRangeComparator)rComparator);
        int diffsCount = 0;
        int prevDiffEnd = -1;
        ArrayList<Integer> unprintedRows = new ArrayList<Integer>();
        StringBuilder result = new StringBuilder();
        RangeDifference[] rangeDifferenceArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference diff = rangeDifferenceArray[n2];
            int kind = diff.kind();
            if (kind == 2) {
                StringBuilder leftBuilder = new StringBuilder();
                StringBuilder rightBuilder = new StringBuilder();
                int rightStart = -1;
                int rightEnd = -1;
                int lastChangedLine = -1;
                int lastUnchangedLine = -1;
                int i = 0;
                while (i < Math.max(diff.leftLength(), diff.rightLength())) {
                    String line;
                    int left = diff.leftStart() + i;
                    int right = diff.rightStart() + i;
                    boolean concatDiffs = false;
                    if (right < diff.rightEnd()) {
                        line = rComparator.getLine(right);
                        if (!this.isSkippedLine(line)) {
                            if (rightStart == -1) {
                                rightStart = right;
                            }
                            rightEnd = right + 1;
                            rightBuilder.append("+").append(right + 1).append(" >").append(line).append("\n");
                            lastChangedLine = right;
                        } else if (rightStart != -1 && right < rightEnd + 3) {
                            rightBuilder.append(" ").append(right + 1).append(" >").append(line).append("\n");
                            lastUnchangedLine = right;
                            concatDiffs = true;
                        }
                    }
                    if (left < diff.leftEnd()) {
                        line = comparator.getLine(left);
                        if (!this.isSkippedLine(line)) {
                            leftBuilder.append("-").append(left + 1).append(" >").append(line).append("\n");
                        } else {
                            concatDiffs = true;
                        }
                    }
                    if (concatDiffs && rightBuilder.length() != 0) {
                        leftBuilder.append(rightBuilder.toString());
                        rightBuilder.setLength(0);
                    }
                    ++i;
                }
                if (leftBuilder.length() != 0 || rightBuilder.length() != 0) {
                    StringBuilder diffBuilder = new StringBuilder();
                    if (rightStart == -1) {
                        rightStart = diff.rightStart();
                        rightEnd = diff.rightEnd();
                    }
                    int i2 = Math.max(0, rightStart - 3);
                    while (i2 < rightStart) {
                        if (!unprintedRows.isEmpty()) {
                            if (diffsCount <= this.maxFileDiffsCount) {
                                Iterator iterator = unprintedRows.iterator();
                                while (iterator.hasNext()) {
                                    int row = (Integer)iterator.next();
                                    if (row >= i2) continue;
                                    result.append(" ").append(row + 1).append(" >").append(rComparator.getLine(row)).append("\n");
                                }
                                if (i2 > prevDiffEnd + 3) {
                                    result.append("\n");
                                }
                            }
                            unprintedRows.clear();
                        }
                        if (i2 > prevDiffEnd) {
                            diffBuilder.append(" ").append(i2 + 1).append(" >").append(rComparator.getLine(i2)).append("\n");
                        }
                        ++i2;
                    }
                    if (leftBuilder.length() != 0) {
                        diffBuilder.append(leftBuilder.toString());
                    }
                    if (rightBuilder.length() != 0) {
                        diffBuilder.append(rightBuilder.toString());
                    }
                    i2 = rightEnd;
                    while (i2 < Math.min(rComparator.getRangeCount(), rightEnd + 3)) {
                        if (i2 > lastUnchangedLine) {
                            unprintedRows.add(i2);
                        }
                        ++i2;
                    }
                    prevDiffEnd = lastChangedLine + 1;
                    if (++diffsCount <= this.maxFileDiffsCount) {
                        result.append(diffBuilder.toString());
                    }
                }
            }
            ++n2;
        }
        if (diffsCount == 0) {
            return;
        }
        result.insert(0, String.format("%d difference%s in '%s' file:\n", diffsCount, diffsCount > 1 ? "s" : "", fileName));
        if (diffsCount <= this.maxFileDiffsCount && !unprintedRows.isEmpty()) {
            Iterator iterator = unprintedRows.iterator();
            while (iterator.hasNext()) {
                int row = (Integer)iterator.next();
                result.append(" ").append(row + 1).append(" >").append(rComparator.getLine(row)).append("\n");
            }
            unprintedRows.clear();
            result.append("\n");
        }
        if (diffsCount > this.maxFileDiffsCount) {
            result.append("... ").append(diffsCount - this.maxFileDiffsCount).append(" more differences in the file").append("\n");
        }
        this.reportError(result.toString());
    }

    private boolean isUncapturedFilesAllowed() {
        return this.allowUncapturedFiles && (this.notAllowedPatterns == null || this.notAllowedPatterns.length == 0);
    }

    private boolean isAllowedFile(String fileName) {
        if (!this.allowUncapturedFiles) {
            return false;
        }
        return !WSOptions.isIgnored((String)fileName, (String[])this.notAllowedPatterns);
    }

    private boolean isSkippedLine(String line) {
        if (line == null) {
            return false;
        }
        if (this.ignoredLinePatterns == null) {
            return false;
        }
        Pattern[] patternArray = this.ignoredLinePatterns;
        int n = this.ignoredLinePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern ignoredLine = patternArray[n2];
            Matcher matcher = ignoredLine.matcher(line);
            if (matcher.matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private InputStream getWSFileStream(WSFile file) throws IOException {
        if (file.getContent() == null) {
            return WSUtils.getFileStream((String)this.location, (WSFile)file, null);
        }
        if (Q7Features.getInstance().isTrue("q7.contexts.resources.transfer.zipped")) {
            ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(file.getContent()));
            zin.getNextEntry();
            return zin;
        }
        return new ByteArrayInputStream(file.getContent());
    }

    private String getFullPath(String path, IContainer folder) {
        return String.format("%s%s/", path, folder.getName());
    }

    private void reportError(String message) throws CoreException {
        message = message.replaceAll("%", "%%");
        this.errors.add(message, new Object[0]);
    }
}

