/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SearchControl
extends Composite {
    protected Text filterText;
    protected Control clearButtonControl;
    protected Composite parent;
    private Composite filterComposite;
    private Control searchResultControl;
    protected String initialText = "";
    private static Boolean useNativeSearchField;

    public SearchControl(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (SearchControl.useNativeSearchField(parent)) {
            this.filterComposite = new Composite((Composite)this, 0);
        } else {
            this.filterComposite = new Composite((Composite)this, 2048);
            this.filterComposite.setBackground(this.getDisplay().getSystemColor(25));
        }
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginHeight = 1;
        filterLayout.marginWidth = 1;
        this.filterComposite.setLayout((Layout)filterLayout);
        this.filterComposite.setFont(parent.getFont());
        this.createFilterControls(this.filterComposite);
        this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.filterText.setEnabled(enabled);
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setEnabled(enabled);
        }
        this.filterComposite.setEnabled(enabled);
    }

    protected void createFilterControls(Composite parent) {
        this.createFilterText(parent);
        this.createClearText(parent);
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setVisible(false);
        }
        this.setInitialText(Messages.SearchControl_InitialText);
    }

    private void createFilterText(Composite parent) {
        this.filterText = this.doCreateFilterText(parent);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        if ((this.filterText.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.filterText.setLayoutData((Object)gridData);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = SearchControl.this.filterText.getText();
                e.result = filterTextString.length() == 0 || filterTextString.equals(SearchControl.this.initialText) ? SearchControl.this.initialText : "";
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (SearchControl.this.filterText.getText().equals(SearchControl.this.initialText)) {
                    SearchControl.this.setFilterText("");
                    SearchControl.this.textChanged();
                }
            }
        });
        this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (SearchControl.this.filterText.getText().equals(SearchControl.this.initialText)) {
                    SearchControl.this.setFilterText("");
                    SearchControl.this.textChanged();
                }
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (SearchControl.this.searchResultControl != null && e.keyCode == 0x1000002) {
                    SearchControl.this.searchResultControl.setFocus();
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (SearchControl.this.searchResultControl != null) {
                        SearchControl.this.searchResultControl.setFocus();
                        SearchControl.this.onCR();
                    }
                }
            }
        });
        if ((this.filterText.getStyle() & 0x100) != 0) {
            this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (e.detail == 256) {
                        SearchControl.this.clearText();
                    }
                }
            });
        }
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchControl.this.textChanged();
            }
        });
    }

    public void onCR() {
    }

    protected Text doCreateFilterText(Composite parent) {
        if (SearchControl.useNativeSearchField(parent)) {
            return new Text(parent, 2436);
        }
        return new Text(parent, 4);
    }

    private void createClearText(Composite parent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            final ImageDescriptor inactiveImage = Images.getImageDescriptor("icons/search_clear_disabled.gif");
            final ImageDescriptor activeImageDescriptor = Images.getImageDescriptor("icons/search_clear.gif");
            final Label clearButton = new Label(parent, 0);
            clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            clearButton.setImage(inactiveImage.createImage());
            clearButton.setBackground(parent.getDisplay().getSystemColor(25));
            clearButton.setToolTipText(Messages.SearchControl_ClearToolTip);
            clearButton.addMouseListener((MouseListener)new MouseAdapter(){
                private MouseMoveListener fMoveListener;

                public void mouseDown(MouseEvent e) {
                    Image ac = activeImageDescriptor.createImage();
                    clearButton.setImage(new Image((Device)SearchControl.this.getDisplay(), ac, 2));
                    ac.dispose();
                    this.fMoveListener = new MouseMoveListener(){
                        private boolean fMouseInButton = true;

                        public void mouseMove(MouseEvent e) {
                            boolean mouseInButton = this.isMouseInButton(e);
                            if (mouseInButton != this.fMouseInButton) {
                                this.fMouseInButton = mouseInButton;
                                clearButton.setImage(mouseInButton ? new Image((Device)SearchControl.this.getDisplay(), activeImageDescriptor.createImage(), 2) : inactiveImage.createImage());
                            }
                        }
                    };
                    clearButton.addMouseMoveListener(this.fMoveListener);
                }

                public void mouseUp(MouseEvent e) {
                    if (this.fMoveListener != null) {
                        clearButton.removeMouseMoveListener(this.fMoveListener);
                        this.fMoveListener = null;
                        boolean mouseInButton = this.isMouseInButton(e);
                        clearButton.setImage(mouseInButton ? activeImageDescriptor.createImage() : inactiveImage.createImage());
                        if (mouseInButton) {
                            SearchControl.this.clearText();
                            SearchControl.this.filterText.setFocus();
                        }
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = clearButton.getSize();
                    return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
                }
            });
            clearButton.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    clearButton.setImage(activeImageDescriptor.createImage());
                }

                public void mouseExit(MouseEvent e) {
                    clearButton.setImage(inactiveImage.createImage());
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = Messages.SearchControl_ClearResult;
                }
            });
            clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
            this.clearButtonControl = clearButton;
        }
    }

    public String getInitialText() {
        return this.initialText;
    }

    public void setInitialText(String text) {
        this.initialText = text;
        if (this.filterText != null) {
            this.filterText.setMessage(text);
            if (this.filterText.isFocusControl()) {
                this.setFilterText(this.initialText);
                this.textChanged();
            } else {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SearchControl.this.filterText.isDisposed() && SearchControl.this.filterText.isFocusControl()) {
                            SearchControl.this.setFilterText(SearchControl.this.initialText);
                            SearchControl.this.textChanged();
                        }
                    }
                });
            }
        } else {
            this.setFilterText(this.initialText);
            this.textChanged();
        }
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    protected void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    public String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    public Control getSearchResultControl() {
        return this.searchResultControl;
    }

    public void setSearchResultControl(Control searchResultControl) {
        this.searchResultControl = searchResultControl;
    }

    protected void textChanged() {
        if (this.clearButtonControl != null) {
            boolean haveText = this.filterText != null && !this.filterText.getText().equals("") && !this.filterText.getText().equals(this.initialText);
            this.clearButtonControl.setVisible(haveText);
        }
    }

    private static boolean useNativeSearchField(Composite composite) {
        if (useNativeSearchField == null) {
            useNativeSearchField = Boolean.FALSE;
            Text testText = null;
            try {
                testText = new Text(composite, 384);
                useNativeSearchField = new Boolean((testText.getStyle() & 0x100) != 0);
            }
            finally {
                if (testText != null) {
                    testText.dispose();
                }
            }
        }
        return useNativeSearchField;
    }
}

